/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.util.ClassNodeCache;
import io.papermc.paperweight.util.FileKt;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.org.objectweb.asm.ClassWriter;
import paper.libs.org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0013"}, d2={"Lio/papermc/paperweight/util/FixJar;", "", "()V", "processClass", "", "file", "Ljava/nio/file/Path;", "outFile", "classNodeCache", "Lio/papermc/paperweight/util/ClassNodeCache;", "processor", "Lio/papermc/paperweight/util/FixJar$ClassProcessor;", "processFile", "output", "Ljava/nio/file/FileSystem;", "processJars", "jarFile", "fallbackJar", "ClassProcessor", "paperweight-lib"})
public final class FixJar {
    @NotNull
    public static final FixJar INSTANCE;

    public final void processJars(@NotNull FileSystem jarFile, @NotNull FileSystem output, @NotNull ClassProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.processJars(jarFile, null, output, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processJars(@NotNull FileSystem jarFile, @Nullable FileSystem fallbackJar, @NotNull FileSystem output, @NotNull ClassProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        ClassNodeCache classNodeCache = new ClassNodeCache(jarFile, fallbackJar);
        AutoCloseable autoCloseable = FileKt.walk(jarFile);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl3 = false;
            stream.forEach(new Consumer(output, classNodeCache, processor){
                final /* synthetic */ FileSystem $output$inlined;
                final /* synthetic */ ClassNodeCache $classNodeCache$inlined;
                final /* synthetic */ ClassProcessor $processor$inlined;
                {
                    this.$output$inlined = fileSystem;
                    this.$classNodeCache$inlined = classNodeCache;
                    this.$processor$inlined = classProcessor;
                }

                public final void accept(Path file) {
                    Path path = file;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file");
                    FixJar.access$processFile(FixJar.INSTANCE, path, this.$output$inlined, this.$classNodeCache$inlined, this.$processor$inlined);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void processFile(Path file, FileSystem output, ClassNodeCache classNodeCache, ClassProcessor processor) {
        Path path = file;
        boolean bl = false;
        Path outFile = output.getPath(((Object)path.toAbsolutePath()).toString(), new String[0]);
        path = file;
        Object object = new LinkOption[]{};
        boolean bl2 = false;
        if (Files.isDirectory(path, Arrays.copyOf(object, ((LinkOption[])object).length))) {
            Path path2 = outFile;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"outFile");
            path = path2;
            object = new FileAttribute[]{};
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path, (FileAttribute[])Arrays.copyOf(object, ((Object[])object).length)), (String)"Files.createDirectories(this, *attributes)");
            return;
        }
        if (!StringsKt.endsWith$default((String)PathsKt.getName((Path)file), (String)".class", (boolean)false, (int)2, null)) {
            path = file;
            Path path3 = outFile;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"outFile");
            object = path3;
            bl2 = false;
            boolean bl3 = false;
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, (Path)object, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
            return;
        }
        if (processor.shouldProcess(file)) {
            Path path4 = outFile;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"outFile");
            this.processClass(file, path4, classNodeCache, processor);
        } else {
            path = file;
            Path path5 = outFile;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"outFile");
            object = path5;
            bl2 = false;
            boolean bl4 = false;
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path, (Path)object, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
        }
    }

    private final void processClass(Path file, Path outFile, ClassNodeCache classNodeCache, ClassProcessor processor) {
        ClassNode classNode = classNodeCache.findClass(((Object)file).toString());
        if (classNode == null) {
            String string = "No ClassNode found for known entry: " + PathsKt.getName((Path)file);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ClassNode node = classNode;
        processor.processClass(node, classNodeCache);
        ClassWriter writer = new ClassWriter(0);
        node.accept(writer);
        Path path = outFile;
        byte[] byArray2 = writer.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"writer.toByteArray()");
        byte[] byArray3 = byArray2;
        OpenOption[] openOptionArray = new OpenOption[]{};
        boolean bl = false;
        Files.write(path, byArray3, Arrays.copyOf(openOptionArray, openOptionArray.length));
    }

    private FixJar() {
    }

    static {
        FixJar fixJar2;
        INSTANCE = fixJar2 = new FixJar();
    }

    public static final /* synthetic */ void access$processFile(FixJar $this, Path file, FileSystem output, ClassNodeCache classNodeCache, ClassProcessor processor) {
        $this.processFile(file, output, classNodeCache, processor);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/util/FixJar$ClassProcessor;", "", "processClass", "", "node", "Lpaper/libs/org/objectweb/asm/tree/ClassNode;", "classNodeCache", "Lio/papermc/paperweight/util/ClassNodeCache;", "shouldProcess", "", "file", "Ljava/nio/file/Path;", "paperweight-lib"})
    public static interface ClassProcessor {
        default public boolean shouldProcess(@NotNull Path file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return true;
        }

        public void processClass(@NotNull ClassNode var1, @NotNull ClassNodeCache var2);
    }
}

