/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/papermc/paperweight/util/DelegatingOutputStream;", "Ljava/io/OutputStream;", "delegates", "", "([Ljava/io/OutputStream;)V", "", "write", "", "b", "", "paperweight-lib"})
public final class DelegatingOutputStream
extends OutputStream {
    private final Set<OutputStream> delegates;

    @Override
    public void write(int b) {
        for (OutputStream delegate : this.delegates) {
            delegate.write(b);
        }
    }

    public DelegatingOutputStream(OutputStream ... delegates) {
        Intrinsics.checkNotNullParameter((Object)delegates, (String)"delegates");
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"Collections.newSetFromMap(IdentityHashMap())");
        this.delegates = set;
        CollectionsKt.addAll((Collection)this.delegates, (Object[])delegates);
    }
}

