/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup.util;

import io.papermc.paperweight.DownloadService;
import io.papermc.paperweight.userdev.PaperweightUser;
import io.papermc.paperweight.userdev.internal.setup.UserdevSetup;
import io.papermc.paperweight.userdev.internal.setup.util.DownloadResult;
import io.papermc.paperweight.userdev.internal.setup.util.HashFunction;
import io.papermc.paperweight.userdev.internal.setup.util.HashFunctionBuilder;
import io.papermc.paperweight.userdev.internal.setup.util.UtilsKt;
import io.papermc.paperweight.util.FileKt;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a:\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u00132\u0019\b\u0002\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015\u00a2\u0006\u0002\b\u0018\u00a2\u0006\u0002\u0010\u0019\u001a\u001f\u0010\u001a\u001a\u00020\u00012\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013\u00a2\u0006\u0002\u0010\u001b\u001a\u0014\u0010\u001a\u001a\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u001c\u001a\u000e\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0014\u0010 \u001a\u00020\u00012\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001c\u001a\b\u0010\"\u001a\u00020\u0001H\u0002\u001a2\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170$*\u00020%2\u0006\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u001f2\b\b\u0002\u0010)\u001a\u00020\b\u001a\n\u0010*\u001a\u00020\u001f*\u00020\u001f\u001a\u0016\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0,*\u00020\u001f\u001a\n\u0010-\u001a\u00020\u001f*\u00020\u001f\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006."}, d2={"paperweightHash", "", "getPaperweightHash", "()Ljava/lang/String;", "paperweightHash$delegate", "Lkotlin/Lazy;", "ci", "Lorg/gradle/api/provider/Provider;", "", "Lorg/gradle/api/Project;", "getCi", "(Lorg/gradle/api/Project;)Lorg/gradle/api/provider/Provider;", "genSources", "getGenSources", "(Lorg/gradle/api/Project;)Z", "buildHashFunction", "Lio/papermc/paperweight/userdev/internal/setup/util/HashFunction;", "things", "", "", "op", "Lkotlin/Function1;", "Lio/papermc/paperweight/userdev/internal/setup/util/HashFunctionBuilder;", "", "Lkotlin/ExtensionFunctionType;", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lio/papermc/paperweight/userdev/internal/setup/util/HashFunction;", "hash", "([Ljava/lang/Object;)Ljava/lang/String;", "", "hashDirectory", "dir", "Ljava/nio/file/Path;", "hashFiles", "files", "hashPaperweightJar", "download", "Lio/papermc/paperweight/userdev/internal/setup/util/DownloadResult;", "Lio/papermc/paperweight/DownloadService;", "downloadName", "remote", "destination", "forceDownload", "siblingHashesFile", "siblingLogAndHashesFiles", "Lkotlin/Pair;", "siblingLogFile", "paperweight-userdev"})
public final class UtilsKt {
    private static final Lazy paperweightHash$delegate = LazyKt.lazy((Function0)paperweightHash.2.INSTANCE);

    private static final String getPaperweightHash() {
        Lazy lazy = paperweightHash$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @NotNull
    public static final Path siblingLogFile(@NotNull Path $this$siblingLogFile) {
        Intrinsics.checkNotNullParameter((Object)$this$siblingLogFile, (String)"$this$siblingLogFile");
        return FileKt.withDifferentExtension($this$siblingLogFile, "log");
    }

    @NotNull
    public static final Path siblingHashesFile(@NotNull Path $this$siblingHashesFile) {
        Intrinsics.checkNotNullParameter((Object)$this$siblingHashesFile, (String)"$this$siblingHashesFile");
        return FileKt.withDifferentExtension($this$siblingHashesFile, "hashes");
    }

    @NotNull
    public static final Pair<Path, Path> siblingLogAndHashesFiles(@NotNull Path $this$siblingLogAndHashesFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$siblingLogAndHashesFiles, (String)"$this$siblingLogAndHashesFiles");
        return new Pair((Object)UtilsKt.siblingLogFile($this$siblingLogAndHashesFiles), (Object)UtilsKt.siblingHashesFile($this$siblingLogAndHashesFiles));
    }

    @NotNull
    public static final String hash(Object ... things) {
        Intrinsics.checkNotNullParameter((Object)things, (String)"things");
        return UtilsKt.hash(ArraysKt.toList((Object[])things));
    }

    @NotNull
    public static final String hash(@NotNull List<? extends Object> things) {
        Intrinsics.checkNotNullParameter(things, (String)"things");
        boolean bl = false;
        ArrayList<Object> strings = new ArrayList<Object>();
        boolean bl2 = false;
        ArrayList<Object> paths = new ArrayList<Object>();
        for (Object object : things) {
            Object object2 = object;
            if (object2 instanceof String) {
                strings.add(object);
                continue;
            }
            if (object2 instanceof Path) {
                paths.add(object);
                continue;
            }
            if (object2 instanceof Iterable) {
                strings.add(UtilsKt.hash(CollectionsKt.filterNotNull((Iterable)((Iterable)object))));
                continue;
            }
            String string = "Unknown type: " + object.getClass().getName();
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return UtilsKt.hashFiles((List<? extends Path>)paths) + (strings.isEmpty() ? "" : "\n" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)strings), (CharSequence)"\n", null, null, (int)0, null, (Function1)hash.1.INSTANCE, (int)30, null));
    }

    @NotNull
    public static final String hashFiles(@NotNull List<? extends Path> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Sequence $this$sortedBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)files), (Function1)hashFiles.1.INSTANCE);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return SequencesKt.joinToString$default((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Path it = (Path)a;
                boolean bl2 = false;
                Path path = it;
                boolean bl3 = false;
                it = (Path)b;
                Comparable comparable = (Comparable)((Object)((Object)path).toString());
                bl2 = false;
                path = it;
                bl3 = false;
                String string = ((Object)path).toString();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        }), (CharSequence)"\n", null, null, (int)0, null, (Function1)hashFiles.3.INSTANCE, (int)30, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String hashDirectory(@NotNull Path dir) {
        String string;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        AutoCloseable autoCloseable = Files.walk(dir, new FileVisitOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl3 = false;
            List list = stream.filter(hashDirectory.1.1.INSTANCE).collect(Collectors.toList());
            Intrinsics.checkNotNullExpressionValue(list, (String)"stream.filter { it.isReg\u2026lect(Collectors.toList())");
            string = UtilsKt.hashFiles(list);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final DownloadResult<Unit> download(@NotNull DownloadService $this$download, @NotNull String downloadName, @NotNull String remote, @NotNull Path destination, boolean forceDownload) {
        Intrinsics.checkNotNullParameter((Object)$this$download, (String)"$this$download");
        Intrinsics.checkNotNullParameter((Object)downloadName, (String)"downloadName");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        hashFile = UtilsKt.siblingHashesFile(destination);
        if (forceDownload) ** GOTO lbl-1000
        var7_6 = hashFile;
        var8_8 = new LinkOption[]{};
        var9_9 = false;
        if (Files.isRegularFile(var7_6, Arrays.copyOf(var8_8, var8_8.length)) && Intrinsics.areEqual((Object)PathsKt.readText$default((Path)hashFile, null, (int)1, null), (Object)UtilsKt.hash(new Object[]{remote, destination}))) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = upToDate = false;
        }
        if (upToDate) {
            return new DownloadResult<Unit>(destination, false, Unit.INSTANCE);
        }
        UserdevSetup.Companion.getLOGGER().lifecycle(":executing 'download {}'", new Object[]{downloadName});
        v1 = destination.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"destination.parent");
        var7_6 = v1;
        var8_8 = new FileAttribute[]{};
        var9_9 = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(var7_6, (FileAttribute[])Arrays.copyOf(var8_8, var8_8.length)), (String)"Files.createDirectories(this, *attributes)");
        $i$f$measureTimeMillis = false;
        var10_11 = false;
        start$iv = System.currentTimeMillis();
        $i$a$-measureTimeMillis-UtilsKt$download$elapsed$1 = false;
        $this$download.download(remote, (Object)destination);
        elapsed = System.currentTimeMillis() - start$iv;
        UserdevSetup.Companion.getLOGGER().info("done executing 'download {}', took {}s", (Object)downloadName, (Object)((double)elapsed / 1000.0));
        PathsKt.writeText$default((Path)hashFile, (CharSequence)UtilsKt.hash(new Object[]{remote, destination}), null, (OpenOption[])new OpenOption[0], (int)2, null);
        return new DownloadResult<Unit>(destination, true, Unit.INSTANCE);
    }

    public static /* synthetic */ DownloadResult download$default(DownloadService downloadService, String string, String string2, Path path, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return UtilsKt.download(downloadService, string, string2, path, bl);
    }

    @NotNull
    public static final HashFunction buildHashFunction(@NotNull Object[] things, @NotNull Function1<? super HashFunctionBuilder, Unit> op) {
        Intrinsics.checkNotNullParameter((Object)things, (String)"things");
        Intrinsics.checkNotNullParameter(op, (String)"op");
        return new HashFunction(op, things){
            final /* synthetic */ Function1 $op;
            final /* synthetic */ Object[] $things;

            @NotNull
            public final String invoke() {
                HashFunctionBuilder builder = HashFunctionBuilder.Companion.create();
                this.$op.invoke((Object)builder);
                if (builder.getIncludePaperweightHash()) {
                    builder.include((Object)UtilsKt.access$getPaperweightHash$p());
                }
                builder.include(Arrays.copyOf(this.$things, this.$things.length));
                return UtilsKt.hash(builder);
            }
            {
                this.$op = function1;
                this.$things = objectArray;
            }
        };
    }

    public static /* synthetic */ HashFunction buildHashFunction$default(Object[] objectArray, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = buildHashFunction.1.INSTANCE;
        }
        return UtilsKt.buildHashFunction(objectArray, (Function1<? super HashFunctionBuilder, Unit>)function1);
    }

    private static final String hashPaperweightJar() {
        ProtectionDomain protectionDomain = PaperweightUser.class.getProtectionDomain();
        Intrinsics.checkNotNullExpressionValue((Object)protectionDomain, (String)"PaperweightUser::class.java.protectionDomain");
        CodeSource codeSource = protectionDomain.getCodeSource();
        Intrinsics.checkNotNullExpressionValue((Object)codeSource, (String)"PaperweightUser::class.j\u2026otectionDomain.codeSource");
        Path userdevShadowJar = Paths.get(codeSource.getLocation().toURI());
        Object[] objectArray = new Object[1];
        Path path = userdevShadowJar;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"userdevShadowJar");
        objectArray[0] = path;
        return UtilsKt.hash(objectArray);
    }

    @NotNull
    public static final Provider<Boolean> getCi(@NotNull Project $this$ci) {
        Intrinsics.checkNotNullParameter((Object)$this$ci, (String)"$this$ci");
        Provider provider = $this$ci.getProviders().environmentVariable("CI").forUseAtConfigurationTime().map((Transformer)ci.1.INSTANCE).orElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providers.environmentVar\u2026 }\n        .orElse(false)");
        return provider;
    }

    public static final boolean getGenSources(@NotNull Project $this$genSources) {
        Boolean prop;
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$genSources, (String)"$this$genSources");
        Object object = UtilsKt.getCi($this$genSources).get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ci.get()");
        boolean ci2 = (Boolean)object;
        Provider provider = $this$genSources.getProviders().gradleProperty("paperweight.experimental.genSources").forUseAtConfigurationTime();
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providers.gradleProperty\u2026rUseAtConfigurationTime()");
        String string = (String)provider.getOrNull();
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            bl = Boolean.parseBoolean(string2);
        } else {
            bl = null;
        }
        Boolean bl3 = prop = bl;
        return bl3 != null ? bl3 : !ci2;
    }

    public static final /* synthetic */ String access$getPaperweightHash$p() {
        return UtilsKt.getPaperweightHash();
    }

    public static final /* synthetic */ String access$hashPaperweightJar() {
        return UtilsKt.hashPaperweightJar();
    }
}

