/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.JsonElement;
import paper.libs.com.google.gson.JsonObject;
import paper.libs.com.google.gson.reflect.TypeToken;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\"\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\u0012"}, d2={"Lio/papermc/paperweight/tasks/ServerBundler;", "", "()V", "extractFromBundler", "", "bundlerJar", "Ljava/nio/file/Path;", "serverJar", "serverLibraryJars", "serverLibrariesTxt", "serverLibrariesList", "serverVersionsList", "versionJson", "extractLibraryJars", "bundlerZip", "extractServerJar", "outputVersionJson", "writeLibrariesTxt", "paperweight-lib"})
public final class ServerBundler {
    @NotNull
    public static final ServerBundler INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extractFromBundler(@NotNull Path bundlerJar, @NotNull Path serverJar, @NotNull Path serverLibraryJars, @Nullable Path serverLibrariesTxt, @Nullable Path serverLibrariesList, @Nullable Path serverVersionsList, @Nullable Path versionJson) {
        Intrinsics.checkNotNullParameter((Object)bundlerJar, (String)"bundlerJar");
        Intrinsics.checkNotNullParameter((Object)serverJar, (String)"serverJar");
        Intrinsics.checkNotNullParameter((Object)serverLibraryJars, (String)"serverLibraryJars");
        Closeable closeable = FileKt.openZip(bundlerJar);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Path path;
            Path path2;
            CopyOption[] copyOptionArray;
            boolean bl3;
            boolean bl4;
            Path path3;
            Path it;
            boolean bl5;
            boolean bl6;
            Path path4;
            Path root;
            FileSystem bundlerFs = (FileSystem)closeable;
            boolean bl7 = false;
            Iterable<Path> iterable = bundlerFs.getRootDirectories();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"bundlerFs.rootDirectories");
            Path path5 = root = (Path)CollectionsKt.first(iterable);
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"root");
            INSTANCE.extractServerJar(path5, serverJar, versionJson);
            INSTANCE.extractLibraryJars(root, serverLibraryJars);
            Path path6 = serverLibrariesTxt;
            if (path6 != null) {
                path4 = path6;
                bl6 = false;
                bl5 = false;
                it = path4;
                boolean bl8 = false;
                INSTANCE.writeLibrariesTxt(root, it);
            }
            Path path7 = serverLibrariesList;
            if (path7 != null) {
                path4 = path7;
                bl6 = false;
                bl5 = false;
                it = path4;
                boolean bl9 = false;
                Path path8 = root.resolve("META-INF/libraries.list");
                Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"root.resolve(FileEntry.LIBRARIES_LIST)");
                path3 = path8;
                bl4 = true;
                bl3 = false;
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Path path9 = Files.copy(path3, it, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
                path2 = path9;
                Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"Files.copy(this, target, *options)");
            } else {
                path2 = null;
            }
            Path path10 = serverVersionsList;
            if (path10 != null) {
                path4 = path10;
                bl6 = false;
                bl5 = false;
                it = path4;
                boolean bl10 = false;
                Path path11 = root.resolve("META-INF/versions.list");
                Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"root.resolve(FileEntry.VERSIONS_LIST)");
                path3 = path11;
                bl4 = true;
                bl3 = false;
                copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Path path12 = Files.copy(path3, it, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
                path = path12;
                Intrinsics.checkNotNullExpressionValue((Object)path12, (String)"Files.copy(this, target, *options)");
            } else {
                path = null;
            }
            Path path13 = path;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void extractServerJar(Path bundlerZip, Path serverJar, Path outputVersionJson) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object;
        Object type$iv$iv$iv;
        Object object2;
        Object $receiver$iv$iv;
        void $this$fromJson$iv;
        Path path;
        int n;
        Path serverVersionJson = bundlerZip.resolve("version.json");
        Path path2 = outputVersionJson;
        if (path2 != null) {
            Path path3 = path2;
            boolean bl = false;
            boolean bl2 = false;
            Path output = path3;
            boolean $i$a$-let-ServerBundler$extractServerJar$322 = false;
            Path path4 = serverVersionJson;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"serverVersionJson");
            Path path5 = path4;
            boolean bl3 = true;
            n = 0;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Path path6 = Files.copy(path5, output, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
            path = path6;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"Files.copy(this, target, *options)");
        } else {
            path = null;
        }
        Gson gson = UtilsKt.getGson();
        Path path7 = serverVersionJson;
        Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"serverVersionJson");
        Iterable<Path> any$iv = path7;
        boolean $i$f$fromJson22 = false;
        Path $i$a$-let-ServerBundler$extractServerJar$322 = any$iv;
        if ($i$a$-let-ServerBundler$extractServerJar$322 instanceof String) {
            Type type;
            $receiver$iv$iv = $this$fromJson$iv;
            String string = (String)((Object)any$iv);
            object2 = $receiver$iv$iv;
            Type type2 = new TypeToken<JsonObject>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
            type$iv$iv$iv = type2;
            if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                Type type3 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                type = type3;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
            } else {
                type = GsonBuilderKt.removeTypeWildcards((Type)type$iv$iv$iv);
            }
            Type type4 = type;
            Object t = ((Gson)object2).fromJson(string, type4);
            object = t;
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
        } else {
            $receiver$iv$iv = UtilsKt.convertToPath(any$iv);
            Charset charset = Charsets.UTF_8;
            type$iv$iv$iv = new OpenOption[]{};
            n = 8192;
            boolean bl = false;
            $receiver$iv$iv = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)$receiver$iv$iv, Arrays.copyOf(type$iv$iv$iv, ((OpenOption[])type$iv$iv$iv).length)), charset), n);
            boolean bl4 = false;
            n = 0;
            object2 = null;
            try {
                Type type;
                BufferedReader it$iv = (BufferedReader)$receiver$iv$iv;
                boolean bl5 = false;
                void $receiver$iv$iv2 = $this$fromJson$iv;
                Reader $i$f$typeToken = it$iv;
                void $i$f$fromJson = $receiver$iv$iv2;
                Type type5 = new TypeToken<JsonObject>(){}.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"object : TypeToken<T>() {} .type");
                Type type$iv$iv$iv2 = type5;
                if (type$iv$iv$iv2 instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv2)) {
                    Type type6 = ((ParameterizedType)type$iv$iv$iv2).getRawType();
                    type = type6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"type.rawType");
                } else {
                    type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv2);
                }
                Type type7 = type;
                Object t = $i$f$fromJson.fromJson($i$f$typeToken, type7);
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
                it$iv = t;
                object = it$iv;
            }
            catch (Throwable it$iv) {
                object2 = it$iv;
                throw it$iv;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$receiver$iv$iv, (Throwable)object2);
            }
        }
        JsonElement jsonElement = ((JsonObject)object).get("id");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"gson.fromJson<JsonObject>(serverVersionJson)[\"id\"]");
        String versionId = jsonElement.getAsString();
        Path path8 = bundlerZip.resolve("/META-INF/versions.list");
        Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"bundlerZip.resolve(\"/META-INF/versions.list\")");
        any$iv = path8;
        Charset $i$f$fromJson22 = Charsets.UTF_8;
        boolean $i$a$-let-ServerBundler$extractServerJar$322 = false;
        List<String> list = Files.readAllLines(any$iv, $i$f$fromJson22);
        Intrinsics.checkNotNullExpressionValue(list, (String)"Files.readAllLines(this, charset)");
        any$iv = list;
        boolean $i$f$map = false;
        void $i$a$-let-ServerBundler$extractServerJar$322 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl5 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            List list2 = StringsKt.split$default((CharSequence)((CharSequence)it), (char[])new char[]{'\t'}, (boolean)false, (int)0, (int)6, null);
            collection.add(list2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv2;
            List it = (List)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.get(1), it.get(2));
            boolean bl6 = false;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map versions = destination$iv$iv2;
        Path serverJarPath = bundlerZip.resolve("/META-INF/versions/" + (String)versions.get(versionId));
        Path path9 = serverJar.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"serverJar.parent");
        Path path10 = path9;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path10, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
        Path path11 = serverJarPath;
        Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"serverJarPath");
        path10 = path11;
        boolean bl7 = true;
        bl = false;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path10, serverJar, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
    }

    private final void extractLibraryJars(Path bundlerZip, Path serverLibraryJars) {
        FileKt.deleteRecursively$default(serverLibraryJars, null, 1, null);
        Path path = serverLibraryJars.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"serverLibraryJars.parent");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
        Path path3 = bundlerZip.resolve("/META-INF/libraries");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"bundlerZip.resolve(\"/META-INF/libraries\")");
        FileKt.copyRecursivelyTo(path3, serverLibraryJars);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeLibrariesTxt(Path bundlerZip, Path serverLibrariesTxt) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Path path = bundlerZip.resolve("META-INF/libraries.list");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"bundlerZip.resolve(FileEntry.LIBRARIES_LIST)");
        Iterable<Path> iterable = path;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        List<String> list = Files.readAllLines(iterable, charset);
        Intrinsics.checkNotNullExpressionValue(list, (String)"Files.readAllLines(this, charset)");
        iterable = list;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string2 = (String)StringsKt.split$default((CharSequence)((CharSequence)it), (char[])new char[]{'\t'}, (boolean)false, (int)0, (int)6, null).get(1);
            collection.add(string2);
        }
        List libs = (List)destination$iv$iv;
        Path path2 = serverLibrariesTxt.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"serverLibrariesTxt.parent");
        iterable = path2;
        Object object = new FileAttribute[]{};
        boolean bl3 = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(iterable, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"Files.createDirectories(this, *attributes)");
        iterable = serverLibrariesTxt;
        OpenOption[] openOptionArray = new OpenOption[]{};
        object = Charsets.UTF_8;
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.write(iterable, (Iterable<? extends CharSequence>)libs, (Charset)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (String)"Files.write(this, lines, charset, *options)");
    }

    private ServerBundler() {
    }

    static {
        ServerBundler serverBundler;
        INSTANCE = serverBundler = new ServerBundler();
    }
}

