/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.ApplyGitPatchesKt;
import io.papermc.paperweight.tasks.ControllableOutputTask;
import io.papermc.paperweight.util.Command;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Git;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.ZipKt;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00128gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007\u00a8\u0006$"}, d2={"Lio/papermc/paperweight/tasks/ApplyGitPatches;", "Lio/papermc/paperweight/tasks/ControllableOutputTask;", "()V", "branch", "Lorg/gradle/api/provider/Property;", "", "getBranch", "()Lorg/gradle/api/provider/Property;", "ignoreGitIgnore", "", "getIgnoreGitIgnore", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "patchDir", "getPatchDir", "patchZip", "Lorg/gradle/api/file/RegularFileProperty;", "getPatchZip", "()Lorg/gradle/api/file/RegularFileProperty;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "unneededFiles", "Lorg/gradle/api/provider/ListProperty;", "getUnneededFiles", "()Lorg/gradle/api/provider/ListProperty;", "upstream", "getUpstream", "upstreamBranch", "getUpstreamBranch", "init", "", "run", "paperweight-lib"})
public abstract class ApplyGitPatches
extends ControllableOutputTask {
    @Input
    @NotNull
    public abstract Property<String> getBranch();

    @Input
    @NotNull
    public abstract Property<String> getUpstreamBranch();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getUpstream();

    @Optional
    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getPatchDir();

    @Optional
    @InputFile
    @NotNull
    public abstract RegularFileProperty getPatchZip();

    @Optional
    @Input
    @NotNull
    public abstract ListProperty<String> getUnneededFiles();

    @Input
    @NotNull
    public abstract Property<Boolean> getIgnoreGitIgnore();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Inject
    @NotNull
    public abstract ProviderFactory getProviders();

    @Override
    public void init() {
        this.getPrintOutput().convention((Object)false).finalizeValueOnRead();
        this.getIgnoreGitIgnore().convention(Git.Companion.ignoreProperty(this.getProviders())).finalizeValueOnRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void run() {
        boolean bl;
        boolean bl2;
        Object object;
        Path path;
        Git.Companion.checkForGit();
        Git git = new Git(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getUpstream())), null, 2, null);
        boolean bl3 = false;
        boolean bl4 = false;
        Git git2 = git;
        boolean bl5 = false;
        ControllableOutputTask.setupOut$default(this, git2.invoke("fetch"), false, 1, null).run();
        String[] stringArray = new String[4];
        stringArray[0] = "branch";
        stringArray[1] = "-f";
        Object object2 = this.getUpstreamBranch().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"upstreamBranch.get()");
        stringArray[2] = (String)object2;
        Object object3 = this.getBranch().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"branch.get()");
        stringArray[3] = (String)object3;
        Command.runSilently$default(git2.invoke(stringArray), false, true, 1, null);
        Path outputPath = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputDir()));
        ApplyGitPatchesKt.recreateCloneDirectory(outputPath);
        String target = PathsKt.getName((Path)outputPath);
        Object object4 = this.getPrintOutput().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"printOutput.get()");
        if (((Boolean)object4).booleanValue()) {
            String string = "   Resetting " + target + " to " + PathsKt.getName((Path)FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getUpstream()))) + "...";
            boolean bl6 = false;
            System.out.println((Object)string);
        }
        if ((path = FileKt.getPathOrNull((Provider<? extends FileSystemLocation>)((Provider)this.getPatchDir()))) == null) {
            object = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getPatchZip()));
            bl2 = false;
            bl = false;
            Path it = object;
            boolean bl7 = false;
            path = ZipKt.unzip(it, UtilsKt.findOutputDir(it));
        }
        Path rootPatchDir = path;
        try {
            object = new Git(outputPath, null, 2, null);
            bl2 = false;
            bl = false;
            Object git3 = object;
            boolean bl8 = false;
            Path path2 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getUpstream()));
            Object object5 = this.getUpstreamBranch().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"upstreamBranch.get()");
            ApplyGitPatchesKt.checkoutRepoFromUpstream((Git)git3, path2, (String)object5);
            if (this.getUnneededFiles().isPresent() && ((List)this.getUnneededFiles().get()).size() > 0) {
                Object object6 = this.getUnneededFiles().get();
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"unneededFiles.get()");
                Iterable $this$forEach$iv = (Iterable)object6;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String path3 = (String)element$iv;
                    boolean bl9 = false;
                    Path path4 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputDir())).resolve(path3);
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"outputDir.path.resolve(path)");
                    FileKt.deleteRecursively$default(path4, null, 1, null);
                }
                String[] stringArray2 = Git.Companion.add((Provider<Boolean>)((Provider)this.getIgnoreGitIgnore()), ".");
                ControllableOutputTask.setupOut$default(this, ((Git)git3).invoke(Arrays.copyOf(stringArray2, stringArray2.length)), false, 1, null).run();
                ControllableOutputTask.setupOut$default(this, ((Git)git3).invoke("commit", "-m", "Initial", "--author=Initial Source <auto@mated.null>"), false, 1, null).run();
            }
            Command.runSilently$default(((Git)git3).invoke("tag", "-d", "base"), false, true, 1, null);
            Command.executeSilently$default(((Git)git3).invoke("tag", "base"), false, true, 1, null);
            Path path5 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputDir()));
            Object object7 = this.getPrintOutput().get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"printOutput.get()");
            ApplyGitPatchesKt.applyGitPatches(this, (Git)git3, target, path5, rootPatchDir, (Boolean)object7);
        }
        finally {
            if (Intrinsics.areEqual((Object)rootPatchDir, (Object)FileKt.getPathOrNull((Provider<? extends FileSystemLocation>)((Provider)this.getPatchDir()))) ^ true) {
                FileKt.deleteRecursively$default(rootPatchDir, null, 1, null);
            }
        }
    }
}

