/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.jgrapht.generate;

import java.util.LinkedList;
import java.util.Map;
import paper.libs.org.jgrapht.Graph;
import paper.libs.org.jgrapht.generate.GraphGenerator;

public class HyperCubeGraphGenerator<V, E>
implements GraphGenerator<V, E, V> {
    private int dim;

    public HyperCubeGraphGenerator(int dim) {
        this.dim = dim;
    }

    @Override
    public void generateGraph(Graph<V, E> target, Map<String, V> resultMap) {
        int i2;
        int order = (int)Math.pow(2.0, this.dim);
        LinkedList<V> vertices = new LinkedList<V>();
        for (i2 = 0; i2 < order; ++i2) {
            V newVertex = target.addVertex();
            vertices.add(newVertex);
            if (resultMap == null) continue;
            StringBuilder s = new StringBuilder(Integer.toBinaryString(i2));
            while (s.length() < this.dim) {
                s.insert(0, "0");
            }
            resultMap.put(s.toString(), newVertex);
        }
        for (i2 = 0; i2 < order; ++i2) {
            block3: for (int j = i2 + 1; j < order; ++j) {
                for (int z = 0; z < this.dim; ++z) {
                    if ((j ^ i2) != 1 << z) continue;
                    target.addEdge(vertices.get(i2), vertices.get(j));
                    continue block3;
                }
            }
        }
    }
}

