/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.text.edits;

import java.util.List;
import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.jface.text.BadLocationException;
import paper.libs.org.eclipse.jface.text.IDocument;
import paper.libs.org.eclipse.jface.text.IRegion;
import paper.libs.org.eclipse.text.edits.MalformedTreeException;
import paper.libs.org.eclipse.text.edits.TextEdit;
import paper.libs.org.eclipse.text.edits.TextEditProcessor;
import paper.libs.org.eclipse.text.edits.TextEditVisitor;

public class MultiTextEdit
extends TextEdit {
    private boolean fDefined;

    public MultiTextEdit() {
        super(0, Integer.MAX_VALUE);
        this.fDefined = false;
    }

    public MultiTextEdit(int offset, int length) {
        super(offset, length);
        this.fDefined = true;
    }

    protected MultiTextEdit(MultiTextEdit other) {
        super(other);
    }

    protected void checkIntegrity() throws MalformedTreeException {
    }

    @Override
    final boolean isDefined() {
        if (this.fDefined) {
            return true;
        }
        return this.hasChildren();
    }

    @Override
    public final int getOffset() {
        if (this.fDefined) {
            return super.getOffset();
        }
        List<TextEdit> children = this.internalGetChildren();
        if (children == null || children.isEmpty()) {
            return 0;
        }
        return children.get(0).getOffset();
    }

    @Override
    public final int getLength() {
        if (this.fDefined) {
            return super.getLength();
        }
        List<TextEdit> children = this.internalGetChildren();
        if (children == null || children.isEmpty()) {
            return 0;
        }
        TextEdit first = children.get(0);
        TextEdit last = children.get(children.size() - 1);
        return last.getOffset() - first.getOffset() + last.getLength();
    }

    @Override
    public final boolean covers(TextEdit other) {
        if (this.fDefined) {
            return super.covers(other);
        }
        return true;
    }

    @Override
    protected boolean canZeroLengthCover() {
        return true;
    }

    @Override
    protected TextEdit doCopy() {
        Assert.isTrue(MultiTextEdit.class == this.getClass(), "Subclasses must reimplement copy0");
        return new MultiTextEdit(this);
    }

    @Override
    protected void accept0(TextEditVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChildren(visitor);
        }
    }

    @Override
    void adjustOffset(int delta) {
        if (this.fDefined) {
            super.adjustOffset(delta);
        }
    }

    @Override
    void adjustLength(int delta) {
        if (this.fDefined) {
            super.adjustLength(delta);
        }
    }

    @Override
    void performConsistencyCheck(TextEditProcessor processor, IDocument document) throws MalformedTreeException {
        this.checkIntegrity();
    }

    @Override
    int performDocumentUpdating(IDocument document) throws BadLocationException {
        this.fDelta = 0;
        return this.fDelta;
    }

    @Override
    boolean deleteChildren() {
        return false;
    }

    @Override
    void aboutToBeAdded(TextEdit parent) {
        this.defineRegion(parent.getOffset());
    }

    void defineRegion(int parentOffset) {
        if (this.fDefined) {
            return;
        }
        if (this.hasChildren()) {
            IRegion region = MultiTextEdit.getCoverage(this.getChildren());
            this.internalSetOffset(region.getOffset());
            this.internalSetLength(region.getLength());
        } else {
            this.internalSetOffset(parentOffset);
            this.internalSetLength(0);
        }
        this.fDefined = true;
    }

    @Override
    void internalToString(StringBuilder buffer, int indent) {
        super.internalToString(buffer, indent);
        if (!this.fDefined) {
            buffer.append(" [undefined]");
        }
    }
}

