/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.weaving;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import paper.libs.org.eclipse.osgi.internal.framework.EquinoxContainer;
import paper.libs.org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import paper.libs.org.eclipse.osgi.internal.loader.BundleLoader;
import paper.libs.org.eclipse.osgi.internal.loader.ModuleClassLoader;
import paper.libs.org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import paper.libs.org.eclipse.osgi.internal.loader.classpath.ClasspathManager;
import paper.libs.org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import paper.libs.org.eclipse.osgi.internal.weaving.WovenClassImpl;
import paper.libs.org.eclipse.osgi.storage.bundlefile.BundleEntry;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.ServiceRegistration;

public class WeavingHookConfigurator
extends ClassLoaderHook {
    private final Map<ServiceRegistration<?>, Boolean> deniedHooks = Collections.synchronizedMap(new WeakHashMap());
    private final ThreadLocal<WovenClassContext> wovenClassContext = new ThreadLocal();
    private final EquinoxContainer container;

    public WeavingHookConfigurator(EquinoxContainer container) {
        this.container = container;
    }

    private ServiceRegistry getRegistry() {
        return this.container.getServiceRegistry();
    }

    @Override
    public byte[] processClass(String name2, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        ServiceRegistry registry = this.getRegistry();
        if (registry == null) {
            return null;
        }
        ModuleClassLoader classLoader = manager.getClassLoader();
        BundleLoader loader = classLoader.getBundleLoader();
        WovenClassImpl wovenClass = new WovenClassImpl(name2, classbytes, entry, classpathEntry, loader, this.container, this.deniedHooks);
        WovenClassContext context = this.wovenClassContext.get();
        if (context == null) {
            context = new WovenClassContext();
            this.wovenClassContext.set(context);
        }
        context.wovenClassStack.add(wovenClass);
        if (!context.processClassNameStack.contains(name2)) {
            context.processClassNameStack.add(name2);
            try {
                byte[] byArray2 = wovenClass.callHooks();
                return byArray2;
            }
            catch (Throwable t) {
                ServiceRegistration<?> errorHook = wovenClass.getErrorHook();
                Bundle errorBundle = errorHook != null ? errorHook.getReference().getBundle() : manager.getGeneration().getRevision().getBundle();
                this.container.getEventPublisher().publishFrameworkEvent(2, errorBundle, t);
                ClassFormatError error = new ClassFormatError("Unexpected error from weaving hook.");
                error.initCause(t);
                throw error;
            }
            finally {
                context.processClassNameStack.remove(name2);
            }
        }
        return null;
    }

    @Override
    public void recordClassDefine(String name2, Class<?> clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        WovenClassContext context = this.wovenClassContext.get();
        if (context == null || context.wovenClassStack.size() == 0) {
            return;
        }
        WovenClassImpl wovenClass = context.wovenClassStack.remove(context.wovenClassStack.size() - 1);
        wovenClass.setWeavingCompleted(clazz);
    }

    @Override
    public boolean isProcessClassRecursionSupported() {
        return true;
    }

    static class WovenClassContext {
        List<WovenClassImpl> wovenClassStack = new ArrayList<WovenClassImpl>(6);
        List<String> processClassNameStack = new ArrayList<String>(6);

        WovenClassContext() {
        }
    }
}

