/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.provisional.service.security;

import java.util.HashMap;
import paper.libs.org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import paper.libs.org.eclipse.osgi.framework.eventmgr.EventManager;
import paper.libs.org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import paper.libs.org.eclipse.osgi.internal.provisional.service.security.AuthorizationEvent;
import paper.libs.org.eclipse.osgi.internal.provisional.service.security.AuthorizationListener;
import paper.libs.org.eclipse.osgi.signedcontent.SignedContent;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.util.tracker.ServiceTracker;

public abstract class AuthorizationEngine {
    private EventManager manager = new EventManager();
    private EventDispatcher<AuthorizationListener, Object, AuthorizationEvent> dispatcher = new AuthEventDispatcher();
    private final ServiceTracker<AuthorizationListener, AuthorizationListener> listenerTracker;

    public AuthorizationEngine(BundleContext context) {
        this.listenerTracker = new ServiceTracker(context, AuthorizationListener.class.getName(), null);
        this.listenerTracker.open();
    }

    public final void authorize(SignedContent content, Object context) {
        this.fireEvent(this.doAuthorize(content, context));
    }

    private void fireEvent(AuthorizationEvent event) {
        if (event == null) {
            return;
        }
        Object[] services = this.listenerTracker.getServices();
        if (services == null) {
            return;
        }
        HashMap<AuthorizationListener, Object> listeners = new HashMap<AuthorizationListener, Object>();
        Object[] objectArray = services;
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            Object service = objectArray[n2];
            listeners.put((AuthorizationListener)service, service);
            ++n2;
        }
        ListenerQueue<AuthorizationListener, Object, AuthorizationEvent> queue2 = new ListenerQueue<AuthorizationListener, Object, AuthorizationEvent>(this.manager);
        queue2.queueListeners(listeners.entrySet(), this.dispatcher);
        queue2.dispatchEventSynchronous(0, event);
    }

    protected abstract AuthorizationEvent doAuthorize(SignedContent var1, Object var2);

    public abstract int getStatus();

    class AuthEventDispatcher
    implements EventDispatcher<AuthorizationListener, Object, AuthorizationEvent> {
        AuthEventDispatcher() {
        }

        @Override
        public void dispatchEvent(AuthorizationListener eventListener, Object listenerObject, int eventAction, AuthorizationEvent eventObject) {
            eventListener.authorizationEvent(eventObject);
        }
    }
}

