/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.osgi.internal.log;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import paper.libs.org.eclipse.equinox.log.ExtendedLogReaderService;
import paper.libs.org.eclipse.equinox.log.ExtendedLogService;
import paper.libs.org.eclipse.equinox.log.LogFilter;
import paper.libs.org.eclipse.osgi.internal.framework.BundleContextImpl;
import paper.libs.org.eclipse.osgi.internal.log.ConfigAdminListener;
import paper.libs.org.eclipse.osgi.internal.log.EventAdminAdapter;
import paper.libs.org.eclipse.osgi.internal.log.ExtendedLogReaderServiceFactory;
import paper.libs.org.eclipse.osgi.internal.log.ExtendedLogServiceFactory;
import paper.libs.org.eclipse.osgi.internal.log.ExtendedLogServiceImpl;
import paper.libs.org.eclipse.osgi.internal.log.LoggerImpl;
import paper.libs.org.osgi.framework.AllServiceListener;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.framework.BundleEvent;
import paper.libs.org.osgi.framework.FrameworkEvent;
import paper.libs.org.osgi.framework.FrameworkListener;
import paper.libs.org.osgi.framework.ServiceEvent;
import paper.libs.org.osgi.framework.ServiceReference;
import paper.libs.org.osgi.framework.ServiceRegistration;
import paper.libs.org.osgi.framework.SynchronousBundleListener;
import paper.libs.org.osgi.framework.Version;
import paper.libs.org.osgi.service.log.LogLevel;
import paper.libs.org.osgi.service.log.LogListener;
import paper.libs.org.osgi.service.log.LogReaderService;
import paper.libs.org.osgi.service.log.LogService;
import paper.libs.org.osgi.service.log.LoggerFactory;
import paper.libs.org.osgi.service.log.admin.LoggerAdmin;

public class LogServiceManager
implements SynchronousBundleListener,
FrameworkListener,
AllServiceListener {
    private static final String LOGGER_FRAMEWORK_EVENT = "Events.Framework";
    private static final String LOGGER_BUNDLE_EVENT = "Events.Bundle";
    private static final String LOGGER_SERVICE_EVENT = "Events.Service";
    private static final String[] LOGSERVICE_CLASSES = new String[]{LogService.class.getName(), LoggerFactory.class.getName(), ExtendedLogService.class.getName()};
    private static final String[] LOGREADERSERVICE_CLASSES = new String[]{LogReaderService.class.getName(), ExtendedLogReaderService.class.getName()};
    private ServiceRegistration<?> logReaderServiceRegistration;
    private ServiceRegistration<?> logServiceRegistration;
    private ServiceRegistration<LoggerAdmin> loggerAdminRegistration;
    private final ExtendedLogReaderServiceFactory logReaderServiceFactory;
    private final ExtendedLogServiceFactory logServiceFactory;
    private final ExtendedLogServiceImpl systemBundleLog;
    private EventAdminAdapter eventAdminAdapter;
    private ConfigAdminListener configAdminListener;

    public LogServiceManager(int maxHistory, LogLevel defaultLevel, boolean captureLogEntryLocation, LogListener ... systemListeners) {
        this.logReaderServiceFactory = new ExtendedLogReaderServiceFactory(maxHistory, defaultLevel);
        this.logServiceFactory = new ExtendedLogServiceFactory(this.logReaderServiceFactory, captureLogEntryLocation);
        this.systemBundleLog = this.logServiceFactory.getLogService(new MockSystemBundle());
        LogListener[] logListenerArray = systemListeners;
        int n = systemListeners.length;
        int n2 = 0;
        while (n2 < n) {
            LogListener logListener = logListenerArray[n2];
            if (logListener instanceof LogFilter) {
                this.logReaderServiceFactory.addLogListener(logListener, (LogFilter)((Object)logListener));
            } else {
                this.logReaderServiceFactory.addLogListener(logListener, ExtendedLogReaderServiceFactory.NULL_LOGGER_FILTER);
            }
            ++n2;
        }
    }

    public void start(BundleContext context) {
        this.logReaderServiceFactory.start(((BundleContextImpl)context).getContainer());
        this.systemBundleLog.setBundle(context.getBundle());
        context.addBundleListener(this);
        context.addServiceListener(this);
        context.addFrameworkListener(this);
        context.addBundleListener(this.logServiceFactory);
        this.logReaderServiceRegistration = context.registerService(LOGREADERSERVICE_CLASSES, (Object)this.logReaderServiceFactory, null);
        this.logServiceRegistration = context.registerService(LOGSERVICE_CLASSES, (Object)this.logServiceFactory, null);
        Hashtable<String, Object> loggerAdminProps = new Hashtable<String, Object>();
        loggerAdminProps.put("osgi.log.service.id", this.logServiceRegistration.getReference().getProperty("service.id"));
        this.loggerAdminRegistration = context.registerService(LoggerAdmin.class, this.logServiceFactory.getLoggerAdmin(), loggerAdminProps);
        this.eventAdminAdapter = new EventAdminAdapter(context, this.logReaderServiceFactory);
        this.eventAdminAdapter.start();
        this.configAdminListener = new ConfigAdminListener(context, this.logServiceFactory);
        this.configAdminListener.start();
    }

    public void stop(BundleContext context) {
        this.configAdminListener.stop();
        this.configAdminListener = null;
        this.eventAdminAdapter.stop();
        this.eventAdminAdapter = null;
        this.loggerAdminRegistration.unregister();
        this.loggerAdminRegistration = null;
        this.logServiceRegistration.unregister();
        this.logServiceRegistration = null;
        this.logReaderServiceRegistration.unregister();
        this.logReaderServiceRegistration = null;
        this.logServiceFactory.shutdown();
        context.removeFrameworkListener(this);
        context.removeServiceListener(this);
        context.removeBundleListener(this);
        this.logReaderServiceFactory.stop();
    }

    public ExtendedLogService getSystemBundleLog() {
        return this.systemBundleLog;
    }

    LoggerAdmin getLoggerAdmin() {
        return this.logServiceFactory.getLoggerAdmin();
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        String loggerName;
        Bundle bundle = event.getBundle();
        String bsn = bundle == null ? null : bundle.getSymbolicName();
        String string = loggerName = bsn == null ? LOGGER_BUNDLE_EVENT : "Events.Bundle." + bsn;
        if (this.logReaderServiceFactory.isLoggable(bundle, loggerName, 3)) {
            LoggerImpl logger = (LoggerImpl)this.systemBundleLog.getLogger(loggerName);
            int eventType = event.getType();
            logger.log(bundle, event, null, 3, LogServiceManager.getBundleEventTypeName(eventType), null, null);
        }
    }

    @Override
    public void serviceChanged(ServiceEvent event) {
        int logType;
        ServiceReference<?> reference = event.getServiceReference();
        Bundle bundle = reference.getBundle();
        int eventType = event.getType();
        String bsn = bundle == null ? null : bundle.getSymbolicName();
        String loggerName = bsn == null ? LOGGER_SERVICE_EVENT : "Events.Service." + bsn;
        int n = logType = eventType == 2 ? 4 : 3;
        if (this.logReaderServiceFactory.isLoggable(bundle, loggerName, logType)) {
            LoggerImpl logger = (LoggerImpl)this.systemBundleLog.getLogger(loggerName);
            logger.log(bundle, event, null, logType, LogServiceManager.getServiceEventTypeName(eventType), reference, null);
        }
    }

    @Override
    public void frameworkEvent(FrameworkEvent event) {
        String loggerName;
        int logType;
        Bundle bundle = event.getBundle();
        int eventType = event.getType();
        switch (eventType) {
            case 2: {
                logType = 1;
                break;
            }
            case 16: {
                logType = 2;
                break;
            }
            default: {
                logType = 3;
            }
        }
        String bsn = bundle == null ? null : bundle.getSymbolicName();
        String string = loggerName = bsn == null ? LOGGER_FRAMEWORK_EVENT : "Events.Framework." + bsn;
        if (this.logReaderServiceFactory.isLoggable(bundle, loggerName, logType)) {
            LoggerImpl logger = (LoggerImpl)this.systemBundleLog.getLogger(loggerName);
            logger.log(bundle, event, null, logType, LogServiceManager.getFrameworkEventTypeName(eventType), null, event.getThrowable());
        }
    }

    private static String getBundleEventTypeName(int type) {
        switch (type) {
            case 1: {
                return "BundleEvent INSTALLED";
            }
            case 32: {
                return "BundleEvent RESOLVED";
            }
            case 2: {
                return "BundleEvent STARTED";
            }
            case 128: {
                return "BundleEvent STARTING";
            }
            case 4: {
                return "BundleEvent STOPPED";
            }
            case 256: {
                return "BundleEvent STOPPING";
            }
            case 16: {
                return "BundleEvent UNINSTALLED";
            }
            case 64: {
                return "BundleEvent UNRESOLVED";
            }
            case 8: {
                return "BundleEvent UPDATED";
            }
        }
        return "BundleEvent " + Integer.toHexString(type);
    }

    private static String getServiceEventTypeName(int type) {
        switch (type) {
            case 1: {
                return "ServiceEvent REGISTERED";
            }
            case 2: {
                return "ServiceEvent MODIFIED";
            }
            case 4: {
                return "ServiceEvent UNREGISTERING";
            }
        }
        return "ServiceEvent " + Integer.toHexString(type);
    }

    private static String getFrameworkEventTypeName(int type) {
        switch (type) {
            case 2: {
                return "FrameworkEvent ERROR";
            }
            case 32: {
                return "FrameworkEvent INFO";
            }
            case 4: {
                return "FrameworkEvent PACKAGES REFRESHED";
            }
            case 1: {
                return "FrameworkEvent STARTED";
            }
            case 8: {
                return "FrameworkEvent STARTLEVEL CHANGED";
            }
            case 16: {
                return "FrameworkEvent WARNING";
            }
        }
        return "FrameworkEvent " + Integer.toHexString(type);
    }

    static class MockSystemBundle
    implements Bundle {
        MockSystemBundle() {
        }

        @Override
        public int compareTo(Bundle o) {
            long idcomp = this.getBundleId() - o.getBundleId();
            return idcomp < 0L ? -1 : (idcomp > 0L ? 1 : 0);
        }

        @Override
        public int getState() {
            return 4;
        }

        @Override
        public void start(int options) {
        }

        @Override
        public void start() {
        }

        @Override
        public void stop(int options) {
        }

        @Override
        public void stop() {
        }

        @Override
        public void update(InputStream input) {
        }

        @Override
        public void update() {
        }

        @Override
        public void uninstall() {
        }

        @Override
        public Dictionary<String, String> getHeaders() {
            return new Hashtable<String, String>();
        }

        @Override
        public long getBundleId() {
            return 0L;
        }

        @Override
        public String getLocation() {
            return "System Bundle";
        }

        @Override
        public ServiceReference<?>[] getRegisteredServices() {
            return null;
        }

        @Override
        public ServiceReference<?>[] getServicesInUse() {
            return null;
        }

        @Override
        public boolean hasPermission(Object permission) {
            return true;
        }

        @Override
        public URL getResource(String name2) {
            return null;
        }

        @Override
        public Dictionary<String, String> getHeaders(String locale) {
            return null;
        }

        @Override
        public String getSymbolicName() {
            return "paper.libs.org.eclipse.osgi";
        }

        @Override
        public Class<?> loadClass(String name2) throws ClassNotFoundException {
            throw new ClassNotFoundException();
        }

        @Override
        public Enumeration<URL> getResources(String name2) {
            return null;
        }

        @Override
        public Enumeration<String> getEntryPaths(String path) {
            return null;
        }

        @Override
        public URL getEntry(String path) {
            return null;
        }

        @Override
        public long getLastModified() {
            return System.currentTimeMillis();
        }

        @Override
        public Enumeration<URL> findEntries(String path, String filePattern, boolean recurse) {
            return null;
        }

        @Override
        public BundleContext getBundleContext() {
            return null;
        }

        @Override
        public Map<X509Certificate, List<X509Certificate>> getSignerCertificates(int signersType) {
            return new HashMap<X509Certificate, List<X509Certificate>>();
        }

        @Override
        public Version getVersion() {
            return new Version(0, 0, 0);
        }

        @Override
        public <A> A adapt(Class<A> type) {
            return null;
        }

        @Override
        public File getDataFile(String filename) {
            return null;
        }
    }
}

