/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import paper.libs.org.eclipse.jdt.core.compiler.CategorizedProblem;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.internal.compiler.ClassFile;
import paper.libs.org.eclipse.jdt.internal.compiler.CompilationResult;
import paper.libs.org.eclipse.jdt.internal.compiler.Compiler;
import paper.libs.org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import paper.libs.org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import paper.libs.org.eclipse.jdt.internal.compiler.IProblemFactory;
import paper.libs.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import paper.libs.org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import paper.libs.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;
import paper.libs.org.eclipse.jdt.internal.eval.EvaluationContext;
import paper.libs.org.eclipse.jdt.internal.eval.EvaluationResult;
import paper.libs.org.eclipse.jdt.internal.eval.IRequestor;

public abstract class Evaluator {
    EvaluationContext context;
    INameEnvironment environment;
    Map<String, String> options;
    IRequestor requestor;
    IProblemFactory problemFactory;

    Evaluator(EvaluationContext context, INameEnvironment environment, Map<String, String> options, IRequestor requestor, IProblemFactory problemFactory) {
        this.context = context;
        this.environment = environment;
        this.options = options;
        this.requestor = requestor;
        this.problemFactory = problemFactory;
    }

    protected abstract void addEvaluationResultForCompilationProblem(Map<char[], EvaluationResult> var1, CategorizedProblem var2, char[] var3);

    protected EvaluationResult[] evaluationResultsForCompilationProblems(CompilationResult result, char[] cuSource) {
        CategorizedProblem[] problems = result.getAllProblems();
        HashMap<char[], EvaluationResult> resultsByIDs = new HashMap<char[], EvaluationResult>(5);
        int i2 = 0;
        while (i2 < problems.length) {
            this.addEvaluationResultForCompilationProblem(resultsByIDs, problems[i2], cuSource);
            ++i2;
        }
        int size = resultsByIDs.size();
        EvaluationResult[] evalResults = new EvaluationResult[size];
        Iterator<EvaluationResult> results = resultsByIDs.values().iterator();
        int i3 = 0;
        while (i3 < size) {
            evalResults[i3] = results.next();
            ++i3;
        }
        return evalResults;
    }

    ClassFile[] getClasses() {
        final char[] source = this.getSource();
        ArrayList classDefinitions = new ArrayList();
        class CompilerRequestor
        implements ICompilerRequestor {
            boolean hasErrors = false;
            private final /* synthetic */ char[] val$source;
            private final /* synthetic */ ArrayList val$classDefinitions;

            CompilerRequestor(char[] cArray, ArrayList arrayList) {
                this.val$source = cArray;
                this.val$classDefinitions = arrayList;
            }

            @Override
            public void acceptResult(CompilationResult result) {
                int i2;
                if (result.hasProblems()) {
                    EvaluationResult[] evalResults = Evaluator.this.evaluationResultsForCompilationProblems(result, this.val$source);
                    i2 = 0;
                    while (i2 < evalResults.length) {
                        EvaluationResult evalResult = evalResults[i2];
                        CategorizedProblem[] problems = evalResult.getProblems();
                        int j = 0;
                        while (j < problems.length) {
                            Evaluator.this.requestor.acceptProblem(problems[j], evalResult.getEvaluationID(), evalResult.getEvaluationType());
                            ++j;
                        }
                        ++i2;
                    }
                }
                if (result.hasErrors()) {
                    this.hasErrors = true;
                } else {
                    ClassFile[] classFiles = result.getClassFiles();
                    i2 = 0;
                    while (i2 < classFiles.length) {
                        ClassFile classFile = classFiles[i2];
                        this.val$classDefinitions.add(classFile);
                        ++i2;
                    }
                }
            }
        }
        CompilerRequestor compilerRequestor = new CompilerRequestor(source, classDefinitions);
        Compiler compiler = this.getCompiler(compilerRequestor);
        compiler.compile(new ICompilationUnit[]{new ICompilationUnit(){

            @Override
            public char[] getFileName() {
                return CharOperation.concat(Evaluator.this.getClassName(), Util.defaultJavaExtension().toCharArray());
            }

            @Override
            public char[] getContents() {
                return source;
            }

            @Override
            public char[] getMainTypeName() {
                return Evaluator.this.getClassName();
            }

            @Override
            public char[][] getPackageName() {
                return null;
            }

            @Override
            public boolean ignoreOptionalProblems() {
                return false;
            }

            @Override
            public char[] getModuleName() {
                return null;
            }
        }});
        if (compilerRequestor.hasErrors) {
            return null;
        }
        ClassFile[] result = new ClassFile[classDefinitions.size()];
        classDefinitions.toArray(result);
        return result;
    }

    protected abstract char[] getClassName();

    Compiler getCompiler(ICompilerRequestor compilerRequestor) {
        CompilerOptions compilerOptions = new CompilerOptions(this.options);
        compilerOptions.performMethodsFullRecovery = true;
        compilerOptions.performStatementsRecovery = true;
        return new Compiler(this.environment, DefaultErrorHandlingPolicies.exitAfterAllProblems(), compilerOptions, compilerRequestor, this.problemFactory);
    }

    protected abstract char[] getSource();
}

