/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.util;

import paper.libs.org.eclipse.jdt.core.util.ClassFormatException;
import paper.libs.org.eclipse.jdt.core.util.IConstantPool;
import paper.libs.org.eclipse.jdt.core.util.IStackMapFrame;
import paper.libs.org.eclipse.jdt.core.util.IVerificationTypeInfo;
import paper.libs.org.eclipse.jdt.internal.core.util.ClassFileStruct;
import paper.libs.org.eclipse.jdt.internal.core.util.VerificationInfo;

public class DefaultStackMapFrame
extends ClassFileStruct
implements IStackMapFrame {
    private static final IVerificationTypeInfo[] EMPTY_LOCALS_OR_STACK_ITEMS = new IVerificationTypeInfo[0];
    private int readOffset;
    private int numberOfLocals;
    private int numberOfStackItems;
    private IVerificationTypeInfo[] locals;
    private IVerificationTypeInfo[] stackItems;
    private int offsetDelta;

    public DefaultStackMapFrame(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        int tempLocals;
        this.offsetDelta = this.u2At(classFileBytes, 0, offset);
        this.numberOfLocals = tempLocals = this.u2At(classFileBytes, 2, offset);
        this.readOffset = 4;
        if (tempLocals != 0) {
            this.locals = new IVerificationTypeInfo[tempLocals];
            int i2 = 0;
            while (i2 < tempLocals) {
                VerificationInfo verificationInfo = new VerificationInfo(classFileBytes, constantPool, offset + this.readOffset);
                this.locals[i2] = verificationInfo;
                this.readOffset += verificationInfo.sizeInBytes();
                ++i2;
            }
        } else {
            this.locals = EMPTY_LOCALS_OR_STACK_ITEMS;
        }
        int tempStackItems = this.u2At(classFileBytes, this.readOffset, offset);
        this.readOffset += 2;
        this.numberOfStackItems = tempStackItems;
        if (tempStackItems != 0) {
            this.stackItems = new IVerificationTypeInfo[tempStackItems];
            int i3 = 0;
            while (i3 < tempStackItems) {
                VerificationInfo verificationInfo = new VerificationInfo(classFileBytes, constantPool, offset + this.readOffset);
                this.stackItems[i3] = verificationInfo;
                this.readOffset += verificationInfo.sizeInBytes();
                ++i3;
            }
        } else {
            this.stackItems = EMPTY_LOCALS_OR_STACK_ITEMS;
        }
    }

    int sizeInBytes() {
        return this.readOffset;
    }

    @Override
    public int getFrameType() {
        return 255;
    }

    @Override
    public IVerificationTypeInfo[] getLocals() {
        return this.locals;
    }

    @Override
    public int getNumberOfLocals() {
        return this.numberOfLocals;
    }

    @Override
    public int getNumberOfStackItems() {
        return this.numberOfStackItems;
    }

    @Override
    public int getOffsetDelta() {
        return this.offsetDelta;
    }

    @Override
    public IVerificationTypeInfo[] getStackItems() {
        return this.stackItems;
    }
}

