/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.util;

import paper.libs.org.eclipse.jdt.core.IInitializer;
import paper.libs.org.eclipse.jdt.core.ILocalVariable;
import paper.libs.org.eclipse.jdt.core.IMember;
import paper.libs.org.eclipse.jdt.core.ISourceRange;
import paper.libs.org.eclipse.jdt.core.ITypeParameter;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.dom.ASTNode;
import paper.libs.org.eclipse.jdt.core.dom.ASTVisitor;
import paper.libs.org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.ClassInstanceCreation;
import paper.libs.org.eclipse.jdt.core.dom.CompilationUnit;
import paper.libs.org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.EnumDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.IBinding;
import paper.libs.org.eclipse.jdt.core.dom.ImportDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.Initializer;
import paper.libs.org.eclipse.jdt.core.dom.MarkerAnnotation;
import paper.libs.org.eclipse.jdt.core.dom.MethodDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.ModuleDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.NormalAnnotation;
import paper.libs.org.eclipse.jdt.core.dom.PackageDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.ParameterizedType;
import paper.libs.org.eclipse.jdt.core.dom.RecordDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import paper.libs.org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.TypeDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.TypeParameter;
import paper.libs.org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import paper.libs.org.eclipse.jdt.internal.core.LambdaExpression;
import paper.libs.org.eclipse.jdt.internal.core.LambdaMethod;
import paper.libs.org.eclipse.jdt.internal.core.SourceRefElement;

public class DOMFinder
extends ASTVisitor {
    public ASTNode foundNode = null;
    public IBinding foundBinding = null;
    private CompilationUnit ast;
    private SourceRefElement element;
    private boolean resolveBinding;
    private int rangeStart = -1;
    private int rangeLength = 0;

    public DOMFinder(CompilationUnit ast, SourceRefElement element, boolean resolveBinding) {
        this.ast = ast;
        this.element = element;
        this.resolveBinding = resolveBinding;
    }

    protected boolean found(ASTNode node, ASTNode name2) {
        if (name2.getStartPosition() == this.rangeStart && name2.getLength() == this.rangeLength) {
            this.foundNode = node;
            return true;
        }
        return false;
    }

    public ASTNode search() throws JavaModelException {
        ISourceRange range = null;
        range = this.element instanceof IMember && !(this.element instanceof IInitializer) && !(this.element instanceof LambdaMethod) && !(this.element instanceof LambdaExpression) ? ((IMember)((Object)this.element)).getNameRange() : (this.element instanceof ITypeParameter || this.element instanceof ILocalVariable ? this.element.getNameRange() : this.element.getSourceRange());
        this.rangeStart = range.getOffset();
        this.rangeLength = range.getLength();
        this.ast.accept(this);
        return this.foundNode;
    }

    @Override
    public boolean visit(AnnotationTypeDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(AnnotationTypeMemberDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        ASTNode name2;
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 14: {
                name2 = ((ClassInstanceCreation)parent).getType();
                if (name2.getNodeType() != 74) break;
                name2 = ((ParameterizedType)name2).getType();
                break;
            }
            case 72: {
                name2 = ((EnumConstantDeclaration)parent).getName();
                break;
            }
            default: {
                return true;
            }
        }
        if (this.found(node, name2) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(EnumConstantDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveVariable();
        }
        return true;
    }

    @Override
    public boolean visit(EnumDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(Initializer node) {
        this.found(node, node);
        return true;
    }

    @Override
    public boolean visit(MarkerAnnotation node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveAnnotationBinding();
        }
        return true;
    }

    @Override
    public boolean visit(MethodDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(ModuleDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(NormalAnnotation node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveAnnotationBinding();
        }
        return true;
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(SingleMemberAnnotation node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveAnnotationBinding();
        }
        return true;
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(RecordDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(TypeParameter node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    @Override
    public boolean visit(paper.libs.org.eclipse.jdt.core.dom.LambdaExpression node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveMethodBinding();
        }
        return true;
    }
}

