/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.search.matching;

import java.util.Map;
import java.util.function.Predicate;
import paper.libs.org.eclipse.core.resources.IContainer;
import paper.libs.org.eclipse.core.resources.IFile;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IJavaProject;
import paper.libs.org.eclipse.jdt.core.IType;
import paper.libs.org.eclipse.jdt.core.JavaCore;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import paper.libs.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import paper.libs.org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelManager;
import paper.libs.org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import paper.libs.org.eclipse.jdt.internal.core.util.ResourceCompilationUnit;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class ClasspathSourceDirectory
extends ClasspathLocation
implements IModulePathEntry {
    IContainer sourceFolder;
    SimpleLookupTable directoryCache;
    SimpleLookupTable missingPackageHolder = new SimpleLookupTable();
    char[][] fullExclusionPatternChars;
    char[][] fulInclusionPatternChars;

    ClasspathSourceDirectory(IContainer sourceFolder, char[][] fullExclusionPatternChars, char[][] fulInclusionPatternChars) {
        this.sourceFolder = sourceFolder;
        this.directoryCache = new SimpleLookupTable(5);
        this.fullExclusionPatternChars = fullExclusionPatternChars;
        this.fulInclusionPatternChars = fulInclusionPatternChars;
    }

    @Override
    public void cleanup() {
        this.directoryCache = null;
    }

    SimpleLookupTable directoryTable(String qualifiedPackageName) {
        SimpleLookupTable dirTable = (SimpleLookupTable)this.directoryCache.get(qualifiedPackageName);
        if (dirTable == this.missingPackageHolder) {
            return null;
        }
        if (dirTable != null) {
            return dirTable;
        }
        try {
            IResource container = this.sourceFolder.findMember(qualifiedPackageName);
            if (container instanceof IContainer) {
                Map<String, IType> typesInPackage;
                IResource[] members = ((IContainer)container).members();
                dirTable = new SimpleLookupTable();
                int i2 = 0;
                int l = members.length;
                while (i2 < l) {
                    String fullPath;
                    String name2;
                    int index;
                    IResource m = members[i2];
                    if (m.getType() == 1 && (index = Util.indexOfJavaLikeExtension(name2 = m.getName())) >= 0 && !paper.libs.org.eclipse.jdt.internal.compiler.util.Util.isExcluded((fullPath = m.getFullPath().toString()).toCharArray(), this.fulInclusionPatternChars, this.fullExclusionPatternChars, false)) {
                        dirTable.put(name2.substring(0, index), m);
                    }
                    ++i2;
                }
                IJavaProject project = JavaCore.create(container.getProject());
                Map<String, Map<String, IType>> secondaryTypePaths = JavaModelManager.getJavaModelManager().secondaryTypes(project, false, null);
                if (secondaryTypePaths.size() > 0 && (typesInPackage = secondaryTypePaths.get(qualifiedPackageName.replace('/', '.'))) != null && typesInPackage.size() > 0) {
                    for (String secondaryTypeName : typesInPackage.keySet()) {
                        IType secondaryType = typesInPackage.get(secondaryTypeName);
                        IJavaElement parent = secondaryType.getParent();
                        String fullPath = parent.getResource().getFullPath().toString();
                        if (paper.libs.org.eclipse.jdt.internal.compiler.util.Util.isExcluded(fullPath.toCharArray(), this.fulInclusionPatternChars, this.fullExclusionPatternChars, false)) continue;
                        dirTable.put(secondaryTypeName, parent.getResource());
                    }
                }
                this.directoryCache.put(qualifiedPackageName, dirTable);
                return dirTable;
            }
        }
        catch (CoreException coreException) {}
        this.directoryCache.put(qualifiedPackageName, this.missingPackageHolder);
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathSourceDirectory)) {
            return false;
        }
        return this.sourceFolder.equals(((ClasspathSourceDirectory)o).sourceFolder);
    }

    @Override
    public NameEnvironmentAnswer findClass(String typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        return this.findClass(typeName, qualifiedPackageName, moduleName, qualifiedBinaryFileName);
    }

    @Override
    public NameEnvironmentAnswer findClass(String sourceFileWithoutExtension, String qualifiedPackageName, String moduleName, String qualifiedSourceFileWithoutExtension) {
        IFile file;
        SimpleLookupTable dirTable = this.directoryTable(qualifiedPackageName);
        if (dirTable != null && dirTable.elementSize > 0 && (file = (IFile)dirTable.get(sourceFileWithoutExtension)) != null) {
            return new NameEnvironmentAnswer(new ResourceCompilationUnit(file, this.module == null ? null : this.module.name()), null);
        }
        return null;
    }

    @Override
    public IPath getProjectRelativePath() {
        return this.sourceFolder.getProjectRelativePath();
    }

    public int hashCode() {
        return this.sourceFolder == null ? super.hashCode() : this.sourceFolder.hashCode();
    }

    @Override
    public boolean isPackage(String qualifiedPackageName, String moduleName) {
        if (!(moduleName == null || this.module != null && moduleName.equals(String.valueOf(this.module.name())))) {
            return false;
        }
        return this.directoryTable(qualifiedPackageName) != null;
    }

    @Override
    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        SimpleLookupTable dirTable = this.directoryTable(qualifiedPackageName);
        return dirTable != null && dirTable.elementSize > 0;
    }

    @Override
    public void reset() {
        this.directoryCache = new SimpleLookupTable(5);
    }

    public String toString() {
        return "Source classpath directory " + this.sourceFolder.getFullPath().toString();
    }

    @Override
    public String debugPathString() {
        return this.sourceFolder.getFullPath().toString();
    }
}

