/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.search.indexing;

import java.util.ArrayList;
import paper.libs.org.eclipse.jdt.core.Signature;
import paper.libs.org.eclipse.jdt.core.compiler.CategorizedProblem;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Expression;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import paper.libs.org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import paper.libs.org.eclipse.jdt.internal.core.search.indexing.SourceIndexer;
import paper.libs.org.eclipse.jdt.internal.core.search.processing.JobManager;

public class SourceIndexerRequestor
implements ISourceElementRequestor,
IIndexConstants {
    SourceIndexer indexer;
    char[] packageName = CharOperation.NO_CHAR;
    char[][] enclosingTypeNames = new char[5][];
    int depth = 0;
    int methodDepth = 0;

    public SourceIndexerRequestor(SourceIndexer indexer) {
        this.indexer = indexer;
    }

    @Override
    public void acceptAnnotationTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
        int length = typeName.length;
        int i2 = 0;
        while (i2 < length - 1) {
            this.acceptUnknownReference(typeName[i2], 0);
            ++i2;
        }
        this.acceptAnnotationTypeReference(typeName[length - 1], 0);
    }

    @Override
    public void acceptAnnotationTypeReference(char[] simpleTypeName, int sourcePosition) {
        this.indexer.addAnnotationTypeReference(simpleTypeName);
    }

    @Override
    public void acceptConstructorReference(char[] typeName, int argCount, int sourcePosition) {
        if (CharOperation.indexOf('<', typeName) > 0) {
            typeName = Signature.toCharArray(Signature.getTypeErasure(Signature.createTypeSignature(typeName, false)).toCharArray());
        }
        this.indexer.addConstructorReference(typeName, argCount);
        int lastDot = CharOperation.lastIndexOf('.', typeName);
        if (lastDot != -1) {
            char[][] qualification = CharOperation.splitOn('.', CharOperation.subarray(typeName, 0, lastDot));
            int i2 = 0;
            int length = qualification.length;
            while (i2 < length) {
                this.indexer.addNameReference(qualification[i2]);
                ++i2;
            }
        }
    }

    @Override
    public void acceptFieldReference(char[] fieldName, int sourcePosition) {
        this.indexer.addFieldReference(fieldName);
    }

    @Override
    public void acceptImport(int declarationStart, int declarationEnd, int nameStart, int nameEnd, char[][] tokens, boolean onDemand, int modifiers) {
    }

    @Override
    public void acceptLineSeparatorPositions(int[] positions) {
    }

    @Override
    public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition) {
        this.indexer.addMethodReference(methodName, argCount);
    }

    @Override
    public void acceptPackage(ImportReference importReference) {
        this.packageName = CharOperation.concatWith(importReference.getImportName(), '.');
    }

    @Override
    public void acceptProblem(CategorizedProblem problem) {
    }

    @Override
    public void acceptTypeReference(char[][] typeName, int sourceStart, int sourceEnd) {
        int length = typeName.length;
        int i2 = 0;
        while (i2 < length - 1) {
            this.acceptUnknownReference(typeName[i2], 0);
            ++i2;
        }
        this.acceptTypeReference(typeName[length - 1], 0);
    }

    @Override
    public void acceptTypeReference(char[] simpleTypeName, int sourcePosition) {
        this.indexer.addTypeReference(simpleTypeName);
    }

    @Override
    public void acceptUnknownReference(char[][] name2, int sourceStart, int sourceEnd) {
        int i2 = 0;
        while (i2 < name2.length) {
            this.acceptUnknownReference(name2[i2], 0);
            ++i2;
        }
    }

    @Override
    public void acceptUnknownReference(char[] name2, int sourcePosition) {
        this.indexer.addNameReference(name2);
    }

    private void addDefaultConstructorIfNecessary(ISourceElementRequestor.TypeInfo typeInfo) {
        boolean hasConstructor = false;
        TypeDeclaration typeDeclaration = typeInfo.node;
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        int methodCounter = methods == null ? 0 : methods.length;
        int i2 = 0;
        while (i2 < methodCounter) {
            AbstractMethodDeclaration method = methods[i2];
            if (method.isConstructor() && !method.isDefaultConstructor()) {
                hasConstructor = true;
                break;
            }
            ++i2;
        }
        if (!hasConstructor) {
            this.indexer.addDefaultConstructorDeclaration(typeInfo.name, this.packageName == null ? CharOperation.NO_CHAR : this.packageName, typeInfo.modifiers, this.getMoreExtraFlags(typeInfo.extraFlags));
        }
    }

    public char[][] enclosingTypeNames() {
        if (this.depth == 0) {
            return null;
        }
        char[][] qualification = new char[this.depth][];
        System.arraycopy(this.enclosingTypeNames, 0, qualification, 0, this.depth);
        return qualification;
    }

    private void enterAnnotationType(ISourceElementRequestor.TypeInfo typeInfo) {
        char[][] typeNames = this.methodDepth > 0 ? ONE_ZERO_CHAR : this.enclosingTypeNames();
        this.indexer.addAnnotationTypeDeclaration(typeInfo.modifiers, this.packageName, typeInfo.name, typeNames, typeInfo.secondary);
        this.addDefaultConstructorIfNecessary(typeInfo);
        this.pushTypeName(typeInfo.name);
    }

    private void enterRecord(ISourceElementRequestor.TypeInfo typeInfo) {
        this.enterClass(typeInfo);
    }

    private void enterClass(ISourceElementRequestor.TypeInfo typeInfo) {
        if (typeInfo.superclass != null) {
            typeInfo.superclass = this.getSimpleName(typeInfo.superclass);
            this.indexer.addConstructorReference(typeInfo.superclass, 0);
        }
        if (typeInfo.superinterfaces != null) {
            int i2 = 0;
            int length = typeInfo.superinterfaces.length;
            while (i2 < length) {
                typeInfo.superinterfaces[i2] = this.getSimpleName(typeInfo.superinterfaces[i2]);
                ++i2;
            }
        }
        char[][] typeNames = this.methodDepth > 0 ? ONE_ZERO_CHAR : this.enclosingTypeNames();
        char[][] typeParameterSignatures = null;
        if (typeInfo.typeParameters != null) {
            int typeParametersLength = typeInfo.typeParameters.length;
            typeParameterSignatures = new char[typeParametersLength][];
            int i3 = 0;
            while (i3 < typeParametersLength) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = typeInfo.typeParameters[i3];
                typeParameterSignatures[i3] = Signature.createTypeParameterSignature(typeParameterInfo.name, typeParameterInfo.bounds == null ? CharOperation.NO_CHAR_CHAR : typeParameterInfo.bounds);
                ++i3;
            }
        }
        this.indexer.addClassDeclaration(typeInfo.modifiers, this.packageName, typeInfo.name, typeNames, typeInfo.superclass, typeInfo.superinterfaces, typeParameterSignatures, typeInfo.secondary);
        this.addDefaultConstructorIfNecessary(typeInfo);
        this.pushTypeName(typeInfo.name);
    }

    @Override
    public void enterCompilationUnit() {
    }

    @Override
    public void enterConstructor(ISourceElementRequestor.MethodInfo methodInfo) {
        int argCount = methodInfo.parameterTypes == null ? 0 : methodInfo.parameterTypes.length;
        this.indexer.addConstructorDeclaration(methodInfo.name, argCount, null, methodInfo.parameterTypes, methodInfo.parameterNames, methodInfo.modifiers, methodInfo.declaringPackageName, methodInfo.declaringTypeModifiers, methodInfo.exceptionTypes, this.getMoreExtraFlags(methodInfo.extraFlags));
        ++this.methodDepth;
    }

    private void enterEnum(ISourceElementRequestor.TypeInfo typeInfo) {
        if (typeInfo.superinterfaces != null) {
            int i2 = 0;
            int length = typeInfo.superinterfaces.length;
            while (i2 < length) {
                typeInfo.superinterfaces[i2] = this.getSimpleName(typeInfo.superinterfaces[i2]);
                ++i2;
            }
        }
        char[][] typeNames = this.methodDepth > 0 ? ONE_ZERO_CHAR : this.enclosingTypeNames();
        char[] superclass = typeInfo.superclass == null ? CharOperation.concatWith(TypeConstants.JAVA_LANG_ENUM, '.') : typeInfo.superclass;
        this.indexer.addEnumDeclaration(typeInfo.modifiers, this.packageName, typeInfo.name, typeNames, superclass, typeInfo.superinterfaces, typeInfo.secondary);
        this.addDefaultConstructorIfNecessary(typeInfo);
        this.pushTypeName(typeInfo.name);
    }

    @Override
    public void enterField(ISourceElementRequestor.FieldInfo fieldInfo) {
        this.indexer.addFieldDeclaration(fieldInfo.type, fieldInfo.name);
        ++this.methodDepth;
    }

    @Override
    public void enterInitializer(int declarationSourceStart, int modifiers) {
        ++this.methodDepth;
    }

    private void enterInterface(ISourceElementRequestor.TypeInfo typeInfo) {
        if (typeInfo.superinterfaces != null) {
            int i2 = 0;
            int length = typeInfo.superinterfaces.length;
            while (i2 < length) {
                typeInfo.superinterfaces[i2] = this.getSimpleName(typeInfo.superinterfaces[i2]);
                ++i2;
            }
        }
        char[][] typeNames = this.methodDepth > 0 ? ONE_ZERO_CHAR : this.enclosingTypeNames();
        char[][] typeParameterSignatures = null;
        if (typeInfo.typeParameters != null) {
            int typeParametersLength = typeInfo.typeParameters.length;
            typeParameterSignatures = new char[typeParametersLength][];
            int i3 = 0;
            while (i3 < typeParametersLength) {
                ISourceElementRequestor.TypeParameterInfo typeParameterInfo = typeInfo.typeParameters[i3];
                typeParameterSignatures[i3] = Signature.createTypeParameterSignature(typeParameterInfo.name, typeParameterInfo.bounds);
                ++i3;
            }
        }
        this.indexer.addInterfaceDeclaration(typeInfo.modifiers, this.packageName, typeInfo.name, typeNames, typeInfo.superinterfaces, typeParameterSignatures, typeInfo.secondary);
        this.addDefaultConstructorIfNecessary(typeInfo);
        this.pushTypeName(typeInfo.name);
    }

    @Override
    public void enterModule(ISourceElementRequestor.ModuleInfo moduleInfo) {
        this.indexer.addModuleDeclaration(moduleInfo.moduleName);
        if (moduleInfo.requires != null) {
            ISourceElementRequestor.RequiresInfo[] requiresInfoArray = moduleInfo.requires;
            int n = moduleInfo.requires.length;
            int n2 = 0;
            while (n2 < n) {
                ISourceElementRequestor.RequiresInfo req = requiresInfoArray[n2];
                if (req != null && req.moduleName != null && req.moduleName != CharOperation.NO_CHAR) {
                    this.indexer.addModuleReference(req.moduleName);
                }
                ++n2;
            }
        }
        this.enterPackageVisibilityInfo(moduleInfo.exports);
        this.enterPackageVisibilityInfo(moduleInfo.opens);
    }

    private void enterPackageVisibilityInfo(ISourceElementRequestor.PackageExportInfo[] packInfos) {
        if (packInfos == null) {
            return;
        }
        ISourceElementRequestor.PackageExportInfo[] packageExportInfoArray = packInfos;
        int n = packInfos.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceElementRequestor.PackageExportInfo packInfo = packageExportInfoArray[n2];
            if (packInfo != null && packInfo.pkgName != null && packInfo.pkgName != CharOperation.NO_CHAR) {
                this.indexer.addModuleExportedPackages(packInfo.pkgName);
                char[][] tgts = packInfo.targets;
                if (tgts != null && tgts != CharOperation.NO_CHAR_CHAR) {
                    char[][] cArray = tgts;
                    int n3 = tgts.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        char[] tgt = cArray[n4];
                        if (tgt != null && tgt != CharOperation.NO_CHAR) {
                            this.indexer.addModuleReference(tgt);
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public void enterMethod(ISourceElementRequestor.MethodInfo methodInfo) {
        char[] typeName;
        this.indexer.addMethodDeclaration(methodInfo.name, methodInfo.parameterTypes, methodInfo.returnType, methodInfo.exceptionTypes);
        int argCount = methodInfo.parameterTypes == null ? 0 : methodInfo.parameterTypes.length;
        char[] cArray = typeName = methodInfo.enclosingType != null ? methodInfo.enclosingType.name : null;
        if (typeName == null || typeName.length == 0) {
            ++this.methodDepth;
            return;
        }
        this.indexer.addMethodDeclaration(typeName, SourceIndexerRequestor.getDeclaringQualification(methodInfo.enclosingType), methodInfo.name, argCount, null, methodInfo.parameterTypes, methodInfo.parameterNames, methodInfo.returnType, methodInfo.modifiers, methodInfo.declaringPackageName, methodInfo.declaringTypeModifiers, methodInfo.exceptionTypes, this.getMoreExtraFlags(methodInfo.extraFlags));
        ++this.methodDepth;
    }

    /*
     * Unable to fully structure code
     */
    private static char[] getDeclaringQualification(TypeDeclaration typeDecl) {
        if (typeDecl.name == null) {
            return null;
        }
        enclosingType = typeDecl.enclosingType;
        nlist = new ArrayList<char[]>();
        name = null;
        size = 0;
        if (true) ** GOTO lbl12
        do {
            nlist.add(0, name);
            size += name.length + 1;
            enclosingType = enclosingType.enclosingType;
lbl12:
            // 2 sources

            if (enclosingType == null) break;
            name = enclosingType.name;
        } while (enclosingType.name != null);
        if (name == null) {
            return null;
        }
        l = nlist.size();
        if (l == 1) {
            return name;
        }
        name = new char[size];
        index = 0;
        i = 0;
        while (i < l - 1) {
            e = (char[])nlist.get(i);
            System.arraycopy(e, 0, name, index, e.length);
            index += e.length;
            name[index++] = 46;
            ++i;
        }
        e = (char[])nlist.get(l - 1);
        System.arraycopy(e, 0, name, index, e.length);
        return name;
    }

    @Override
    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        switch (TypeDeclaration.kind(typeInfo.modifiers)) {
            case 1: {
                this.enterClass(typeInfo);
                break;
            }
            case 4: {
                this.enterAnnotationType(typeInfo);
                break;
            }
            case 2: {
                this.enterInterface(typeInfo);
                break;
            }
            case 3: {
                this.enterEnum(typeInfo);
                break;
            }
            case 5: {
                this.enterRecord(typeInfo);
            }
        }
    }

    @Override
    public void exitCompilationUnit(int declarationEnd) {
    }

    @Override
    public void exitConstructor(int declarationEnd) {
        --this.methodDepth;
    }

    @Override
    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        --this.methodDepth;
    }

    @Override
    public void exitRecordComponent(int declarationEnd, int declarationSourceEnd) {
    }

    @Override
    public void exitInitializer(int declarationEnd) {
        --this.methodDepth;
    }

    @Override
    public void exitMethod(int declarationEnd, Expression defaultValue) {
        --this.methodDepth;
    }

    @Override
    public void exitType(int declarationEnd) {
        this.popTypeName();
    }

    /*
     * Enabled aggressive block sorting
     */
    private char[] getSimpleName(char[] typeName) {
        int lastDot = -1;
        int lastGenericStart = -1;
        int depthCount = 0;
        int length = typeName.length;
        int i2 = length - 1;
        block5: while (i2 >= 0) {
            switch (typeName[i2]) {
                case '.': {
                    if (depthCount != 0) break;
                    lastDot = i2;
                    break block5;
                }
                case '<': {
                    if (--depthCount != 0) break;
                    lastGenericStart = i2;
                    break;
                }
                case '>': {
                    ++depthCount;
                }
            }
            --i2;
        }
        if (lastGenericStart >= 0) {
            return CharOperation.subarray(typeName, lastDot + 1, lastGenericStart);
        }
        if (lastDot < 0) {
            return typeName;
        }
        return CharOperation.subarray(typeName, lastDot + 1, length);
    }

    private int getMoreExtraFlags(int extraFlags) {
        if (this.methodDepth > 0) {
            extraFlags |= 4;
        }
        return extraFlags;
    }

    public void popTypeName() {
        if (this.depth > 0) {
            this.enclosingTypeNames[--this.depth] = null;
        } else if (JobManager.VERBOSE) {
            try {
                this.enclosingTypeNames[-1] = null;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
    }

    public void pushTypeName(char[] typeName) {
        if (this.depth == this.enclosingTypeNames.length) {
            char[][] cArrayArray = new char[this.depth * 2][];
            this.enclosingTypeNames = cArrayArray;
            System.arraycopy(this.enclosingTypeNames, 0, cArrayArray, 0, this.depth);
        }
        this.enclosingTypeNames[this.depth++] = typeName;
    }
}

