/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import paper.libs.org.eclipse.core.resources.IProject;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.Path;
import paper.libs.org.eclipse.jdt.internal.core.index.Index;
import paper.libs.org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import paper.libs.org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import paper.libs.org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import paper.libs.org.eclipse.jdt.internal.core.search.processing.JobManager;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

class RemoveFolderFromIndex
extends IndexRequest {
    IPath folderPath;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;

    public RemoveFolderFromIndex(IPath folderPath, char[][] inclusionPatterns, char[][] exclusionPatterns, IProject project, IndexManager manager) {
        super(project.getFullPath(), manager);
        this.folderPath = folderPath;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled || progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        Index index = this.manager.getIndex(this.containerPath, true, false);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                String containerRelativePath = Util.relativePath(this.folderPath, this.containerPath.segmentCount());
                String[] paths = index.queryDocumentNames(containerRelativePath);
                if (paths != null) {
                    if (this.exclusionPatterns == null && this.inclusionPatterns == null) {
                        int i2 = 0;
                        int max = paths.length;
                        while (i2 < max) {
                            this.manager.remove(paths[i2], this.containerPath);
                            ++i2;
                        }
                    } else {
                        int i3 = 0;
                        int max = paths.length;
                        while (i3 < max) {
                            String documentPath = String.valueOf(this.containerPath.toString()) + '/' + paths[i3];
                            if (!Util.isExcluded(new Path(documentPath), this.inclusionPatterns, this.exclusionPatterns, false)) {
                                this.manager.remove(paths[i3], this.containerPath);
                            }
                            ++i3;
                        }
                    }
                }
            }
            catch (IOException e) {
                if (JobManager.VERBOSE) {
                    Util.verbose("-> failed to remove " + this.folderPath + " from index because of the following exception:", System.err);
                    e.printStackTrace();
                }
                monitor.exitRead();
                return false;
            }
        }
        finally {
            monitor.exitRead();
        }
        return true;
    }

    public String toString() {
        return "removing " + this.folderPath + " from index " + this.containerPath;
    }
}

