/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.search.indexing;

import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import paper.libs.org.eclipse.jdt.internal.core.search.processing.IJob;

public abstract class IndexRequest
implements IJob {
    protected volatile boolean isCancelled;
    protected IPath containerPath;
    protected IndexManager manager;

    public IndexRequest(IPath containerPath, IndexManager manager) {
        this.containerPath = containerPath;
        this.manager = manager;
    }

    @Override
    public boolean belongsTo(String projectNameOrJarPath) {
        return projectNameOrJarPath.equals(this.containerPath.segment(0)) || projectNameOrJarPath.equals(this.containerPath.toString());
    }

    @Override
    public void cancel() {
        this.manager.jobWasCancelled(this.containerPath);
        this.isCancelled = true;
    }

    @Override
    public void ensureReadyToRun() {
        this.manager.aboutToUpdateIndex(this.containerPath, this.updatedIndexState());
    }

    @Override
    public String getJobFamily() {
        return this.containerPath.toString();
    }

    protected Integer updatedIndexState() {
        return IndexManager.UPDATING_STATE;
    }

    @Override
    public boolean waitNeeded() {
        return true;
    }
}

