/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.hierarchy;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class BindingMap<V> {
    private Map<TypeBinding, V> identityMap = new IdentityHashMap<TypeBinding, V>();
    private Object[] mapIdToValue = new Object[0];
    private Set<TypeBinding> bindingsWithoutAnId = new HashSet<TypeBinding>();

    public void put(TypeBinding key, V value) {
        this.identityMap.put(key, value);
        if (key.id != Integer.MAX_VALUE) {
            int targetId = key.id;
            this.insertIntoIdMap(targetId, value);
        } else {
            this.bindingsWithoutAnId.add(key);
        }
    }

    public V get(TypeBinding key) {
        Object value = this.identityMap.get(key);
        if (value != null) {
            return value;
        }
        int targetId = key.id;
        if (targetId != Integer.MAX_VALUE) {
            if (targetId < this.mapIdToValue.length) {
                value = this.mapIdToValue[targetId];
            }
            if (value != null) {
                return value;
            }
            Iterator<TypeBinding> bindingIter = this.bindingsWithoutAnId.iterator();
            while (bindingIter.hasNext()) {
                TypeBinding nextBinding = bindingIter.next();
                if (nextBinding.id == Integer.MAX_VALUE) continue;
                this.insertIntoIdMap(nextBinding.id, this.identityMap.get(nextBinding));
                bindingIter.remove();
            }
            if (targetId < this.mapIdToValue.length) {
                value = this.mapIdToValue[targetId];
            }
        }
        return value;
    }

    private void insertIntoIdMap(int targetId, V value) {
        int requiredSize = targetId + 1;
        if (this.mapIdToValue.length < requiredSize) {
            int newSize = requiredSize * 2;
            Object[] newArray = new Object[newSize];
            System.arraycopy(this.mapIdToValue, 0, newArray, 0, this.mapIdToValue.length);
            this.mapIdToValue = newArray;
        }
        this.mapIdToValue[targetId] = value;
    }

    public void clear() {
        this.identityMap.clear();
        this.bindingsWithoutAnId.clear();
        this.mapIdToValue = new Object[0];
    }
}

