/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.builder;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import paper.libs.org.eclipse.jdt.internal.compiler.util.SortedCharArrays;
import paper.libs.org.eclipse.jdt.internal.core.builder.JavaBuilder;
import paper.libs.org.eclipse.jdt.internal.core.builder.NameSet;
import paper.libs.org.eclipse.jdt.internal.core.builder.QualifiedNameSet;
import paper.libs.org.eclipse.jdt.internal.core.builder.StringSet;

public class ReferenceCollection {
    char[][][] qualifiedNameReferences;
    char[][] simpleNameReferences;
    char[][] rootReferences;
    static final char[][][] WellKnownQualifiedNames = new char[][][]{TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION, TypeConstants.JAVA_LANG_THROWABLE, TypeConstants.JAVA_LANG_OBJECT, TypeConstants.JAVA_LANG, new char[][]{TypeConstants.JAVA}, new char[][]{{'o', 'r', 'g'}}, new char[][]{{'c', 'o', 'm'}}, CharOperation.NO_CHAR_CHAR};
    static final char[][] WellKnownSimpleNames = new char[][]{TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION[2], TypeConstants.JAVA_LANG_THROWABLE[2], TypeConstants.JAVA_LANG_OBJECT[2], TypeConstants.JAVA, TypeConstants.LANG, {'o', 'r', 'g'}, {'c', 'o', 'm'}};
    static final char[][][] EmptyQualifiedNames = new char[0][][];
    static final char[][] EmptySimpleNames = CharOperation.NO_CHAR_CHAR;
    static final int MaxQualifiedNames = 7;
    static QualifiedNameSet[] InternedQualifiedNames = new QualifiedNameSet[7];
    static final int MaxSimpleNames = 30;
    static NameSet[] InternedSimpleNames = new NameSet[30];
    public static boolean REFERENCE_COLLECTION_DEBUG;

    static {
        int i2 = 0;
        while (i2 < 7) {
            ReferenceCollection.InternedQualifiedNames[i2] = new QualifiedNameSet(37);
            ++i2;
        }
        i2 = 0;
        while (i2 < 30) {
            ReferenceCollection.InternedSimpleNames[i2] = new NameSet(37);
            ++i2;
        }
        REFERENCE_COLLECTION_DEBUG = false;
    }

    protected ReferenceCollection(char[][][] qualifiedNameReferences, char[][] simpleNameReferences, char[][] rootReferences) {
        this.qualifiedNameReferences = ReferenceCollection.internQualifiedNames(qualifiedNameReferences, false);
        this.simpleNameReferences = ReferenceCollection.internSimpleNames(simpleNameReferences, true);
        this.rootReferences = ReferenceCollection.internSimpleNames(rootReferences, false);
    }

    public void addDependencies(String[] typeNameDependencies) {
        String[] stringArray = typeNameDependencies;
        int n = typeNameDependencies.length;
        int n2 = 0;
        while (n2 < n) {
            String typeNameDependency = stringArray[n2];
            char[][] qualifiedTypeName = CharOperation.splitOn('.', typeNameDependency.toCharArray());
            if (!ReferenceCollection.isWellKnownQualifiedName(qualifiedTypeName)) {
                int idx;
                int qLength = qualifiedTypeName.length;
                QualifiedNameSet internedNames = InternedQualifiedNames[qLength <= 7 ? qLength - 1 : 0];
                qualifiedTypeName = ReferenceCollection.internSimpleNames(qualifiedTypeName, false, false);
                qualifiedTypeName = internedNames.add(qualifiedTypeName);
                while ((idx = Arrays.binarySearch(this.qualifiedNameReferences, qualifiedTypeName, SortedCharArrays.CHAR_CHAR_ARR_COMPARATOR)) < 0) {
                    this.simpleNameReferences = ReferenceCollection.ensureContainedInSortedOrder(this.simpleNameReferences, qualifiedTypeName[qualifiedTypeName.length - 1]);
                    this.rootReferences = ReferenceCollection.ensureContainedInSortedOrder(this.rootReferences, qualifiedTypeName[0]);
                    int length = this.qualifiedNameReferences.length;
                    idx = -(idx + 1);
                    this.qualifiedNameReferences = SortedCharArrays.insertIntoArray(this.qualifiedNameReferences, new char[length + 1][][], qualifiedTypeName, idx, this.qualifiedNameReferences.length);
                    char[][][] temp = ReferenceCollection.internQualifiedNames(new char[][][]{qualifiedTypeName = CharOperation.subarray(qualifiedTypeName, 0, qualifiedTypeName.length - 1)}, false);
                    if (temp == EmptyQualifiedNames) break;
                    qualifiedTypeName = temp[0];
                }
            }
            ++n2;
        }
    }

    public boolean includes(char[] simpleName) {
        boolean result = ReferenceCollection.sortedArrayContains(this.simpleNameReferences, simpleName, SortedCharArrays.CHAR_ARR_COMPARATOR);
        if (REFERENCE_COLLECTION_DEBUG) {
            this.assertIncludes(result, simpleName);
        }
        return result;
    }

    public boolean includes(char[][] qualifiedName) {
        boolean result = ReferenceCollection.sortedArrayContains(this.qualifiedNameReferences, qualifiedName, SortedCharArrays.CHAR_CHAR_ARR_COMPARATOR);
        if (REFERENCE_COLLECTION_DEBUG) {
            this.assertIncludes(result, qualifiedName);
        }
        return result;
    }

    private static String qualifiedNamesToString(char[][][] qualifiedNames) {
        if (qualifiedNames == null) {
            return "null";
        }
        return Arrays.stream(qualifiedNames).map(CharOperation::toString).collect(Collectors.joining(","));
    }

    public boolean includes(char[][][] qualifiedNames, char[][] simpleNames) {
        return this.includes(qualifiedNames, simpleNames, null);
    }

    public boolean includes(char[][][] qualifiedNames, char[][] simpleNames, char[][] rootNames) {
        boolean result = this.doIncludes(qualifiedNames, simpleNames, rootNames);
        if (REFERENCE_COLLECTION_DEBUG) {
            this.assertIncludes(result, qualifiedNames, simpleNames, rootNames);
        }
        return result;
    }

    private boolean doIncludes(char[][][] qualifiedNames, char[][] simpleNames, char[][] rootNames) {
        if (rootNames != null && !this.includesRootName(rootNames)) {
            return false;
        }
        if (simpleNames == null || qualifiedNames == null) {
            if (simpleNames == null && qualifiedNames == null) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("Found well known match");
                }
                return true;
            }
            if (qualifiedNames == null) {
                return this.includesSimpleName(simpleNames);
            }
            return this.includesQualifiedName(qualifiedNames);
        }
        if (simpleNames.length <= qualifiedNames.length) {
            return this.includesSimpleName(simpleNames) && this.includesQualifiedName(qualifiedNames);
        }
        return this.includesQualifiedName(qualifiedNames) && this.includesSimpleName(simpleNames);
    }

    public boolean insideRoot(char[] rootName) {
        boolean result = ReferenceCollection.sortedArrayContains(this.rootReferences, rootName, SortedCharArrays.CHAR_ARR_COMPARATOR);
        if (REFERENCE_COLLECTION_DEBUG && result != this.debugIncludes(rootName)) {
            String message = "Mismatch: " + String.valueOf(rootName) + (result ? " should not " : " should ") + " be included in " + Arrays.asList(CharOperation.toStrings(this.rootReferences));
            throw new IllegalStateException(message);
        }
        return result;
    }

    private static <T> boolean sortedArrayContains(T[] array, T element, Comparator<? super T> comparator2) {
        int l = array.length;
        if (l < 16) {
            int i2 = 0;
            while (i2 < l) {
                if (element == array[i2]) {
                    return true;
                }
                ++i2;
            }
            return false;
        }
        return Arrays.binarySearch(array, element, comparator2) >= 0;
    }

    private boolean includesSimpleName(char[][] simpleNames) {
        return ReferenceCollection.intersects(simpleNames, this.simpleNameReferences, SortedCharArrays.CHAR_ARR_COMPARATOR);
    }

    private boolean includesQualifiedName(char[][][] qualifiedNames) {
        char[][] maybeSimpleName;
        if (ReferenceCollection.intersects(qualifiedNames, this.qualifiedNameReferences, SortedCharArrays.CHAR_CHAR_ARR_COMPARATOR)) {
            return true;
        }
        int i2 = qualifiedNames.length - 1;
        while (i2 >= 0 && (maybeSimpleName = qualifiedNames[i2]).length == 1) {
            if (this.includes(maybeSimpleName[0])) {
                return true;
            }
            --i2;
        }
        return false;
    }

    private boolean includesRootName(char[][] rootNames) {
        return ReferenceCollection.intersects(rootNames, this.rootReferences, SortedCharArrays.CHAR_ARR_COMPARATOR);
    }

    private static <T> boolean intersects(T[] firstSortedArr, T[] secondSortedArr, Comparator<? super T> comparator2) {
        int i2 = 0;
        int l = firstSortedArr.length;
        int j = 0;
        int k = secondSortedArr.length;
        while (i2 < l && j < k) {
            T firstElement = firstSortedArr[i2];
            T secondElement = secondSortedArr[j];
            int compare = comparator2.compare(firstElement, secondElement);
            if (compare == 0) {
                return true;
            }
            if (compare < 0) {
                if (l - ++i2 <= 16) continue;
                if ((i2 = Arrays.binarySearch(firstSortedArr, i2, l, secondElement, comparator2)) >= 0) {
                    return true;
                }
                i2 = -(i2 + 1);
                continue;
            }
            if (k - ++j <= 16) continue;
            if ((j = Arrays.binarySearch(secondSortedArr, j, k, firstElement, comparator2)) >= 0) {
                return true;
            }
            j = -(j + 1);
        }
        return false;
    }

    private static char[][] ensureContainedInSortedOrder(char[][] sortedArray, char[] entry) {
        int idx = Arrays.binarySearch(sortedArray, entry, SortedCharArrays.CHAR_ARR_COMPARATOR);
        if (idx < 0) {
            idx = -(idx + 1);
            char[][] result = SortedCharArrays.insertIntoArray(sortedArray, new char[sortedArray.length + 1][], entry, idx, sortedArray.length);
            return result;
        }
        return sortedArray;
    }

    private static boolean isWellKnownQualifiedName(char[][] qualifiedName) {
        int i2 = 0;
        int m = WellKnownQualifiedNames.length;
        int qLength = qualifiedName.length;
        while (i2 < m) {
            char[][] wellKnownName = WellKnownQualifiedNames[i2];
            if (qLength > wellKnownName.length) break;
            if (CharOperation.equals(qualifiedName, wellKnownName)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static char[][][] internQualifiedNames(Set<String> qualifiedStrings) {
        if (qualifiedStrings == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedStrings.size();
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] result = new char[length][][];
        for (String qualifiedString : qualifiedStrings) {
            if (qualifiedString == null) continue;
            result[--length] = CharOperation.splitOn('/', qualifiedString.toCharArray());
        }
        return ReferenceCollection.internQualifiedNames(result, false);
    }

    public static char[][][] internQualifiedNames(StringSet qualifiedStrings) {
        if (qualifiedStrings == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedStrings.elementSize;
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] result = new char[length][][];
        String[] strings = qualifiedStrings.values;
        int i2 = 0;
        int l = strings.length;
        while (i2 < l) {
            if (strings[i2] != null) {
                result[--length] = CharOperation.splitOn('/', strings[i2].toCharArray());
            }
            ++i2;
        }
        return ReferenceCollection.internQualifiedNames(result, false);
    }

    public static char[][][] internQualifiedNames(char[][][] qualifiedNames) {
        return ReferenceCollection.internQualifiedNames(qualifiedNames, false);
    }

    public static char[][][] internQualifiedNames(char[][][] qualifiedNames, boolean keepWellKnown) {
        return ReferenceCollection.internQualifiedNames(qualifiedNames, keepWellKnown, true);
    }

    static char[][][] internQualifiedNames(char[][][] qualifiedNames, boolean keepWellKnown, boolean doSort) {
        if (qualifiedNames == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedNames.length;
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] keepers = new char[length][][];
        char[][] prev = null;
        boolean isSorted = true;
        int index = 0;
        int i2 = 0;
        while (i2 < length) {
            block13: {
                char[][] qualifiedName = qualifiedNames[i2];
                int qLength = qualifiedName.length;
                int j = 0;
                int m = WellKnownQualifiedNames.length;
                while (j < m) {
                    char[][] wellKnownName = WellKnownQualifiedNames[j];
                    if (qLength > wellKnownName.length) break;
                    if (CharOperation.equals(qualifiedName, wellKnownName)) {
                        if (keepWellKnown) {
                            if (doSort && isSorted) {
                                if (prev != null && SortedCharArrays.compareCharCharArray(prev, qualifiedName) > 0) {
                                    isSorted = false;
                                }
                                prev = qualifiedName;
                            }
                            keepers[index++] = wellKnownName;
                        }
                        break block13;
                    }
                    ++j;
                }
                QualifiedNameSet internedNames = InternedQualifiedNames[qLength <= 7 ? qLength - 1 : 0];
                qualifiedName = ReferenceCollection.internSimpleNames(qualifiedName, false, false);
                if (doSort && isSorted) {
                    if (prev != null && SortedCharArrays.compareCharCharArray(prev, qualifiedName) > 0) {
                        isSorted = false;
                    }
                    prev = qualifiedName;
                }
                keepers[index++] = internedNames.add(qualifiedName);
            }
            ++i2;
        }
        if (length > index) {
            if (index == 0) {
                return EmptyQualifiedNames;
            }
            char[][][] cArrayArray = keepers;
            keepers = new char[index][][];
            System.arraycopy(cArrayArray, 0, keepers, 0, index);
        }
        if (doSort && !isSorted) {
            Arrays.sort(keepers, SortedCharArrays.CHAR_CHAR_ARR_COMPARATOR);
        }
        return keepers;
    }

    public static char[][] internSimpleNames(Set<String> simpleStrings) {
        return ReferenceCollection.internSimpleNames(simpleStrings, true);
    }

    public static char[][] internSimpleNames(Set<String> simpleStrings, boolean removeWellKnown) {
        if (simpleStrings == null) {
            return EmptySimpleNames;
        }
        int length = simpleStrings.size();
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] result = new char[length][];
        for (String simpleString : simpleStrings) {
            if (simpleString == null) continue;
            result[--length] = simpleString.toCharArray();
        }
        return ReferenceCollection.internSimpleNames(result, removeWellKnown);
    }

    public static char[][] internSimpleNames(StringSet simpleStrings, boolean removeWellKnown) {
        if (simpleStrings == null) {
            return EmptySimpleNames;
        }
        int length = simpleStrings.elementSize;
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] result = new char[length][];
        String[] strings = simpleStrings.values;
        int i2 = 0;
        int l = strings.length;
        while (i2 < l) {
            if (strings[i2] != null) {
                result[--length] = strings[i2].toCharArray();
            }
            ++i2;
        }
        return ReferenceCollection.internSimpleNames(result, removeWellKnown);
    }

    public static char[][] internSimpleNames(char[][] simpleNames, boolean removeWellKnown) {
        return ReferenceCollection.internSimpleNames(simpleNames, removeWellKnown, true);
    }

    static char[][] internSimpleNames(char[][] simpleNames, boolean removeWellKnown, boolean doSort) {
        if (simpleNames == null) {
            return EmptySimpleNames;
        }
        int length = simpleNames.length;
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] keepers = new char[length][];
        char[] prev = null;
        boolean isSorted = true;
        int index = 0;
        int i2 = 0;
        while (i2 < length) {
            block13: {
                char[] name2 = simpleNames[i2];
                int sLength = name2.length;
                int j = 0;
                int m = WellKnownSimpleNames.length;
                while (j < m) {
                    char[] wellKnownName = WellKnownSimpleNames[j];
                    if (sLength > wellKnownName.length) break;
                    if (CharOperation.equals(name2, wellKnownName)) {
                        if (!removeWellKnown) {
                            keepers[index++] = wellKnownName;
                            if (doSort && isSorted) {
                                if (prev != null && SortedCharArrays.compareCharArray(prev, name2) > 0) {
                                    isSorted = false;
                                }
                                prev = name2;
                            }
                        }
                        break block13;
                    }
                    ++j;
                }
                NameSet internedNames = InternedSimpleNames[sLength < 30 ? sLength : 0];
                keepers[index++] = internedNames.add(name2);
                if (doSort && isSorted) {
                    if (prev != null && SortedCharArrays.compareCharArray(prev, name2) > 0) {
                        isSorted = false;
                    }
                    prev = name2;
                }
            }
            ++i2;
        }
        if (length > index) {
            if (index == 0) {
                return EmptySimpleNames;
            }
            char[][] cArrayArray = keepers;
            keepers = new char[index][];
            System.arraycopy(cArrayArray, 0, keepers, 0, index);
        }
        if (doSort && !isSorted) {
            Arrays.sort(keepers, SortedCharArrays.CHAR_ARR_COMPARATOR);
        }
        return keepers;
    }

    private void assertIncludes(boolean expectation, char[] simpleName) {
        if (expectation != this.debugIncludes(simpleName)) {
            String message = "Mismatch: " + String.valueOf(simpleName) + (expectation ? " should not " : " should ") + " be included in " + Arrays.asList(CharOperation.toStrings(this.simpleNameReferences));
            throw new IllegalStateException(message);
        }
    }

    private void assertIncludes(boolean expectation, char[][] qualifiedName) {
        if (expectation != this.debugIncludes(qualifiedName)) {
            String message = "Mismatch: " + CharOperation.toString(qualifiedName) + (expectation ? " should not " : " should ") + " be included in " + ReferenceCollection.qualifiedNamesToString(this.qualifiedNameReferences);
            throw new IllegalStateException(message);
        }
    }

    private void assertIncludes(boolean expectation, char[][][] qualifiedNames, char[][] simpleNames, char[][] rootNames) {
        if (expectation != this.debugIncludes(qualifiedNames, simpleNames, rootNames)) {
            String message = String.format("Mismatched includes(..): ReferenceCollection([%s], %s, %s).includes([%s], %s, %s)", ReferenceCollection.qualifiedNamesToString(this.qualifiedNameReferences), Arrays.toString(CharOperation.toStrings(this.simpleNameReferences)), Arrays.toString(CharOperation.toStrings(this.rootReferences)), ReferenceCollection.qualifiedNamesToString(qualifiedNames), Arrays.toString(CharOperation.toStrings(simpleNames)), Arrays.toString(CharOperation.toStrings(rootNames)));
            throw new IllegalStateException(message);
        }
    }

    private boolean debugIncludes(char[][][] qualifiedNames, char[][] simpleNames, char[][] rootNames) {
        int i2;
        if (rootNames != null) {
            boolean foundRoot = false;
            int i3 = 0;
            int l = rootNames.length;
            while (!foundRoot && i3 < l) {
                foundRoot = this.debugInsideRoot(rootNames[i3]);
                ++i3;
            }
            if (!foundRoot) {
                return false;
            }
        }
        if (simpleNames == null || qualifiedNames == null) {
            int l;
            int i4;
            if (simpleNames == null && qualifiedNames == null) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("Found well known match");
                }
                return true;
            }
            if (qualifiedNames == null) {
                i4 = 0;
                l = simpleNames.length;
                while (i4 < l) {
                    if (this.debugIncludes(simpleNames[i4])) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found match in well known package to " + new String(simpleNames[i4]));
                        }
                        return true;
                    }
                    ++i4;
                }
            } else {
                i4 = 0;
                l = qualifiedNames.length;
                while (i4 < l) {
                    char[][] qualifiedName = qualifiedNames[i4];
                    if (qualifiedName.length == 1 ? this.debugIncludes(qualifiedName[0]) : this.debugIncludes(qualifiedName)) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found well known match in " + CharOperation.toString(qualifiedName));
                        }
                        return true;
                    }
                    ++i4;
                }
            }
            return false;
        }
        int sLength = simpleNames.length;
        int qLength = qualifiedNames.length;
        if (sLength <= qLength) {
            i2 = 0;
            while (i2 < sLength) {
                if (this.debugIncludes(simpleNames[i2])) {
                    int j = 0;
                    while (j < qLength) {
                        char[][] qualifiedName = qualifiedNames[j];
                        if (qualifiedName.length == 1 ? this.debugIncludes(qualifiedName[0]) : this.debugIncludes(qualifiedName)) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found match in " + CharOperation.toString(qualifiedName) + " to " + new String(simpleNames[i2]));
                            }
                            return true;
                        }
                        ++j;
                    }
                    return false;
                }
                ++i2;
            }
        } else {
            i2 = 0;
            while (i2 < qLength) {
                char[][] qualifiedName = qualifiedNames[i2];
                if (qualifiedName.length == 1 ? this.debugIncludes(qualifiedName[0]) : this.debugIncludes(qualifiedName)) {
                    int j = 0;
                    while (j < sLength) {
                        if (this.debugIncludes(simpleNames[j])) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found match in " + CharOperation.toString(qualifiedName) + " to " + new String(simpleNames[j]));
                            }
                            return true;
                        }
                        ++j;
                    }
                    return false;
                }
                ++i2;
            }
        }
        return false;
    }

    private boolean debugInsideRoot(char[] rootName) {
        int i2 = 0;
        int l = this.rootReferences.length;
        while (i2 < l) {
            if (rootName == this.rootReferences[i2]) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean debugIncludes(char[] simpleName) {
        int i2 = 0;
        int l = this.simpleNameReferences.length;
        while (i2 < l) {
            if (simpleName == this.simpleNameReferences[i2]) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean debugIncludes(char[][] qualifiedName) {
        int i2 = 0;
        int l = this.qualifiedNameReferences.length;
        while (i2 < l) {
            if (qualifiedName == this.qualifiedNameReferences[i2]) {
                return true;
            }
            ++i2;
        }
        return false;
    }
}

