/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.builder;

import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;

public final class NameSet {
    public char[][] names;
    public int elementSize = 0;
    public int threshold;

    public NameSet(int size) {
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.5f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.names = new char[extraRoom][];
    }

    public char[] add(char[] name2) {
        char[] current;
        int length = this.names.length;
        int index = CharOperation.hashCode(name2) % length;
        while ((current = this.names[index]) != null) {
            if (CharOperation.equals(current, name2)) {
                return current;
            }
            if (++index != length) continue;
            index = 0;
        }
        this.names[index] = name2;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return name2;
    }

    private void rehash() {
        NameSet newSet = new NameSet(this.elementSize * 2);
        int i2 = this.names.length;
        while (--i2 >= 0) {
            char[] current = this.names[i2];
            if (current == null) continue;
            newSet.add(current);
        }
        this.names = newSet.names;
        this.elementSize = newSet.elementSize;
        this.threshold = newSet.threshold;
    }

    public String toString() {
        String s = "";
        int i2 = 0;
        int l = this.names.length;
        while (i2 < l) {
            char[] name2 = this.names[i2];
            if (name2 != null) {
                s = String.valueOf(s) + new String(name2) + "\n";
            }
            ++i2;
        }
        return s;
    }
}

