/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core.builder;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import paper.libs.org.eclipse.jdt.core.IClasspathEntry;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IModule;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import paper.libs.org.eclipse.jdt.internal.core.ClasspathEntry;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;
import paper.libs.org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import paper.libs.org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import paper.libs.org.eclipse.jdt.internal.core.builder.ModulePathEntry;

class ModuleEntryProcessor {
    ModuleEntryProcessor() {
    }

    static String pushPatchToFront(IClasspathEntry[] classpathEntries, JavaProject javaProject) {
        int i2 = 0;
        while (i2 < classpathEntries.length) {
            IClasspathEntry entry = classpathEntries[i2];
            List<String> patchedModules = javaProject.getPatchedModules(entry);
            if (patchedModules.size() == 1) {
                if (i2 > 0) {
                    IClasspathEntry tmp = classpathEntries[0];
                    classpathEntries[0] = entry;
                    classpathEntries[i2] = tmp;
                }
                return patchedModules.get(0);
            }
            ++i2;
        }
        return null;
    }

    static void combinePatchIntoModuleEntry(ClasspathLocation sourceLocation, IModule patchedModule, Map<String, IModulePathEntry> moduleEntries) {
        sourceLocation.setModule(patchedModule);
        String patchedModuleName = String.valueOf(patchedModule.name());
        IModulePathEntry mainEntry = moduleEntries.get(patchedModuleName);
        ClasspathLocation[] combinedLocations = null;
        if (mainEntry instanceof ModulePathEntry.Multi) {
            ((ModulePathEntry.Multi)mainEntry).addPatchLocation(sourceLocation);
            return;
        }
        if (mainEntry instanceof ClasspathJrt) {
            combinedLocations = new ClasspathLocation[]{(ClasspathLocation)((Object)mainEntry), sourceLocation};
            moduleEntries.put(patchedModuleName, new ModulePathEntry.Multi(null, patchedModule, combinedLocations));
            return;
        }
        if (mainEntry instanceof ModulePathEntry) {
            ClasspathLocation[] mainLocs = ((ModulePathEntry)mainEntry).locations;
            combinedLocations = Arrays.copyOf(mainLocs, mainLocs.length + 1);
            combinedLocations[combinedLocations.length - 1] = sourceLocation;
        } else if (mainEntry instanceof ClasspathLocation) {
            combinedLocations = new ClasspathLocation[]{(ClasspathLocation)((Object)mainEntry), sourceLocation};
        } else {
            throw new IllegalStateException("Cannot patch the module of classpath entry " + mainEntry);
        }
        moduleEntries.put(patchedModuleName, new ModulePathEntry(null, patchedModule, combinedLocations));
    }

    static Set<String> computeLimitModules(ClasspathEntry entry) {
        String extraAttribute = ClasspathEntry.getExtraAttribute(entry, "limit-modules");
        if (extraAttribute == null) {
            return null;
        }
        return new LinkedHashSet<String>(Arrays.asList(extraAttribute.split(",")));
    }
}

