/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.text.NumberFormat;
import java.util.Date;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IOpenable;
import paper.libs.org.eclipse.jdt.internal.core.ElementCache;
import paper.libs.org.eclipse.jdt.internal.core.JavaElement;
import paper.libs.org.eclipse.jdt.internal.core.JavaElementInfo;

public class VerboseElementCache<K extends IJavaElement & IOpenable>
extends ElementCache<K> {
    private K beingAdded;
    private String name;

    public VerboseElementCache(int size, String name2) {
        super(size);
        this.name = name2;
    }

    @Override
    protected boolean makeSpace(int space) {
        if (this.beingAdded == null) {
            return super.makeSpace(space);
        }
        String fillingRatio = this.toStringFillingRation(this.name);
        boolean result = super.makeSpace(space);
        String newFillingRatio = this.toStringFillingRation(this.name);
        if (!fillingRatio.equals(newFillingRatio)) {
            System.out.println(Thread.currentThread() + " " + new Date(System.currentTimeMillis()).toString());
            System.out.println(Thread.currentThread() + " MADE SPACE FOR " + fillingRatio + " (NOW " + NumberFormat.getInstance().format(this.fillingRatio()) + "% full)");
            System.out.println(Thread.currentThread() + " WHILE OPENING " + ((JavaElement)this.beingAdded).toStringWithAncestors());
            System.out.println();
        }
        return result;
    }

    @Override
    public JavaElementInfo put(K key, JavaElementInfo value) {
        try {
            if (this.beingAdded == null) {
                this.beingAdded = key;
            }
            JavaElementInfo javaElementInfo = super.put(key, value);
            return javaElementInfo;
        }
        finally {
            if (key.equals(this.beingAdded)) {
                this.beingAdded = null;
            }
        }
    }
}

