/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import paper.libs.org.eclipse.jdt.core.IBuffer;
import paper.libs.org.eclipse.jdt.core.ICompilationUnit;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IJavaModelStatus;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.core.dom.ASTNode;
import paper.libs.org.eclipse.jdt.core.dom.ASTParser;
import paper.libs.org.eclipse.jdt.core.dom.ASTVisitor;
import paper.libs.org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.BodyDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.EnumDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.TypeDeclaration;
import paper.libs.org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import paper.libs.org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import paper.libs.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import paper.libs.org.eclipse.jdt.internal.core.CompilationUnit;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelOperation;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelStatus;
import paper.libs.org.eclipse.jdt.internal.core.util.Messages;
import paper.libs.org.eclipse.jface.text.BadLocationException;
import paper.libs.org.eclipse.jface.text.Document;
import paper.libs.org.eclipse.text.edits.RangeMarker;
import paper.libs.org.eclipse.text.edits.TextEdit;
import paper.libs.org.eclipse.text.edits.TextEditGroup;

public class SortElementsOperation
extends JavaModelOperation {
    public static final String CONTAINS_MALFORMED_NODES = "malformed";
    Comparator comparator;
    int[] positions;
    int apiLevel;

    public SortElementsOperation(int level, IJavaElement[] elements, int[] positions, Comparator comparator2) {
        super(elements);
        this.comparator = comparator2;
        this.positions = positions;
        this.apiLevel = level;
    }

    protected int getMainAmountOfWork() {
        return this.elementsToProcess.length;
    }

    boolean checkMalformedNodes(ASTNode node) {
        Object property = node.getProperty(CONTAINS_MALFORMED_NODES);
        if (property == null) {
            return false;
        }
        return (Boolean)property;
    }

    protected boolean isMalformed(ASTNode node) {
        return (node.getFlags() & 1) != 0;
    }

    @Override
    protected void executeOperation() throws JavaModelException {
        try {
            this.beginTask(Messages.operation_sortelements, this.getMainAmountOfWork());
            CompilationUnit copy = (CompilationUnit)this.elementsToProcess[0];
            ICompilationUnit unit = copy.getPrimary();
            IBuffer buffer = copy.getBuffer();
            if (buffer == null) {
                return;
            }
            char[] bufferContents = buffer.getCharacters();
            String result = this.processElement(unit, bufferContents);
            if (!CharOperation.equals(result.toCharArray(), bufferContents)) {
                copy.getBuffer().setContents(result);
            }
            this.worked(1);
        }
        finally {
            this.done();
        }
    }

    public TextEdit calculateEdit(paper.libs.org.eclipse.jdt.core.dom.CompilationUnit unit, TextEditGroup group) throws JavaModelException {
        if (this.elementsToProcess.length != 1) {
            throw new JavaModelException(new JavaModelStatus(968));
        }
        if (!(this.elementsToProcess[0] instanceof ICompilationUnit)) {
            throw new JavaModelException(new JavaModelStatus(967, this.elementsToProcess[0]));
        }
        try {
            this.beginTask(Messages.operation_sortelements, this.getMainAmountOfWork());
            ICompilationUnit cu = (ICompilationUnit)this.elementsToProcess[0];
            String content = cu.getBuffer().getContents();
            ASTRewrite rewrite = this.sortCompilationUnit(unit, group);
            if (rewrite == null) {
                return null;
            }
            Document document = new Document(content);
            TextEdit textEdit = rewrite.rewriteAST(document, cu.getOptions(true));
            return textEdit;
        }
        finally {
            this.done();
        }
    }

    private String processElement(ICompilationUnit unit, char[] source) {
        int max;
        int i2;
        Document document = new Document(new String(source));
        CompilerOptions options = new CompilerOptions(unit.getJavaProject().getOptions(true));
        ASTParser parser = ASTParser.newParser(this.apiLevel);
        parser.setCompilerOptions(options.getMap());
        parser.setSource(source);
        parser.setKind(8);
        parser.setResolveBindings(false);
        paper.libs.org.eclipse.jdt.core.dom.CompilationUnit ast = (paper.libs.org.eclipse.jdt.core.dom.CompilationUnit)parser.createAST(null);
        ASTRewrite rewriter = this.sortCompilationUnit(ast, null);
        if (rewriter == null) {
            return document.get();
        }
        TextEdit edits = rewriter.rewriteAST(document, unit.getJavaProject().getOptions(true));
        RangeMarker[] markers = null;
        if (this.positions != null) {
            markers = new RangeMarker[this.positions.length];
            i2 = 0;
            max = this.positions.length;
            while (i2 < max) {
                markers[i2] = new RangeMarker(this.positions[i2], 0);
                SortElementsOperation.insert(edits, markers[i2]);
                ++i2;
            }
        }
        try {
            edits.apply(document, 2);
            if (this.positions != null) {
                i2 = 0;
                max = markers.length;
                while (i2 < max) {
                    this.positions[i2] = markers[i2].getOffset();
                    ++i2;
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return document.get();
    }

    private ASTRewrite sortCompilationUnit(paper.libs.org.eclipse.jdt.core.dom.CompilationUnit ast, final TextEditGroup group) {
        ast.accept(new ASTVisitor(){

            @Override
            public boolean visit(paper.libs.org.eclipse.jdt.core.dom.CompilationUnit compilationUnit) {
                List types = compilationUnit.types();
                boolean contains_malformed_nodes = false;
                for (AbstractTypeDeclaration typeDeclaration : types) {
                    typeDeclaration.setProperty("relativeOrder", typeDeclaration.getStartPosition());
                    contains_malformed_nodes |= SortElementsOperation.this.isMalformed(typeDeclaration);
                }
                compilationUnit.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, contains_malformed_nodes);
                return true;
            }

            @Override
            public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
                List bodyDeclarations = annotationTypeDeclaration.bodyDeclarations();
                boolean contains_malformed_nodes = false;
                for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                    bodyDeclaration.setProperty("relativeOrder", bodyDeclaration.getStartPosition());
                    contains_malformed_nodes |= SortElementsOperation.this.isMalformed(bodyDeclaration);
                }
                annotationTypeDeclaration.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, contains_malformed_nodes);
                return true;
            }

            @Override
            public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
                List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
                boolean contains_malformed_nodes = false;
                for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                    bodyDeclaration.setProperty("relativeOrder", bodyDeclaration.getStartPosition());
                    contains_malformed_nodes |= SortElementsOperation.this.isMalformed(bodyDeclaration);
                }
                anonymousClassDeclaration.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, contains_malformed_nodes);
                return true;
            }

            @Override
            public boolean visit(TypeDeclaration typeDeclaration) {
                List bodyDeclarations = typeDeclaration.bodyDeclarations();
                boolean contains_malformed_nodes = false;
                for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                    bodyDeclaration.setProperty("relativeOrder", bodyDeclaration.getStartPosition());
                    contains_malformed_nodes |= SortElementsOperation.this.isMalformed(bodyDeclaration);
                }
                typeDeclaration.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, contains_malformed_nodes);
                return true;
            }

            @Override
            public boolean visit(EnumDeclaration enumDeclaration) {
                List bodyDeclarations = enumDeclaration.bodyDeclarations();
                boolean contains_malformed_nodes = false;
                for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                    bodyDeclaration.setProperty("relativeOrder", bodyDeclaration.getStartPosition());
                    contains_malformed_nodes |= SortElementsOperation.this.isMalformed(bodyDeclaration);
                }
                List enumConstants = enumDeclaration.enumConstants();
                for (EnumConstantDeclaration enumConstantDeclaration : enumConstants) {
                    enumConstantDeclaration.setProperty("relativeOrder", enumConstantDeclaration.getStartPosition());
                    contains_malformed_nodes |= SortElementsOperation.this.isMalformed(enumConstantDeclaration);
                }
                enumDeclaration.setProperty(SortElementsOperation.CONTAINS_MALFORMED_NODES, contains_malformed_nodes);
                return true;
            }
        });
        final ASTRewrite rewriter = ASTRewrite.create(ast.getAST());
        final boolean[] hasChanges = new boolean[1];
        ast.accept(new ASTVisitor(){

            private void sortElements(List elements, ListRewrite listRewrite) {
                if (elements.size() == 0) {
                    return;
                }
                ArrayList myCopy = new ArrayList();
                myCopy.addAll(elements);
                Collections.sort(myCopy, SortElementsOperation.this.comparator);
                int i2 = 0;
                while (i2 < elements.size()) {
                    ASTNode newNode;
                    ASTNode oldNode = (ASTNode)elements.get(i2);
                    if (oldNode != (newNode = (ASTNode)myCopy.get(i2))) {
                        listRewrite.replace(oldNode, rewriter.createMoveTarget(newNode), group);
                        hasChanges[0] = true;
                    }
                    ++i2;
                }
            }

            @Override
            public boolean visit(paper.libs.org.eclipse.jdt.core.dom.CompilationUnit compilationUnit) {
                if (SortElementsOperation.this.checkMalformedNodes(compilationUnit)) {
                    return true;
                }
                this.sortElements(compilationUnit.types(), rewriter.getListRewrite(compilationUnit, paper.libs.org.eclipse.jdt.core.dom.CompilationUnit.TYPES_PROPERTY));
                return true;
            }

            @Override
            public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
                if (SortElementsOperation.this.checkMalformedNodes(annotationTypeDeclaration)) {
                    return true;
                }
                this.sortElements(annotationTypeDeclaration.bodyDeclarations(), rewriter.getListRewrite(annotationTypeDeclaration, AnnotationTypeDeclaration.BODY_DECLARATIONS_PROPERTY));
                return true;
            }

            @Override
            public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
                if (SortElementsOperation.this.checkMalformedNodes(anonymousClassDeclaration)) {
                    return true;
                }
                this.sortElements(anonymousClassDeclaration.bodyDeclarations(), rewriter.getListRewrite(anonymousClassDeclaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY));
                return true;
            }

            @Override
            public boolean visit(TypeDeclaration typeDeclaration) {
                if (SortElementsOperation.this.checkMalformedNodes(typeDeclaration)) {
                    return true;
                }
                this.sortElements(typeDeclaration.bodyDeclarations(), rewriter.getListRewrite(typeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY));
                return true;
            }

            @Override
            public boolean visit(EnumDeclaration enumDeclaration) {
                if (SortElementsOperation.this.checkMalformedNodes(enumDeclaration)) {
                    return true;
                }
                this.sortElements(enumDeclaration.bodyDeclarations(), rewriter.getListRewrite(enumDeclaration, EnumDeclaration.BODY_DECLARATIONS_PROPERTY));
                this.sortElements(enumDeclaration.enumConstants(), rewriter.getListRewrite(enumDeclaration, EnumDeclaration.ENUM_CONSTANTS_PROPERTY));
                return true;
            }
        });
        if (!hasChanges[0]) {
            return null;
        }
        return rewriter;
    }

    @Override
    public IJavaModelStatus verify() {
        if (this.elementsToProcess.length != 1) {
            return new JavaModelStatus(968);
        }
        if (this.elementsToProcess[0] == null) {
            return new JavaModelStatus(968);
        }
        if (!(this.elementsToProcess[0] instanceof ICompilationUnit) || !((ICompilationUnit)this.elementsToProcess[0]).isWorkingCopy()) {
            return new JavaModelStatus(967, this.elementsToProcess[0]);
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    public static void insert(TextEdit parent, TextEdit edit) {
        TextEdit child;
        if (!parent.hasChildren()) {
            parent.addChild(edit);
            return;
        }
        TextEdit[] children = parent.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            child = children[i2];
            if (SortElementsOperation.covers(child, edit)) {
                SortElementsOperation.insert(child, edit);
                return;
            }
            ++i2;
        }
        i2 = children.length - 1;
        while (i2 >= 0) {
            child = children[i2];
            if (SortElementsOperation.covers(edit, child)) {
                parent.removeChild(i2);
                edit.addChild(child);
            }
            --i2;
        }
        parent.addChild(edit);
    }

    private static boolean covers(TextEdit thisEdit, TextEdit otherEdit) {
        if (thisEdit.getLength() == 0) {
            return false;
        }
        int thisOffset = thisEdit.getOffset();
        int thisEnd = thisEdit.getExclusiveEnd();
        if (otherEdit.getLength() == 0) {
            int otherOffset = otherEdit.getOffset();
            return thisOffset <= otherOffset && otherOffset < thisEnd;
        }
        int otherOffset = otherEdit.getOffset();
        int otherEnd = otherEdit.getExclusiveEnd();
        return thisOffset <= otherOffset && otherEnd <= thisEnd;
    }
}

