/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.io.InputStream;
import paper.libs.org.eclipse.core.resources.IContainer;
import paper.libs.org.eclipse.core.resources.IFile;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.Path;
import paper.libs.org.eclipse.core.runtime.PlatformObject;
import paper.libs.org.eclipse.jdt.core.IJarEntryResource;
import paper.libs.org.eclipse.jdt.core.IPackageFragment;
import paper.libs.org.eclipse.jdt.core.IPackageFragmentRoot;
import paper.libs.org.eclipse.jdt.internal.core.util.Util;

public class NonJavaResource
extends PlatformObject
implements IJarEntryResource {
    private static final IJarEntryResource[] NO_CHILDREN = new IJarEntryResource[0];
    protected Object parent;
    protected IResource resource;

    public NonJavaResource(Object parent, IResource resource) {
        this.parent = parent;
        this.resource = resource;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NonJavaResource)) {
            return false;
        }
        NonJavaResource other = (NonJavaResource)obj;
        return this.parent.equals(other.parent) && this.resource.equals(other.resource);
    }

    @Override
    public IJarEntryResource[] getChildren() {
        if (this.resource instanceof IContainer) {
            IResource[] members;
            try {
                members = ((IContainer)this.resource).members();
            }
            catch (CoreException e) {
                Util.log(e, "Could not retrieve children of " + this.resource.getFullPath());
                return NO_CHILDREN;
            }
            int length = members.length;
            if (length == 0) {
                return NO_CHILDREN;
            }
            IJarEntryResource[] children = new IJarEntryResource[length];
            int i2 = 0;
            while (i2 < length) {
                children[i2] = new NonJavaResource(this, members[i2]);
                ++i2;
            }
            return children;
        }
        return NO_CHILDREN;
    }

    @Override
    public InputStream getContents() throws CoreException {
        if (this.resource instanceof IFile) {
            return ((IFile)this.resource).getContents();
        }
        return null;
    }

    protected String getEntryName() {
        String elementName;
        String parentEntryName = this.parent instanceof IPackageFragment ? ((elementName = ((IPackageFragment)this.parent).getElementName()).length() == 0 ? "" : String.valueOf(elementName.replace('.', '/')) + '/') : (this.parent instanceof IPackageFragmentRoot ? "" : String.valueOf(((NonJavaResource)this.parent).getEntryName()) + '/');
        return String.valueOf(parentEntryName) + this.getName();
    }

    @Override
    public IPath getFullPath() {
        return new Path(this.getEntryName()).makeAbsolute();
    }

    @Override
    public String getName() {
        return this.resource.getName();
    }

    @Override
    public IPackageFragmentRoot getPackageFragmentRoot() {
        if (this.parent instanceof IPackageFragment) {
            return (IPackageFragmentRoot)((IPackageFragment)this.parent).getParent();
        }
        if (this.parent instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)this.parent;
        }
        return ((NonJavaResource)this.parent).getPackageFragmentRoot();
    }

    @Override
    public Object getParent() {
        return this.parent;
    }

    public int hashCode() {
        return Util.combineHashCodes(this.resource.hashCode(), this.parent.hashCode());
    }

    @Override
    public boolean isFile() {
        return this.resource instanceof IFile;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public String toString() {
        return "NonJavaResource[" + this.getEntryName() + "]";
    }
}

