/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import paper.libs.org.eclipse.core.resources.IContainer;
import paper.libs.org.eclipse.core.resources.IFile;
import paper.libs.org.eclipse.core.resources.IFolder;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IOpenable;
import paper.libs.org.eclipse.jdt.core.IPackageFragment;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.internal.compiler.util.Util;
import paper.libs.org.eclipse.jdt.internal.core.JarPackageFragment;
import paper.libs.org.eclipse.jdt.internal.core.JavaElement;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelStatus;
import paper.libs.org.eclipse.jdt.internal.core.MultiOperation;
import paper.libs.org.eclipse.jdt.internal.core.util.Messages;

public class DeleteResourceElementsOperation
extends MultiOperation {
    protected DeleteResourceElementsOperation(IJavaElement[] elementsToProcess, boolean force) {
        super(elementsToProcess, force);
    }

    private void deletePackageFragment(IPackageFragment frag) throws JavaModelException {
        IResource res = ((JavaElement)((Object)frag)).resource();
        if (res != null) {
            IResource fragResource;
            IResource[] remainingFiles;
            IJavaElement[] childrenOfInterest = frag.getChildren();
            if (childrenOfInterest.length > 0) {
                IResource[] resources = new IResource[childrenOfInterest.length];
                int i2 = 0;
                while (i2 < childrenOfInterest.length) {
                    resources[i2] = ((JavaElement)childrenOfInterest[i2]).resource();
                    ++i2;
                }
                this.deleteResources(resources, this.force);
            }
            Object[] nonJavaResources = frag.getNonJavaResources();
            int actualResourceCount = 0;
            int i3 = 0;
            int max = nonJavaResources.length;
            while (i3 < max) {
                if (nonJavaResources[i3] instanceof IResource) {
                    ++actualResourceCount;
                }
                ++i3;
            }
            IResource[] actualNonJavaResources = new IResource[actualResourceCount];
            int i4 = 0;
            int max2 = nonJavaResources.length;
            int index = 0;
            while (i4 < max2) {
                if (nonJavaResources[i4] instanceof IResource) {
                    actualNonJavaResources[index++] = (IResource)nonJavaResources[i4];
                }
                ++i4;
            }
            this.deleteResources(actualNonJavaResources, this.force);
            try {
                remainingFiles = ((IContainer)res).members();
            }
            catch (CoreException ce) {
                throw new JavaModelException(ce);
            }
            boolean isEmpty = true;
            int i5 = 0;
            int length = remainingFiles.length;
            while (i5 < length) {
                IResource file = remainingFiles[i5];
                if (file instanceof IFile && Util.isClassFileName(file.getName())) {
                    this.deleteResource(file, 3);
                } else {
                    isEmpty = false;
                }
                ++i5;
            }
            if (isEmpty && !frag.isDefaultPackage() && (fragResource = ((JavaElement)((Object)frag)).resource()) != null) {
                this.deleteEmptyPackageFragment(frag, false, fragResource.getParent());
            }
        }
    }

    @Override
    protected String getMainTaskName() {
        return Messages.operation_deleteResourceProgress;
    }

    @Override
    protected void processElement(IJavaElement element) throws JavaModelException {
        switch (element.getElementType()) {
            case 5: 
            case 6: {
                this.deleteResource(element.getResource(), this.force ? 3 : 2);
                break;
            }
            case 4: {
                this.deletePackageFragment((IPackageFragment)element);
                break;
            }
            default: {
                throw new JavaModelException(new JavaModelStatus(967, element));
            }
        }
        if (element instanceof IOpenable) {
            ((IOpenable)((Object)element)).close();
        }
    }

    @Override
    protected void verify(IJavaElement element) throws JavaModelException {
        int type;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if ((type = element.getElementType()) <= 3 || type > 5) {
            this.error(967, element);
        } else if (type == 4 && element instanceof JarPackageFragment) {
            this.error(967, element);
        }
        IResource resource = ((JavaElement)element).resource();
        if (resource instanceof IFolder && resource.isLinked()) {
            this.error(995, element);
        }
    }
}

