/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import paper.libs.org.eclipse.core.resources.IProject;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.jdt.core.IClasspathEntry;
import paper.libs.org.eclipse.jdt.core.IJavaModelStatus;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.internal.core.ClasspathEntry;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelManager;
import paper.libs.org.eclipse.jdt.internal.core.JavaProject;
import paper.libs.org.eclipse.jdt.internal.core.builder.JavaBuilder;

public class ClasspathValidation {
    private JavaProject project;

    public ClasspathValidation(JavaProject project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        IJavaModelStatus status;
        IPath outputLocation;
        IClasspathEntry[] rawClasspath;
        JavaModelManager.PerProjectInfo perProjectInfo;
        try {
            perProjectInfo = this.project.getPerProjectInfo();
        }
        catch (JavaModelException javaModelException) {
            IProject resource = this.project.getProject();
            if (resource.isAccessible()) {
                this.project.flushClasspathProblemMarkers(true, true, true);
                JavaBuilder.removeProblemsAndTasksFor(resource);
            }
            return;
        }
        JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo;
        synchronized (perProjectInfo2) {
            rawClasspath = perProjectInfo.rawClasspath;
            outputLocation = perProjectInfo.outputLocation;
            status = perProjectInfo.rawClasspathStatus;
        }
        this.project.flushClasspathProblemMarkers(false, true, false);
        if (!status.isOK()) {
            this.project.createClasspathProblemMarker(status);
        }
        this.project.flushClasspathProblemMarkers(false, false, true);
        this.project.flushClasspathProblemMarkers(false, false, false);
        if (rawClasspath != JavaProject.INVALID_CLASSPATH && outputLocation != null) {
            int i2 = 0;
            while (i2 < rawClasspath.length) {
                status = ClasspathEntry.validateClasspathEntry(this.project, rawClasspath[i2], false, false);
                if (!status.isOK()) {
                    this.project.createClasspathProblemMarker(status);
                }
                ++i2;
            }
            status = ClasspathEntry.validateClasspath(this.project, rawClasspath, outputLocation);
            if (status.getCode() != 0) {
                this.project.createClasspathProblemMarker(status);
            }
        }
    }
}

