/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import paper.libs.org.eclipse.jdt.core.IJavaElement;
import paper.libs.org.eclipse.jdt.core.IModuleDescription;
import paper.libs.org.eclipse.jdt.core.ITypeRoot;
import paper.libs.org.eclipse.jdt.core.JavaModelException;
import paper.libs.org.eclipse.jdt.core.compiler.CharOperation;
import paper.libs.org.eclipse.jdt.internal.compiler.env.IModule;
import paper.libs.org.eclipse.jdt.internal.core.JavaElement;
import paper.libs.org.eclipse.jdt.internal.core.ModuleDescriptionInfo;
import paper.libs.org.eclipse.jdt.internal.core.NamedMember;

public interface AbstractModule
extends IModuleDescription {
    public Object getElementInfo() throws JavaModelException;

    default public IModule getModuleInfo() throws JavaModelException {
        return (IModule)this.getElementInfo();
    }

    @Override
    default public String[] getExportedPackageNames(IModuleDescription targetModule) throws JavaModelException {
        IModule info = this.getModuleInfo();
        if (info != null) {
            ArrayList<String> result = new ArrayList<String>();
            IModule.IPackageExport[] iPackageExportArray = info.exports();
            int n = iPackageExportArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModule.IPackageExport packageExport = iPackageExportArray[n2];
                if (targetModule == null || !packageExport.isQualified() || CharOperation.containsEqual(packageExport.targets(), targetModule.getElementName().toCharArray())) {
                    result.add(new String(packageExport.name()));
                }
                ++n2;
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[0];
    }

    @Override
    default public String[] getOpenedPackageNames(IModuleDescription targetModule) throws JavaModelException {
        IModule info = this.getModuleInfo();
        if (info != null) {
            ArrayList<String> result = new ArrayList<String>();
            IModule.IPackageExport[] iPackageExportArray = info.opens();
            int n = iPackageExportArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModule.IPackageExport packageOpen = iPackageExportArray[n2];
                if (targetModule == null || !packageOpen.isQualified() || CharOperation.containsEqual(packageOpen.targets(), targetModule.getElementName().toCharArray())) {
                    result.add(new String(packageOpen.name()));
                }
                ++n2;
            }
            return result.toArray(new String[result.size()]);
        }
        return new String[0];
    }

    default public IModule.IModuleReference[] getRequiredModules() throws JavaModelException {
        return this.getModuleInfo().requires();
    }

    default public IModule.IPackageExport[] getExportedPackages() throws JavaModelException {
        return this.getModuleInfo().exports();
    }

    default public IModule.IService[] getProvidedServices() throws JavaModelException {
        return this.getModuleInfo().provides();
    }

    @Override
    default public String[] getProvidedServiceNames() throws JavaModelException {
        IModule.IService[] services;
        ArrayList<String> results = new ArrayList<String>();
        IModule.IService[] iServiceArray = services = this.getProvidedServices();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            IModule.IService service = iServiceArray[n2];
            results.add(new String(service.name()));
            ++n2;
        }
        return results.toArray(new String[0]);
    }

    default public char[][] getUsedServices() throws JavaModelException {
        return this.getModuleInfo().uses();
    }

    @Override
    default public String[] getUsedServiceNames() throws JavaModelException {
        ArrayList<String> results = new ArrayList<String>();
        char[][] services = this.getUsedServices();
        int i2 = 0;
        while (i2 < services.length) {
            char[] service = services[i2];
            results.add(new String(service));
            ++i2;
        }
        return results.toArray(new String[0]);
    }

    default public IModule.IPackageExport[] getOpenedPackages() throws JavaModelException {
        return this.getModuleInfo().opens();
    }

    @Override
    default public String[] getRequiredModuleNames() throws JavaModelException {
        IModule.IModuleReference[] references = this.getRequiredModules();
        return (String[])Arrays.stream(references).map(ref -> String.valueOf(ref.name())).toArray(String[]::new);
    }

    default public String toString(String lineDelimiter) {
        StringBuffer buffer = new StringBuffer();
        try {
            this.toStringContent(buffer, lineDelimiter);
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    default public void toStringContent(StringBuffer buffer, String lineDelimiter) throws JavaModelException {
        int i2;
        IModule.IPackageExport[] exports = this.getExportedPackages();
        IModule.IModuleReference[] requires = this.getRequiredModules();
        buffer.append("module ");
        buffer.append(this.getElementName()).append(' ');
        buffer.append('{').append(lineDelimiter);
        if (exports != null) {
            i2 = 0;
            while (i2 < exports.length) {
                buffer.append("\texports ");
                buffer.append(exports[i2].toString());
                buffer.append(lineDelimiter);
                ++i2;
            }
        }
        buffer.append(lineDelimiter);
        if (requires != null) {
            i2 = 0;
            while (i2 < requires.length) {
                buffer.append("\trequires ");
                if (requires[i2].isTransitive()) {
                    buffer.append(" public ");
                }
                buffer.append(requires[i2].name());
                buffer.append(';').append(lineDelimiter);
                ++i2;
            }
        }
        buffer.append(lineDelimiter).append('}').toString();
    }

    @Override
    default public int getElementType() {
        return 17;
    }

    public static class AutoModule
    extends NamedMember
    implements AbstractModule {
        private boolean nameFromManifest;

        public AutoModule(JavaElement parent, String name2, boolean nameFromManifest) {
            super(parent, name2);
            this.nameFromManifest = nameFromManifest;
        }

        @Override
        public IJavaElement[] getChildren() throws JavaModelException {
            return JavaElement.NO_ELEMENTS;
        }

        @Override
        public int getFlags() throws JavaModelException {
            return 0;
        }

        @Override
        public boolean isAutoModule() {
            return true;
        }

        public boolean isAutoNameFromManifest() {
            return this.nameFromManifest;
        }

        @Override
        public char getHandleMementoDelimiter() {
            return '`';
        }

        @Override
        public ITypeRoot getTypeRoot() {
            return null;
        }

        @Override
        public IModule.IModuleReference[] getRequiredModules() throws JavaModelException {
            return ModuleDescriptionInfo.NO_REQUIRES;
        }

        @Override
        public void toStringContent(StringBuffer buffer, String lineDelimiter) throws JavaModelException {
            buffer.append("automatic module ");
            buffer.append(this.name);
        }
    }
}

