/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.internal.compiler.lookup;

import paper.libs.org.eclipse.jdt.internal.compiler.ast.Annotation;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Expression;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.FieldReference;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.NameReference;
import paper.libs.org.eclipse.jdt.internal.compiler.ast.Reference;
import paper.libs.org.eclipse.jdt.internal.compiler.impl.Constant;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.Binding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import paper.libs.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public class ElementValuePair {
    char[] name;
    public Object value;
    public MethodBinding binding;

    public static Object getValue(Expression expression) {
        if (expression == null) {
            return null;
        }
        Constant constant = expression.constant;
        if (constant != null && constant != Constant.NotAConstant) {
            return constant;
        }
        if (expression instanceof Annotation) {
            return ((Annotation)expression).getCompilerAnnotation();
        }
        if (expression instanceof ArrayInitializer) {
            Expression[] exprs = ((ArrayInitializer)expression).expressions;
            int length = exprs == null ? 0 : exprs.length;
            Object[] values = new Object[length];
            int i2 = 0;
            while (i2 < length) {
                values[i2] = ElementValuePair.getValue(exprs[i2]);
                ++i2;
            }
            return values;
        }
        if (expression instanceof ClassLiteralAccess) {
            return ((ClassLiteralAccess)expression).targetType;
        }
        if (expression instanceof Reference) {
            Binding binding;
            FieldBinding fieldBinding = null;
            if (expression instanceof FieldReference) {
                fieldBinding = ((FieldReference)expression).fieldBinding();
            } else if (expression instanceof NameReference && (binding = ((NameReference)expression).binding) != null && binding.kind() == 1) {
                fieldBinding = (FieldBinding)binding;
            }
            if (fieldBinding != null && (fieldBinding.modifiers & 0x4000) > 0) {
                return fieldBinding;
            }
        }
        return null;
    }

    public ElementValuePair(char[] name2, Expression expression, MethodBinding binding) {
        this(name2, ElementValuePair.getValue(expression), binding);
    }

    public ElementValuePair(char[] name2, Object value, MethodBinding binding) {
        this.name = name2;
        this.value = value;
        this.binding = binding;
    }

    public char[] getName() {
        return this.name;
    }

    public MethodBinding getMethodBinding() {
        return this.binding;
    }

    public Object getValue() {
        if (this.value instanceof UnresolvedEnumConstant) {
            this.value = ((UnresolvedEnumConstant)this.value).getResolved();
        } else if (this.value instanceof Object[]) {
            Object[] valueArray = (Object[])this.value;
            int i2 = 0;
            while (i2 < valueArray.length) {
                Object object = valueArray[i2];
                if (object instanceof UnresolvedEnumConstant) {
                    valueArray[i2] = ((UnresolvedEnumConstant)object).getResolved();
                }
                ++i2;
            }
        }
        return this.value;
    }

    void setMethodBinding(MethodBinding binding) {
        this.binding = binding;
    }

    void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(5);
        buffer.append(this.name).append(" = ");
        buffer.append(this.value);
        return buffer.toString();
    }

    public static class UnresolvedEnumConstant {
        ReferenceBinding enumType;
        LookupEnvironment environment;
        char[] enumConstantName;

        UnresolvedEnumConstant(ReferenceBinding enumType, LookupEnvironment environment, char[] enumConstantName) {
            this.enumType = enumType;
            this.environment = environment;
            this.enumConstantName = enumConstantName;
        }

        FieldBinding getResolved() {
            if (this.enumType.isUnresolvedType()) {
                this.enumType = (ReferenceBinding)BinaryTypeBinding.resolveType(this.enumType, this.environment, false);
            }
            return this.enumType.getField(this.enumConstantName, false);
        }

        public char[] getEnumConstantName() {
            return this.enumConstantName;
        }
    }
}

