/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.jdt.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import paper.libs.org.eclipse.core.resources.IFile;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IConfigurationElement;
import paper.libs.org.eclipse.core.runtime.IExtension;
import paper.libs.org.eclipse.core.runtime.IExtensionPoint;
import paper.libs.org.eclipse.core.runtime.Platform;
import paper.libs.org.eclipse.core.runtime.Plugin;
import paper.libs.org.eclipse.jdt.core.IClassFile;
import paper.libs.org.eclipse.jdt.core.ICodeFormatter;
import paper.libs.org.eclipse.jdt.core.IPackageFragmentRoot;
import paper.libs.org.eclipse.jdt.core.JavaCore;
import paper.libs.org.eclipse.jdt.core.compiler.IScanner;
import paper.libs.org.eclipse.jdt.core.formatter.CodeFormatter;
import paper.libs.org.eclipse.jdt.core.util.ClassFileBytesDisassembler;
import paper.libs.org.eclipse.jdt.core.util.ClassFormatException;
import paper.libs.org.eclipse.jdt.core.util.IClassFileDisassembler;
import paper.libs.org.eclipse.jdt.core.util.IClassFileReader;
import paper.libs.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import paper.libs.org.eclipse.jdt.internal.compiler.util.Util;
import paper.libs.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import paper.libs.org.eclipse.jdt.internal.core.JavaElement;
import paper.libs.org.eclipse.jdt.internal.core.JavaModelManager;
import paper.libs.org.eclipse.jdt.internal.core.PackageFragment;
import paper.libs.org.eclipse.jdt.internal.core.util.ClassFileReader;
import paper.libs.org.eclipse.jdt.internal.core.util.Disassembler;
import paper.libs.org.eclipse.jdt.internal.core.util.PublicScanner;
import paper.libs.org.eclipse.jdt.internal.formatter.DefaultCodeFormatter;

public class ToolFactory {
    public static final int M_FORMAT_NEW = 0;
    public static final int M_FORMAT_EXISTING = 1;

    public static ICodeFormatter createCodeFormatter() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("paper.libs.org.eclipse.jdt.core", "codeFormatter");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i2 = 0;
            while (i2 < extensions.length) {
                IConfigurationElement[] configElements = extensions[i2].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    try {
                        Object execExt = configElements[j].createExecutableExtension("class");
                        if (execExt instanceof ICodeFormatter) {
                            return (ICodeFormatter)execExt;
                        }
                    }
                    catch (CoreException coreException) {}
                    ++j;
                }
                ++i2;
            }
        }
        return ToolFactory.createDefaultCodeFormatter(null);
    }

    public static CodeFormatter createCodeFormatter(Map options) {
        return ToolFactory.createCodeFormatter(options, M_FORMAT_NEW);
    }

    public static CodeFormatter createCodeFormatter(Map options, int mode) {
        String formatterId;
        if (options == null) {
            options = JavaCore.getOptions();
        }
        HashMap<String, String> currentOptions = new HashMap<String, String>(options);
        if (mode == M_FORMAT_NEW) {
            currentOptions.put("paper.libs.org.eclipse.jdt.core.formatter.format_line_comment_starting_on_first_column", "true");
            currentOptions.put("paper.libs.org.eclipse.jdt.core.formatter.never_indent_block_comments_on_first_column", "false");
            currentOptions.put("paper.libs.org.eclipse.jdt.core.formatter.never_indent_line_comments_on_first_column", "false");
        }
        if ((formatterId = (String)options.get("paper.libs.org.eclipse.jdt.core.javaFormatter")) != null) {
            IExtensionPoint extension = Platform.getExtensionRegistry().getExtensionPoint("paper.libs.org.eclipse.jdt.core", "javaFormatter");
            if (extension != null) {
                IExtension[] extensions = extension.getExtensions();
                int i2 = 0;
                while (i2 < extensions.length) {
                    IConfigurationElement[] configElements = extensions[i2].getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        String initializerID = configElements[j].getAttribute("id");
                        if (initializerID != null && initializerID.equals(formatterId)) {
                            try {
                                Object execExt = configElements[j].createExecutableExtension("class");
                                if (execExt instanceof CodeFormatter) {
                                    CodeFormatter formatter = (CodeFormatter)execExt;
                                    formatter.setOptions(currentOptions);
                                    return formatter;
                                }
                            }
                            catch (CoreException e) {
                                paper.libs.org.eclipse.jdt.internal.core.util.Util.log(e.getStatus());
                                break;
                            }
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            paper.libs.org.eclipse.jdt.internal.core.util.Util.log(2, "Unable to instantiate formatter extension '" + formatterId + "', returning built-in formatter.");
        }
        return new DefaultCodeFormatter(currentOptions);
    }

    public static ClassFileBytesDisassembler createDefaultClassFileBytesDisassembler() {
        return new Disassembler();
    }

    public static IClassFileDisassembler createDefaultClassFileDisassembler() {
        class DeprecatedDisassembler
        extends Disassembler
        implements IClassFileDisassembler {
            DeprecatedDisassembler() {
            }
        }
        return new DeprecatedDisassembler();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IClassFileReader createDefaultClassFileReader(IClassFile classfile, int decodingFlag) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)classfile.getAncestor(3);
        if (root == null) return null;
        try {
            IClassFileReader iClassFileReader;
            if (root instanceof JarPackageFragmentRoot) {
                String archiveName = null;
                ZipFile jar2 = null;
                try {
                    jar2 = ((JarPackageFragmentRoot)root).getJar();
                    archiveName = jar2.getName();
                }
                finally {
                    JavaModelManager.getJavaModelManager().closeZipFile(jar2);
                }
                PackageFragment packageFragment = (PackageFragment)classfile.getParent();
                String classFileName = classfile.getElementName();
                String entryName = paper.libs.org.eclipse.jdt.internal.core.util.Util.concatWith(packageFragment.names, classFileName, '/');
                return ToolFactory.createDefaultClassFileReader(archiveName, entryName, decodingFlag);
            }
            InputStream in = null;
            try {
                in = ((IFile)((JavaElement)((Object)classfile)).resource()).getContents();
                iClassFileReader = ToolFactory.createDefaultClassFileReader(in, decodingFlag);
                if (in == null) return iClassFileReader;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
                return iClassFileReader;
            }
            catch (IOException iOException) {}
            return iClassFileReader;
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static IClassFileReader createDefaultClassFileReader(InputStream stream, int decodingFlag) {
        try {
            return new ClassFileReader(Util.getInputStreamAsByteArray(stream), decodingFlag);
        }
        catch (IOException | ClassFormatException exception) {
            return null;
        }
    }

    public static IClassFileReader createDefaultClassFileReader(String fileName, int decodingFlag) {
        try {
            return new ClassFileReader(Util.getFileByteContent(new File(fileName)), decodingFlag);
        }
        catch (IOException | ClassFormatException exception) {
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public static IClassFileReader createDefaultClassFileReader(String zipFileName, String zipEntryName, int decodingFlag) {
        ClassFileReader classFileReader;
        ZipFile zipFile;
        block22: {
            ZipEntry zipEntry;
            block20: {
                block21: {
                    block18: {
                        block19: {
                            zipFile = null;
                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                System.out.println("(" + Thread.currentThread() + ") [ToolFactory.createDefaultClassFileReader()] Creating ZipFile on " + zipFileName);
                            }
                            if ((zipEntry = (zipFile = new ZipFile(zipFileName)).getEntry(zipEntryName)) != null) break block18;
                            if (zipFile == null) break block19;
                            try {
                                zipFile.close();
                            }
                            catch (IOException iOException) {}
                        }
                        return null;
                    }
                    if (zipEntryName.toLowerCase().endsWith(".class")) break block20;
                    if (zipFile == null) break block21;
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
            byte[] classFileBytes = Util.getZipEntryByteContent(zipEntry, zipFile);
            classFileReader = new ClassFileReader(classFileBytes, decodingFlag);
            if (zipFile == null) break block22;
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        return classFileReader;
        catch (IOException | ClassFormatException exception) {
            block23: {
                try {
                    if (zipFile == null) break block23;
                }
                catch (Throwable throwable) {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }

    public static ICodeFormatter createDefaultCodeFormatter(Map options) {
        if (options == null) {
            options = JavaCore.getOptions();
        }
        return new paper.libs.org.eclipse.jdt.internal.formatter.old.CodeFormatter(options);
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean assertMode, boolean recordLineSeparator) {
        long complianceLevelValue = CompilerOptions.versionToJdkLevel(JavaCore.getOption("paper.libs.org.eclipse.jdt.core.compiler.compliance"));
        if (complianceLevelValue == 0L) {
            complianceLevelValue = 0x300000L;
        }
        PublicScanner scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, assertMode ? 0x300000L : 0x2F0000L, complianceLevelValue, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel) {
        long sourceLevelValue;
        long complianceLevelValue = CompilerOptions.versionToJdkLevel(JavaCore.getOption("paper.libs.org.eclipse.jdt.core.compiler.compliance"));
        if (complianceLevelValue == 0L) {
            complianceLevelValue = 0x300000L;
        }
        if ((sourceLevelValue = CompilerOptions.versionToJdkLevel(sourceLevel)) == 0L) {
            sourceLevelValue = 0x2F0000L;
        }
        PublicScanner scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, sourceLevelValue, complianceLevelValue, null, null, true);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel, String complianceLevel) {
        return ToolFactory.createScanner(tokenizeComments, tokenizeWhiteSpace, recordLineSeparator, sourceLevel, complianceLevel, true);
    }

    public static IScanner createScanner(boolean tokenizeComments, boolean tokenizeWhiteSpace, boolean recordLineSeparator, String sourceLevel, String complianceLevel, boolean enablePreview) {
        long complianceLevelValue;
        PublicScanner scanner = null;
        long sourceLevelValue = CompilerOptions.versionToJdkLevel(sourceLevel);
        if (sourceLevelValue == 0L) {
            sourceLevelValue = 0x2F0000L;
        }
        if ((complianceLevelValue = CompilerOptions.versionToJdkLevel(complianceLevel)) == 0L) {
            complianceLevelValue = 0x300000L;
        }
        scanner = new PublicScanner(tokenizeComments, tokenizeWhiteSpace, false, sourceLevelValue, complianceLevelValue, null, null, true, enablePreview);
        scanner.recordLineSeparator = recordLineSeparator;
        return scanner;
    }
}

