/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.resources;

import paper.libs.org.eclipse.core.internal.resources.IMarkerSetElement;
import paper.libs.org.eclipse.core.internal.utils.IStringPoolParticipant;
import paper.libs.org.eclipse.core.internal.utils.StringPool;

public class MarkerSet
implements Cloneable,
IStringPoolParticipant {
    protected static final int MINIMUM_SIZE = 5;
    protected int elementCount = 0;
    protected IMarkerSetElement[] elements;

    public MarkerSet() {
        this(5);
    }

    public MarkerSet(int capacity) {
        this.elements = new IMarkerSetElement[Math.max(5, capacity * 2)];
    }

    public void add(IMarkerSetElement element) {
        int hash2;
        if (element == null) {
            return;
        }
        int i2 = hash2 = this.hashFor(element.getId()) % this.elements.length;
        while (i2 < this.elements.length) {
            if (this.elements[i2] == null) {
                this.elements[i2] = element;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < hash2 - 1) {
            if (this.elements[i2] == null) {
                this.elements[i2] = element;
                ++this.elementCount;
                if (this.shouldGrow()) {
                    this.expand();
                }
                return;
            }
            ++i2;
        }
        this.expand();
        this.add(element);
    }

    public void addAll(IMarkerSetElement[] toAdd) {
        IMarkerSetElement[] iMarkerSetElementArray = toAdd;
        int n = toAdd.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerSetElement element = iMarkerSetElementArray[n2];
            this.add(element);
            ++n2;
        }
    }

    protected Object clone() {
        try {
            MarkerSet copy = (MarkerSet)super.clone();
            copy.elements = (IMarkerSetElement[])this.elements.clone();
            return copy;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean contains(long id) {
        return this.get(id) != null;
    }

    public IMarkerSetElement[] elements() {
        IMarkerSetElement[] result = new IMarkerSetElement[this.elementCount];
        int j = 0;
        IMarkerSetElement[] iMarkerSetElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerSetElement element = iMarkerSetElementArray[n2];
            if (element != null) {
                result[j++] = element;
            }
            ++n2;
        }
        return result;
    }

    protected void expand() {
        IMarkerSetElement[] array = new IMarkerSetElement[this.elements.length * 2];
        int maxArrayIndex = array.length - 1;
        IMarkerSetElement[] iMarkerSetElementArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerSetElement element = iMarkerSetElementArray[n2];
            if (element != null) {
                int hash2 = this.hashFor(element.getId()) % array.length;
                while (array[hash2] != null) {
                    if (++hash2 <= maxArrayIndex) continue;
                    hash2 = 0;
                }
                array[hash2] = element;
            }
            ++n2;
        }
        this.elements = array;
    }

    public IMarkerSetElement get(long id) {
        IMarkerSetElement element;
        int hash2;
        if (this.elementCount == 0) {
            return null;
        }
        int i2 = hash2 = this.hashFor(id) % this.elements.length;
        while (i2 < this.elements.length) {
            element = this.elements[i2];
            if (element == null) {
                return null;
            }
            if (element.getId() == id) {
                return element;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < hash2 - 1) {
            element = this.elements[i2];
            if (element == null) {
                return null;
            }
            if (element.getId() == id) {
                return element;
            }
            ++i2;
        }
        return null;
    }

    private int hashFor(long id) {
        return Math.abs((int)id);
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    protected void rehashTo(int anIndex) {
        int target = anIndex;
        int index = anIndex + 1;
        if (index >= this.elements.length) {
            index = 0;
        }
        IMarkerSetElement element = this.elements[index];
        while (element != null) {
            boolean match;
            int hashIndex = this.hashFor(element.getId()) % this.elements.length;
            if (index < target) {
                match = hashIndex <= target && hashIndex > index;
            } else {
                boolean bl = match = hashIndex <= target || hashIndex > index;
            }
            if (match) {
                this.elements[target] = element;
                target = index;
            }
            if (++index >= this.elements.length) {
                index = 0;
            }
            element = this.elements[index];
        }
        this.elements[target] = null;
    }

    public void remove(long id) {
        IMarkerSetElement element;
        int hash2;
        int i2 = hash2 = this.hashFor(id) % this.elements.length;
        while (i2 < this.elements.length) {
            element = this.elements[i2];
            if (element == null) {
                return;
            }
            if (element.getId() == id) {
                this.rehashTo(i2);
                --this.elementCount;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < hash2 - 1) {
            element = this.elements[i2];
            if (element == null) {
                return;
            }
            if (element.getId() == id) {
                this.rehashTo(i2);
                --this.elementCount;
            }
            ++i2;
        }
    }

    public void remove(IMarkerSetElement element) {
        this.remove(element.getId());
    }

    public void removeAll(IMarkerSetElement[] toRemove) {
        IMarkerSetElement[] iMarkerSetElementArray = toRemove;
        int n = toRemove.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerSetElement element = iMarkerSetElementArray[n2];
            this.remove(element);
            ++n2;
        }
    }

    private boolean shouldGrow() {
        return (double)this.elementCount > (double)this.elements.length * 0.75;
    }

    public int size() {
        return this.elementCount;
    }

    @Override
    public void shareStrings(StringPool set) {
        IMarkerSetElement[] array = this.elements;
        if (array == null) {
            return;
        }
        IMarkerSetElement[] iMarkerSetElementArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerSetElement o = iMarkerSetElementArray[n2];
            if (o instanceof IStringPoolParticipant) {
                ((IStringPoolParticipant)((Object)o)).shareStrings(set);
            }
            ++n2;
        }
    }
}

