/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import paper.libs.org.eclipse.core.filesystem.IFileInfo;
import paper.libs.org.eclipse.core.filesystem.IFileStore;
import paper.libs.org.eclipse.core.internal.resources.Container;
import paper.libs.org.eclipse.core.internal.resources.Project;
import paper.libs.org.eclipse.core.internal.resources.ProjectInfo;
import paper.libs.org.eclipse.core.internal.resources.ProjectPreferences;
import paper.libs.org.eclipse.core.internal.resources.Resource;
import paper.libs.org.eclipse.core.internal.resources.ResourceException;
import paper.libs.org.eclipse.core.internal.resources.ResourceInfo;
import paper.libs.org.eclipse.core.internal.resources.Workspace;
import paper.libs.org.eclipse.core.internal.utils.BitMask;
import paper.libs.org.eclipse.core.internal.utils.FileUtil;
import paper.libs.org.eclipse.core.internal.utils.Messages;
import paper.libs.org.eclipse.core.resources.IFile;
import paper.libs.org.eclipse.core.resources.IFileState;
import paper.libs.org.eclipse.core.resources.IFolder;
import paper.libs.org.eclipse.core.resources.IResource;
import paper.libs.org.eclipse.core.runtime.Assert;
import paper.libs.org.eclipse.core.runtime.CoreException;
import paper.libs.org.eclipse.core.runtime.IPath;
import paper.libs.org.eclipse.core.runtime.IProgressMonitor;
import paper.libs.org.eclipse.core.runtime.OperationCanceledException;
import paper.libs.org.eclipse.core.runtime.Path;
import paper.libs.org.eclipse.core.runtime.Platform;
import paper.libs.org.eclipse.core.runtime.QualifiedName;
import paper.libs.org.eclipse.core.runtime.SubMonitor;
import paper.libs.org.eclipse.core.runtime.content.IContentDescription;
import paper.libs.org.eclipse.core.runtime.content.IContentTypeManager;
import paper.libs.org.eclipse.core.runtime.jobs.ISchedulingRule;
import paper.libs.org.eclipse.osgi.util.NLS;

public class File
extends Resource
implements IFile {
    protected File(IPath path, Workspace container) {
        super(path, container);
    }

    @Override
    public void appendContents(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind(Messages.resources_settingContents, this.getFullPath());
        SubMonitor subMonitor = SubMonitor.convert(monitor, message, 100);
        try {
            Assert.isNotNull(content, "Content cannot be null.");
            if (this.workspace.shouldValidate) {
                this.workspace.validateSave(this);
            }
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                try {
                    this.workspace.prepareOperation(rule, subMonitor.newChild(1));
                    ResourceInfo info = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(info));
                    this.workspace.beginOperation(true);
                    IFileInfo fileInfo = this.getStore().fetchInfo();
                    this.internalSetContents(content, fileInfo, updateFlags, true, subMonitor.newChild(99));
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            finally {
                this.workspace.endOperation(rule, true);
            }
        }
        finally {
            subMonitor.done();
            FileUtil.safeClose(content);
        }
    }

    @Override
    public void appendContents(InputStream content, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.appendContents(content, updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    public IFolder changeToFolder() throws CoreException {
        this.getPropertyManager().deleteProperties(this, 0);
        IFolder result = this.workspace.getRoot().getFolder(this.path);
        if (this.isLinked()) {
            IPath location = this.getRawLocation();
            this.delete(0, null);
            result.createLink(location, 16, null);
        } else {
            this.workspace.deleteResource(this);
            this.workspace.createResource((IResource)result, false);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void create(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind(Messages.resources_creating, this.getFullPath());
        SubMonitor subMonitor = SubMonitor.convert(monitor, message, 100);
        try {
            this.checkValidPath(this.path, 1, true);
            ISchedulingRule rule = this.workspace.getRuleFactory().createRule(this);
            try {
                try {
                    boolean local;
                    this.workspace.prepareOperation(rule, subMonitor.newChild(1));
                    this.checkDoesNotExist();
                    Container parent = (Container)this.getParent();
                    ResourceInfo info = parent.getResourceInfo(false, false);
                    parent.checkAccessible(this.getFlags(info));
                    this.checkValidGroupContainer(parent, false, false);
                    this.workspace.beginOperation(true);
                    IFileStore store = this.getStore();
                    IFileInfo localInfo = store.fetchInfo();
                    if (BitMask.isSet(updateFlags, 1)) {
                        if (!Workspace.caseSensitive && localInfo.exists()) {
                            String name2 = this.getLocalManager().getLocalName(store);
                            if (name2 != null && !localInfo.getName().equals(name2)) {
                                message = NLS.bind(Messages.resources_existsLocalDifferentCase, new Path(store.toString()).removeLastSegments(1).append(name2).toOSString());
                                throw new ResourceException(275, this.getFullPath(), message, null);
                            }
                            this.delete(true, null);
                        }
                    } else if (localInfo.exists()) {
                        String name3;
                        if (!Workspace.caseSensitive && (name3 = this.getLocalManager().getLocalName(store)) != null && !localInfo.getName().equals(name3)) {
                            message = NLS.bind(Messages.resources_existsLocalDifferentCase, new Path(store.toString()).removeLastSegments(1).append(name3).toOSString());
                            throw new ResourceException(275, this.getFullPath(), message, null);
                        }
                        message = NLS.bind(Messages.resources_fileExists, store.toString());
                        throw new ResourceException(272, this.getFullPath(), message, null);
                    }
                    subMonitor.worked(40);
                    info = this.workspace.createResource((IResource)this, updateFlags);
                    boolean bl = local = content != null;
                    if (local) {
                        try {
                            this.internalSetContents(content, localInfo, updateFlags, false, subMonitor.newChild(59));
                        }
                        catch (CoreException | OperationCanceledException e) {
                            this.workspace.deleteResource(this);
                            store.delete(0, null);
                            throw e;
                        }
                    }
                    this.internalSetLocal(local, 0);
                    if (local) return;
                    this.getResourceInfo(true, true).clearModificationStamp();
                    return;
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            finally {
                this.workspace.endOperation(rule, true);
            }
        }
        finally {
            subMonitor.done();
            FileUtil.safeClose(content);
        }
    }

    @Override
    public void create(InputStream content, boolean force, IProgressMonitor monitor) throws CoreException {
        this.create(content, force ? 1 : 0, monitor);
    }

    @Override
    public String getCharset() throws CoreException {
        return this.getCharset(true);
    }

    @Override
    public String getCharset(boolean checkImplicit) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        if (!this.exists(flags, false)) {
            return checkImplicit ? this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true) : null;
        }
        this.checkLocal(flags, 0);
        try {
            return this.internalGetCharset(checkImplicit, info);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 368) {
                return checkImplicit ? this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true) : null;
            }
            throw e;
        }
    }

    @Override
    public String getCharsetFor(Reader contents2) throws CoreException {
        IContentDescription description;
        String charset;
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        if (this.exists(flags, true) && (charset = this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), false)) != null) {
            return charset;
        }
        try {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            description = contentTypeManager.getDescriptionFor(contents2, this.getName(), new QualifiedName[]{IContentDescription.CHARSET});
        }
        catch (IOException e) {
            String message = NLS.bind(Messages.resources_errorContentDescription, this.getFullPath());
            throw new ResourceException(381, this.getFullPath(), message, e);
        }
        if (description != null && (charset = description.getCharset()) != null) {
            return charset;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true);
    }

    private String internalGetCharset(boolean checkImplicit, ResourceInfo info) throws CoreException {
        String contentCharset;
        String charset = this.workspace.getCharsetManager().getCharsetFor(this.getFullPath(), false);
        if (charset != null || !checkImplicit) {
            return charset;
        }
        IContentDescription description = this.workspace.getContentDescriptionManager().getDescriptionFor(this, info, true);
        if (description != null && (contentCharset = description.getCharset()) != null) {
            return contentCharset;
        }
        return this.workspace.getCharsetManager().getCharsetFor(this.getFullPath().removeLastSegments(1), true);
    }

    @Override
    public IContentDescription getContentDescription() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        boolean isSynchronized = this.isSynchronized(0);
        if (!isSynchronized && !this.getLocalManager().isLightweightAutoRefreshEnabled()) {
            String message = NLS.bind(Messages.localstore_resourceIsOutOfSync, this.getFullPath());
            throw new ResourceException(274, this.getFullPath(), message, null);
        }
        return this.workspace.getContentDescriptionManager().getDescriptionFor(this, info, isSynchronized);
    }

    @Override
    public InputStream getContents() throws CoreException {
        return this.getContents(this.getLocalManager().isLightweightAutoRefreshEnabled());
    }

    @Override
    public InputStream getContents(boolean force) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.getLocalManager().read(this, force, null);
    }

    @Override
    @Deprecated
    public int getEncoding() throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        int flags = this.getFlags(info);
        this.checkAccessible(flags);
        this.checkLocal(flags, 0);
        return this.getLocalManager().getEncoding(this);
    }

    @Override
    public IFileState[] getHistory(IProgressMonitor monitor) {
        return this.getLocalManager().getHistoryStore().getStates(this.getFullPath(), monitor);
    }

    @Override
    public int getType() {
        return 1;
    }

    protected void internalSetContents(InputStream content, IFileInfo fileInfo, int updateFlags, boolean append, IProgressMonitor monitor) throws CoreException {
        if (content == null) {
            content = new ByteArrayInputStream(new byte[0]);
        }
        this.getLocalManager().write(this, content, fileInfo, updateFlags, append, monitor);
        this.updateMetadataFiles();
        this.workspace.getAliasManager().updateAliases(this, this.getStore(), 0, monitor);
    }

    @Override
    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
        if (!this.getLocalManager().fastIsSynchronized(this)) {
            super.refreshLocal(0, monitor);
        }
    }

    @Override
    public void setContents(IFileState content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.setContents(content.getContents(), updateFlags, monitor);
    }

    @Override
    public void setContents(InputStream content, int updateFlags, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind(Messages.resources_settingContents, this.getFullPath());
        SubMonitor subMonitor = SubMonitor.convert(monitor, message, 100);
        try {
            if (this.workspace.shouldValidate) {
                this.workspace.validateSave(this);
            }
            ISchedulingRule rule = this.workspace.getRuleFactory().modifyRule(this);
            try {
                try {
                    this.workspace.prepareOperation(rule, subMonitor.newChild(1));
                    ResourceInfo info = this.getResourceInfo(false, false);
                    this.checkAccessible(this.getFlags(info));
                    this.workspace.beginOperation(true);
                    IFileInfo fileInfo = this.getStore().fetchInfo();
                    this.internalSetContents(content, fileInfo, updateFlags, false, subMonitor.newChild(99));
                }
                catch (OperationCanceledException e) {
                    this.workspace.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            finally {
                this.workspace.endOperation(rule, true);
            }
        }
        finally {
            subMonitor.done();
            FileUtil.safeClose(content);
        }
    }

    @Override
    public long setLocalTimeStamp(long value) throws CoreException {
        ResourceInfo projectInfo;
        long result = super.setLocalTimeStamp(value);
        if (this.path.segmentCount() == 2 && this.path.segment(1).equals(".project") && (projectInfo = ((Project)this.getProject()).getResourceInfo(false, false)) != null) {
            this.getLocalManager().updateLocalSync(projectInfo, result);
        }
        return result;
    }

    public void updateMetadataFiles() throws CoreException {
        int count = this.path.segmentCount();
        String name2 = this.path.segment(1);
        if (count == 2 && name2.equals(".project")) {
            Project project = (Project)this.getProject();
            project.updateDescription();
            ProjectInfo projectInfo = (ProjectInfo)project.getResourceInfo(false, true);
            projectInfo.discardNatures();
            return;
        }
        if (count == 3 && ".settings".equals(name2)) {
            ProjectPreferences.updatePreferences(this);
            return;
        }
    }

    @Override
    @Deprecated
    public void setCharset(String newCharset) throws CoreException {
        ResourceInfo info = this.getResourceInfo(false, false);
        this.checkAccessible(this.getFlags(info));
        this.workspace.getCharsetManager().setCharsetFor(this.getFullPath(), newCharset);
    }

    @Override
    public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
        String message = NLS.bind(Messages.resources_settingCharset, this.getFullPath());
        SubMonitor subMonitor = SubMonitor.convert(monitor, message, 100);
        ISchedulingRule rule = this.workspace.getRuleFactory().charsetRule(this);
        try {
            try {
                this.workspace.prepareOperation(rule, subMonitor.newChild(1));
                ResourceInfo info = this.getResourceInfo(false, false);
                this.checkAccessible(this.getFlags(info));
                this.workspace.beginOperation(true);
                this.workspace.getCharsetManager().setCharsetFor(this.getFullPath(), newCharset);
                info = this.getResourceInfo(false, true);
                info.incrementCharsetGenerationCount();
                subMonitor.worked(99);
            }
            catch (OperationCanceledException e) {
                this.workspace.getWorkManager().operationCanceled();
                throw e;
            }
        }
        finally {
            subMonitor.done();
            this.workspace.endOperation(rule, true);
        }
    }

    @Override
    public void setContents(InputStream content, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.setContents(content, updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    @Override
    public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.setContents(source.getContents(), updateFlags |= keepHistory ? 2 : 0, monitor);
    }
}

