/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.internal.registry.osgi;

import paper.libs.org.eclipse.core.internal.registry.RegistryMessages;
import paper.libs.org.eclipse.core.internal.registry.osgi.Activator;
import paper.libs.org.eclipse.core.internal.runtime.RuntimeLog;
import paper.libs.org.eclipse.core.runtime.Status;
import paper.libs.org.eclipse.osgi.service.datalocation.Location;
import paper.libs.org.eclipse.osgi.service.debug.DebugOptions;
import paper.libs.org.osgi.framework.Bundle;
import paper.libs.org.osgi.framework.BundleContext;
import paper.libs.org.osgi.framework.Filter;
import paper.libs.org.osgi.framework.InvalidSyntaxException;
import paper.libs.org.osgi.service.packageadmin.PackageAdmin;
import paper.libs.org.osgi.util.tracker.ServiceTracker;

public class OSGIUtils {
    private ServiceTracker<?, ?> debugTracker = null;
    private ServiceTracker<?, ?> bundleTracker = null;
    private ServiceTracker<?, ?> configurationLocationTracker = null;
    public static final String PROP_CONFIG_AREA = "osgi.configuration.area";
    public static final String PROP_INSTANCE_AREA = "osgi.instance.area";
    private static final OSGIUtils singleton = new OSGIUtils();

    public static OSGIUtils getDefault() {
        return singleton;
    }

    private OSGIUtils() {
        this.initServices();
    }

    private void initServices() {
        BundleContext context = Activator.getContext();
        if (context == null) {
            RuntimeLog.log(new Status(4, "paper.libs.org.eclipse.equinox.registry", 0, RegistryMessages.bundle_not_activated, null));
            return;
        }
        this.debugTracker = new ServiceTracker(context, DebugOptions.class.getName(), null);
        this.debugTracker.open();
        this.bundleTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        this.bundleTracker.open();
        Filter filter = null;
        try {
            filter = context.createFilter("(&(objectClass=org.eclipse.osgi.service.datalocation.Location)(type=osgi.configuration.area))");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        this.configurationLocationTracker = new ServiceTracker(context, filter, null);
        this.configurationLocationTracker.open();
    }

    void closeServices() {
        if (this.debugTracker != null) {
            this.debugTracker.close();
            this.debugTracker = null;
        }
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.configurationLocationTracker != null) {
            this.configurationLocationTracker.close();
            this.configurationLocationTracker = null;
        }
    }

    public boolean getBooleanDebugOption(String option, boolean defaultValue) {
        String value;
        if (this.debugTracker == null) {
            RuntimeLog.log(new Status(4, "paper.libs.org.eclipse.equinox.registry", 0, RegistryMessages.bundle_not_activated, null));
            return defaultValue;
        }
        DebugOptions options = (DebugOptions)this.debugTracker.getService();
        if (options != null && (value = options.getOption(option)) != null) {
            return value.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    public PackageAdmin getPackageAdmin() {
        if (this.bundleTracker == null) {
            RuntimeLog.log(new Status(4, "paper.libs.org.eclipse.equinox.registry", 0, RegistryMessages.bundle_not_activated, null));
            return null;
        }
        return (PackageAdmin)this.bundleTracker.getService();
    }

    public Bundle getBundle(String bundleName) {
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(bundleName, null);
        if (bundles == null) {
            return null;
        }
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if ((bundle.getState() & 3) == 0) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    public Bundle[] getFragments(Bundle bundle) {
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return null;
        }
        return packageAdmin.getFragments(bundle);
    }

    public boolean isFragment(Bundle bundle) {
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return false;
        }
        return (packageAdmin.getBundleType(bundle) & 1) > 0;
    }

    public Bundle[] getHosts(Bundle bundle) {
        PackageAdmin packageAdmin = this.getPackageAdmin();
        if (packageAdmin == null) {
            return null;
        }
        return packageAdmin.getHosts(bundle);
    }

    public Location getConfigurationLocation() {
        if (this.configurationLocationTracker == null) {
            return null;
        }
        return (Location)this.configurationLocationTracker.getService();
    }
}

