/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.eclipse.core.commands.contexts;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import paper.libs.org.eclipse.core.commands.common.NamedHandleObject;
import paper.libs.org.eclipse.core.commands.common.NotDefinedException;
import paper.libs.org.eclipse.core.commands.contexts.ContextEvent;
import paper.libs.org.eclipse.core.commands.contexts.IContextListener;
import paper.libs.org.eclipse.core.internal.commands.util.Util;

public final class Context
extends NamedHandleObject
implements Comparable {
    private Set<IContextListener> listeners;
    private String parentId;

    Context(String id) {
        super(id);
    }

    public final void addContextListener(IContextListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        if (this.listeners == null) {
            this.listeners = new HashSet<IContextListener>();
        }
        this.listeners.add(listener);
    }

    public final int compareTo(Object object) {
        Context scheme = (Context)object;
        int compareTo = Util.compare(this.id, scheme.id);
        if (compareTo == 0 && (compareTo = Util.compare(this.name, scheme.name)) == 0 && (compareTo = Util.compare(this.parentId, scheme.parentId)) == 0 && (compareTo = Util.compare(this.description, scheme.description)) == 0) {
            compareTo = Util.compare(this.defined, scheme.defined);
        }
        return compareTo;
    }

    public final void define(String name2, String description, String parentId) {
        if (name2 == null) {
            throw new NullPointerException("The name of a context cannot be null");
        }
        boolean definedChanged = !this.defined;
        this.defined = true;
        boolean nameChanged = !Objects.equals(this.name, name2);
        this.name = name2;
        boolean descriptionChanged = !Objects.equals(this.description, description);
        this.description = description;
        boolean parentIdChanged = !Objects.equals(this.parentId, parentId);
        this.parentId = parentId;
        this.fireContextChanged(new ContextEvent(this, definedChanged, nameChanged, descriptionChanged, parentIdChanged));
    }

    private final void fireContextChanged(ContextEvent event) {
        if (event == null) {
            throw new NullPointerException("Cannot send a null event to listeners.");
        }
        if (this.listeners == null) {
            return;
        }
        for (IContextListener listener : this.listeners) {
            listener.contextChanged(event);
        }
    }

    public final String getParentId() throws NotDefinedException {
        if (!this.defined) {
            throw new NotDefinedException("Cannot get the parent identifier from an undefined context. " + this.id);
        }
        return this.parentId;
    }

    public final void removeContextListener(IContextListener contextListener) {
        if (contextListener == null) {
            throw new NullPointerException("Cannot remove a null listener.");
        }
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(contextListener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    @Override
    public final String toString() {
        if (this.string == null) {
            StringBuilder stringBuffer = new StringBuilder("Context(");
            stringBuffer.append(this.id);
            stringBuffer.append(',');
            stringBuffer.append(this.name);
            stringBuffer.append(',');
            stringBuffer.append(this.description);
            stringBuffer.append(',');
            stringBuffer.append(this.parentId);
            stringBuffer.append(',');
            stringBuffer.append(this.defined);
            stringBuffer.append(')');
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    @Override
    public final void undefine() {
        this.string = null;
        boolean definedChanged = this.defined;
        this.defined = false;
        boolean nameChanged = this.name != null;
        this.name = null;
        boolean descriptionChanged = this.description != null;
        this.description = null;
        boolean parentIdChanged = this.parentId != null;
        this.parentId = null;
        this.fireContextChanged(new ContextEvent(this, definedChanged, nameChanged, descriptionChanged, parentIdChanged));
    }
}

