/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.mercury.analysis;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import paper.libs.org.cadixdev.bombe.analysis.CachingInheritanceProvider;
import paper.libs.org.cadixdev.bombe.analysis.InheritanceProvider;
import paper.libs.org.cadixdev.bombe.analysis.InheritanceType;
import paper.libs.org.cadixdev.bombe.type.signature.FieldSignature;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;
import paper.libs.org.cadixdev.mercury.Mercury;
import paper.libs.org.cadixdev.mercury.util.BombeBindings;
import paper.libs.org.eclipse.jdt.core.dom.ITypeBinding;
import paper.libs.org.eclipse.jdt.core.dom.IVariableBinding;

public class MercuryInheritanceProvider
implements InheritanceProvider {
    private final Mercury mercury;

    public static InheritanceProvider get(Mercury mercury) {
        return (InheritanceProvider)mercury.getContext().computeIfAbsent(InheritanceProvider.class, i2 -> new CachingInheritanceProvider(new MercuryInheritanceProvider(mercury)));
    }

    private MercuryInheritanceProvider(Mercury mercury) {
        this.mercury = mercury;
    }

    @Override
    public Optional<InheritanceProvider.ClassInfo> provide(String klass) {
        return this.mercury.createTypeBinding(klass).map(this::provide);
    }

    @Override
    public Optional<InheritanceProvider.ClassInfo> provide(String klass, Object context) {
        if (context instanceof ITypeBinding) {
            return Optional.of(this.provide((ITypeBinding)context));
        }
        return this.provide(klass);
    }

    public InheritanceProvider.ClassInfo provide(ITypeBinding binding) {
        return new BindingClassInfo(binding.getErasure()).lazy();
    }

    private static class BindingClassInfo
    extends InheritanceProvider.ClassInfo.Abstract {
        private final ITypeBinding binding;

        private BindingClassInfo(ITypeBinding binding) {
            this.binding = binding;
        }

        private static String getInternalName(ITypeBinding binding) {
            return binding.getBinaryName().replace('.', '/');
        }

        @Override
        public String getName() {
            return BindingClassInfo.getInternalName(this.binding);
        }

        @Override
        public boolean isInterface() {
            return this.binding.isInterface();
        }

        @Override
        public String getSuperName() {
            ITypeBinding superClass = this.binding.getSuperclass();
            return superClass != null ? BindingClassInfo.getInternalName(superClass) : "";
        }

        @Override
        public List<String> getInterfaces() {
            return Collections.unmodifiableList(Arrays.stream(this.binding.getInterfaces()).map(BindingClassInfo::getInternalName).collect(Collectors.toList()));
        }

        @Override
        public Map<FieldSignature, InheritanceType> getFields() {
            return Collections.unmodifiableMap(Arrays.stream(this.binding.getDeclaredFields()).collect(Collectors.toMap(BombeBindings::convertSignature, f -> InheritanceType.fromModifiers(f.getModifiers()))));
        }

        @Override
        public Map<String, InheritanceType> getFieldsByName() {
            return Collections.unmodifiableMap(Arrays.stream(this.binding.getDeclaredFields()).collect(Collectors.toMap(IVariableBinding::getName, f -> InheritanceType.fromModifiers(f.getModifiers()))));
        }

        @Override
        public Map<MethodSignature, InheritanceType> getMethods() {
            return Collections.unmodifiableMap(Arrays.stream(this.binding.getDeclaredMethods()).collect(Collectors.toMap(BombeBindings::convertSignature, m -> InheritanceType.fromModifiers(m.getModifiers()))));
        }

        private void provideParent(InheritanceProvider provider, ITypeBinding parent, Collection<InheritanceProvider.ClassInfo> parents) {
            if (parent == null) {
                return;
            }
            InheritanceProvider.ClassInfo parentInfo = provider.provide(BindingClassInfo.getInternalName(parent), parent).orElse(null);
            if (parentInfo != null) {
                parentInfo.provideParents(provider, parents);
                parents.add(parentInfo);
            }
        }

        @Override
        public void provideParents(InheritanceProvider provider, Collection<InheritanceProvider.ClassInfo> parents) {
            this.provideParent(provider, this.binding.getSuperclass(), parents);
            for (ITypeBinding iface : this.binding.getInterfaces()) {
                this.provideParent(provider, iface, parents);
            }
        }
    }
}

