/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.lorenz.asm;

import java.util.Objects;
import java.util.Optional;
import paper.libs.org.cadixdev.bombe.asm.jar.ClassProvider;
import paper.libs.org.cadixdev.bombe.type.FieldType;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.FieldMapping;
import paper.libs.org.cadixdev.lorenz.model.jar.FieldTypeProvider;
import paper.libs.org.objectweb.asm.tree.ClassNode;
import paper.libs.org.objectweb.asm.tree.FieldNode;

public class AsmFieldTypeProvider
implements FieldTypeProvider {
    private final ClassProvider classProvider;

    public AsmFieldTypeProvider(ClassProvider classProvider) {
        this.classProvider = classProvider;
    }

    @Override
    public Optional<FieldType> provide(FieldMapping mapping) {
        String owner = ((ClassMapping)mapping.getParent()).getFullObfuscatedName();
        ClassNode node = this.classProvider.getAsNode(owner);
        if (node == null) {
            return Optional.empty();
        }
        Optional<FieldNode> fieldNode = node.fields.stream().filter(field -> Objects.equals(field.name, mapping.getObfuscatedName())).findAny();
        if (fieldNode.isPresent()) {
            FieldType type = FieldType.of(fieldNode.get().desc);
            return Optional.of(type);
        }
        return Optional.empty();
    }
}

