/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.cadixdev.at.impl;

import java.util.Objects;
import java.util.Optional;
import paper.libs.org.cadixdev.at.AccessTransform;
import paper.libs.org.cadixdev.at.AccessTransformSet;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.Mapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;

final class AccessTransformSetMapper {
    private AccessTransformSetMapper() {
    }

    static AccessTransformSet remap(AccessTransformSet set, MappingSet mappings) {
        Objects.requireNonNull(set, "set");
        Objects.requireNonNull(mappings, "mappings");
        AccessTransformSet remapped = AccessTransformSet.create();
        set.getClasses().forEach((className, classSet) -> {
            Optional<ClassMapping<?, ?>> mapping = mappings.getClassMapping((String)className);
            AccessTransformSetMapper.remap(mapping, classSet, remapped.getOrCreateClass(mapping.map(Mapping::getFullDeobfuscatedName).orElse((String)className)));
        });
        return remapped;
    }

    private static void remap(Optional<? extends ClassMapping<?, ?>> mapping, AccessTransformSet.Class set, AccessTransformSet.Class remapped) {
        remapped.merge(set.get());
        remapped.mergeAllFields(set.allFields());
        remapped.mergeAllMethods(set.allMethods());
        set.getFields().forEach((name2, transform) -> remapped.mergeField(mapping.flatMap(m -> m.getFieldMapping((String)name2)).map(Mapping::getDeobfuscatedName).orElse((String)name2), (AccessTransform)transform));
        set.getMethods().forEach((signature, transform) -> remapped.mergeMethod(mapping.flatMap(m -> m.getMethodMapping((MethodSignature)signature)).map(MethodMapping::getDeobfuscatedSignature).orElse((MethodSignature)signature), (AccessTransform)transform));
    }
}

