/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.org.apache.http.impl.client;

import paper.libs.org.apache.http.HeaderElement;
import paper.libs.org.apache.http.HttpResponse;
import paper.libs.org.apache.http.annotation.Contract;
import paper.libs.org.apache.http.annotation.ThreadingBehavior;
import paper.libs.org.apache.http.conn.ConnectionKeepAliveStrategy;
import paper.libs.org.apache.http.message.BasicHeaderElementIterator;
import paper.libs.org.apache.http.protocol.HttpContext;
import paper.libs.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

