/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.io.sigpipe.jbsdiff.sort;

import paper.libs.io.sigpipe.jbsdiff.sort.SearchResult;

public class SuffixSort {
    public static void qsufsort(int[] I, int[] V, byte[] data) {
        int i2;
        int[] buckets = new int[256];
        for (i2 = 0; i2 < data.length; ++i2) {
            int n = data[i2] & 0xFF;
            buckets[n] = buckets[n] + 1;
        }
        for (i2 = 1; i2 < 256; ++i2) {
            int n = i2;
            buckets[n] = buckets[n] + buckets[i2 - 1];
        }
        for (i2 = 255; i2 > 0; --i2) {
            buckets[i2] = buckets[i2 - 1];
        }
        buckets[0] = 0;
        i2 = 0;
        while (i2 < data.length) {
            int n = data[i2] & 0xFF;
            int n2 = buckets[n] + 1;
            buckets[n] = n2;
            I[n2] = i2++;
        }
        I[0] = data.length;
        for (i2 = 0; i2 < data.length; ++i2) {
            V[i2] = buckets[data[i2] & 0xFF];
        }
        V[data.length] = 0;
        for (i2 = 1; i2 < 256; ++i2) {
            if (buckets[i2] != buckets[i2 - 1] + 1) continue;
            I[buckets[i2]] = -1;
        }
        I[0] = -1;
        int h = 1;
        while (I[0] != -(data.length + 1)) {
            int len = 0;
            i2 = 0;
            while (i2 < data.length + 1) {
                if (I[i2] < 0) {
                    len -= I[i2];
                    i2 -= I[i2];
                    continue;
                }
                if (len != 0) {
                    I[i2 - len] = -len;
                }
                len = V[I[i2]] + 1 - i2;
                SuffixSort.split(I, V, i2, len, h);
                i2 += len;
                len = 0;
            }
            if (len != 0) {
                I[i2 - len] = -len;
            }
            h += h;
        }
        for (i2 = 0; i2 < data.length + 1; ++i2) {
            I[V[i2]] = i2;
        }
    }

    public static void split(int[] I, int[] V, int start, int len, int h) {
        int tmp;
        int i2;
        if (len < 16) {
            int j;
            for (int k = start; k < start + len; k += j) {
                j = 1;
                int x = V[I[k] + h];
                int i3 = 1;
                while (k + i3 < start + len) {
                    if (V[I[k + i3] + h] < x) {
                        x = V[I[k + i3] + h];
                        j = 0;
                    }
                    if (V[I[k + i3] + h] == x) {
                        int tmp2 = I[k + j];
                        I[k + j] = I[k + i3];
                        I[k + i3] = tmp2;
                        ++j;
                    }
                    ++i3;
                }
                for (i3 = 0; i3 < j; ++i3) {
                    V[I[k + i3]] = k + j - 1;
                }
                if (j != 1) continue;
                I[k] = -1;
            }
            return;
        }
        int x = V[I[start + len / 2] + h];
        int jj = 0;
        int kk = 0;
        for (i2 = start; i2 < start + len; ++i2) {
            if (V[I[i2] + h] < x) {
                ++jj;
            }
            if (V[I[i2] + h] != x) continue;
            ++kk;
        }
        kk += (jj += start);
        i2 = start;
        int j = 0;
        int k = 0;
        while (i2 < jj) {
            if (V[I[i2] + h] < x) {
                ++i2;
                continue;
            }
            if (V[I[i2] + h] == x) {
                tmp = I[i2];
                I[i2] = I[jj + j];
                I[jj + j] = tmp;
                ++j;
                continue;
            }
            tmp = I[i2];
            I[i2] = I[kk + k];
            I[kk + k] = tmp;
            ++k;
        }
        while (jj + j < kk) {
            if (V[I[jj + j] + h] == x) {
                ++j;
                continue;
            }
            tmp = I[jj + j];
            I[jj + j] = I[kk + k];
            I[kk + k] = tmp;
            ++k;
        }
        if (jj > start) {
            SuffixSort.split(I, V, start, jj - start, h);
        }
        for (i2 = 0; i2 < kk - jj; ++i2) {
            V[I[jj + i2]] = kk - 1;
        }
        if (jj == kk - 1) {
            I[jj] = -1;
        }
        if (start + len > kk) {
            SuffixSort.split(I, V, kk, start + len - kk, h);
        }
    }

    private static int matchLength(byte[] bytesA, int offsetA, byte[] bytesB, int offsetB) {
        int i2;
        int oldLimit = bytesA.length - offsetA;
        int newLimit = bytesB.length - offsetB;
        for (i2 = 0; i2 < oldLimit && i2 < newLimit && bytesA[i2 + offsetA] == bytesB[i2 + offsetB]; ++i2) {
        }
        return i2;
    }

    public static SearchResult search(int[] I, byte[] oldBytes, int oldOffset, byte[] newBytes, int newOffset, int start, int end) {
        if (end - start < 2) {
            int y;
            int x = SuffixSort.matchLength(oldBytes, I[start], newBytes, newOffset);
            if (x > (y = SuffixSort.matchLength(oldBytes, I[end], newBytes, newOffset))) {
                return new SearchResult(x, I[start]);
            }
            return new SearchResult(y, I[end]);
        }
        int center = start + (end - start) / 2;
        if (SuffixSort.compareBytes(oldBytes, I[center], newBytes, newOffset) < 0) {
            return SuffixSort.search(I, oldBytes, 0, newBytes, newOffset, center, end);
        }
        return SuffixSort.search(I, oldBytes, 0, newBytes, newOffset, start, center);
    }

    private static int compareBytes(byte[] bytesA, int offsetA, byte[] bytesB, int offsetB) {
        int length = Math.min(bytesA.length - offsetA, bytesB.length - offsetB);
        int valA = 0;
        int valB = 0;
        for (int i2 = 0; i2 < length && (valA = bytesA[i2 + offsetA] & 0xFF) == (valB = bytesB[i2 + offsetB] & 0xFF); ++i2) {
        }
        return valA - valB;
    }
}

