/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.mappings.changes;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import paper.libs.dev.denwav.hypo.mappings.LorenzUtil;
import paper.libs.dev.denwav.hypo.mappings.MergeResult;
import paper.libs.dev.denwav.hypo.mappings.MergeableMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.changes.AbstractMappingsChange;
import paper.libs.dev.denwav.hypo.mappings.changes.MemberReference;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.model.ClassMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodMapping;
import paper.libs.org.cadixdev.lorenz.model.MethodParameterMapping;

public class RemoveParameterMappingChange
extends AbstractMappingsChange
implements MergeableMappingsChange<RemoveParameterMappingChange> {
    private final long indices;

    private RemoveParameterMappingChange(@NotNull MemberReference target, long index) {
        super(target);
        this.indices = index;
    }

    @Contract(value="_, _ -> new", pure=true)
    @NotNull
    public static RemoveParameterMappingChange of(@NotNull MemberReference target, int index) {
        return new RemoveParameterMappingChange(target, RemoveParameterMappingChange.toBit(index));
    }

    @Override
    public void applyChange(@NotNull MappingSet input, @NotNull MemberReference target) {
        if (target.desc() == null) {
            return;
        }
        ClassMapping<?, ?> classMapping = LorenzUtil.getClassMapping(input, target.className());
        if (classMapping == null) {
            return;
        }
        MethodMapping methodMapping = LorenzUtil.getMethodMapping(classMapping, target.name(), target.desc());
        if (methodMapping == null) {
            return;
        }
        for (int i2 = 0; i2 < 64; ++i2) {
            MethodParameterMapping paramMapping;
            if (!RemoveParameterMappingChange.isBitSet(this.indices, i2) || (paramMapping = LorenzUtil.getParameterMapping(methodMapping, i2)) == null) continue;
            LorenzUtil.removeParamMapping(paramMapping);
        }
    }

    @Override
    @NotNull
    public MergeResult<RemoveParameterMappingChange> mergeWith(@NotNull RemoveParameterMappingChange that) {
        return MergeResult.success(new RemoveParameterMappingChange(this.target(), this.indices | that.indices));
    }

    private static long toBit(int number) {
        return 1L << number;
    }

    private static boolean isBitSet(long bitset, int index) {
        return (bitset >> index & 1L) == 1L;
    }
}

