/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.dev.denwav.hypo.hydrate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import paper.libs.dev.denwav.hypo.core.HypoContext;
import paper.libs.dev.denwav.hypo.hydrate.ClassDataHydrator;
import paper.libs.dev.denwav.hypo.hydrate.HydrationManager;
import paper.libs.dev.denwav.hypo.hydrate.HydrationProvider;
import paper.libs.dev.denwav.hypo.model.HypoModelUtil;
import paper.libs.dev.denwav.hypo.model.data.ClassData;
import paper.libs.dev.denwav.hypo.model.data.FieldData;
import paper.libs.dev.denwav.hypo.model.data.HypoData;
import paper.libs.dev.denwav.hypo.model.data.MethodData;

public class DefaultHydrationManager
implements HydrationManager {
    @NotNull
    private final ClassDataHydrator baseHydrator;
    @NotNull
    private final List<HydrationProvider<?>> classProviders = new ArrayList();
    @NotNull
    private final List<HydrationProvider<?>> methodProviders = new ArrayList();
    @NotNull
    private final List<HydrationProvider<?>> fieldProviders = new ArrayList();

    public DefaultHydrationManager() {
        this(ClassDataHydrator.createDefault());
    }

    public DefaultHydrationManager(@NotNull ClassDataHydrator baseHydrator) {
        this.baseHydrator = baseHydrator;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public HydrationManager register(@NotNull HydrationProvider<? extends HypoData> provider) {
        Class<? extends HypoData> targetClass = provider.target();
        if (ClassData.class.isAssignableFrom(targetClass)) {
            this.classProviders.add(provider);
        } else if (MethodData.class.isAssignableFrom(targetClass)) {
            this.methodProviders.add(provider);
        } else if (FieldData.class.isAssignableFrom(targetClass)) {
            this.fieldProviders.add(provider);
        } else {
            throw new IllegalArgumentException("Given HydrationProvider (" + provider + ") targets an invalid type: " + targetClass);
        }
        return this;
    }

    @Override
    public void hydrate(@NotNull HypoContext context) throws IOException {
        ExecutorService executor = context.getExecutor();
        try {
            this.baseHydrator.hydrate(context);
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            for (ClassData classData : context.getProvider().allClasses()) {
                futures.add(executor.submit(() -> {
                    for (HydrationProvider<?> provider : this.classProviders) {
                        if (!classData.getClass().isAssignableFrom(provider.target())) continue;
                        provider.hydrate((HypoData)HypoModelUtil.cast(classData), context);
                    }
                    for (MethodData method : classData.methods()) {
                        for (HydrationProvider<?> provider : this.methodProviders) {
                            if (!method.getClass().isAssignableFrom(provider.target())) continue;
                            provider.hydrate((HypoData)HypoModelUtil.cast(method), context);
                        }
                    }
                    for (FieldData field : classData.fields()) {
                        for (HydrationProvider<?> provider : this.fieldProviders) {
                            if (!field.getClass().isAssignableFrom(provider.target())) continue;
                            provider.hydrate((HypoData)HypoModelUtil.cast(field), context);
                        }
                    }
                    return null;
                }));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            HypoModelUtil.rethrow(e);
        }
    }
}

