/*
 * Decompiled with CFR 0.152.
 */
package paper.libs.com.google.gson.internal.bind;

import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.JsonSyntaxException;
import paper.libs.com.google.gson.TypeAdapter;
import paper.libs.com.google.gson.TypeAdapterFactory;
import paper.libs.com.google.gson.reflect.TypeToken;
import paper.libs.com.google.gson.stream.JsonReader;
import paper.libs.com.google.gson.stream.JsonToken;
import paper.libs.com.google.gson.stream.JsonWriter;

public final class SqlDateTypeAdapter
extends TypeAdapter<Date> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken2) {
            return typeToken2.getRawType() == Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    @Override
    public synchronized Date read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            long utilDate = this.format.parse(in.nextString()).getTime();
            return new Date(utilDate);
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Date value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

