/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.util.DelegatingOutputStream;
import io.papermc.paperweight.util.UselessOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u00020\u000b2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fJ\u0006\u0010\u0011\u001a\u00020\u0005J\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u001a\u0010\u0016\u001a\u00020\u00142\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000fJ\u001e\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\bJ\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/papermc/paperweight/util/Command;", "", "processBuilder", "Ljava/lang/ProcessBuilder;", "command", "", "(Ljava/lang/ProcessBuilder;Ljava/lang/String;)V", "errStream", "Ljava/io/OutputStream;", "outStream", "execute", "", "executeOut", "executeSilently", "silenceOut", "", "silenceErr", "getText", "readText", "run", "", "runOut", "runSilently", "setup", "out", "err", "silence", "paperweight-lib"})
public final class Command {
    private OutputStream outStream;
    private OutputStream errStream;
    private final ProcessBuilder processBuilder;
    private final String command;

    public final int run() {
        if (Intrinsics.areEqual((Object)System.getProperty("paperweight.debug", "false"), (Object)"true")) {
            OutputStream[] outputStreamArray = new OutputStream[2];
            outputStreamArray[0] = this.outStream;
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"System.out");
            outputStreamArray[1] = printStream;
            OutputStream outputStream = new DelegatingOutputStream(outputStreamArray);
            OutputStream[] outputStreamArray2 = new OutputStream[2];
            outputStreamArray2[0] = this.errStream;
            PrintStream printStream2 = System.err;
            Intrinsics.checkNotNullExpressionValue((Object)printStream2, (String)"System.err");
            outputStreamArray2[1] = printStream2;
            this.setup(outputStream, new DelegatingOutputStream(outputStreamArray2));
            boolean bl = false;
            System.out.println();
            StringBuilder stringBuilder = new StringBuilder().append("$ (pwd) ");
            File file = this.processBuilder.directory();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"processBuilder.directory()");
            String string = stringBuilder.append(file.getAbsolutePath()).toString();
            boolean bl2 = false;
            System.out.println((Object)string);
            string = "$ " + this.command;
            bl2 = false;
            System.out.println((Object)string);
        }
        try {
            Process process;
            Process process2 = process = this.processBuilder.start();
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
            InputStream input = process2.getInputStream();
            InputStream error = process.getErrorStream();
            byte[] buffer = new byte[1000];
            while (process.isAlive()) {
                int count;
                if (input.available() > 0) {
                    count = input.read(buffer);
                    this.outStream.write(buffer, 0, count);
                }
                if (error.available() > 0) {
                    count = error.read(buffer);
                    this.errStream.write(buffer, 0, count);
                }
                Thread.sleep(1L);
            }
            InputStream inputStream = input;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"input");
            this.outStream.write(ByteStreamsKt.readBytes((InputStream)inputStream));
            InputStream inputStream2 = error;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"error");
            this.errStream.write(ByteStreamsKt.readBytes((InputStream)inputStream2));
            return process.waitFor();
        }
        catch (Exception e) {
            throw (Throwable)new PaperweightException("Failed to call git command: " + this.command, e);
        }
    }

    public final int runSilently(boolean silenceOut, boolean silenceErr) {
        this.silence(silenceOut, silenceErr);
        return this.run();
    }

    public static /* synthetic */ int runSilently$default(Command command, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return command.runSilently(bl, bl2);
    }

    public final int runOut() {
        this.setup(System.out, System.err);
        return this.run();
    }

    public final void execute() {
        int res = this.run();
        if (res != 0) {
            throw (Throwable)new PaperweightException("Command finished with " + res + " exit code: " + this.command);
        }
    }

    public final void executeSilently(boolean silenceOut, boolean silenceErr) {
        this.silence(silenceOut, silenceErr);
        this.execute();
    }

    public static /* synthetic */ void executeSilently$default(Command command, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        command.executeSilently(bl, bl2);
    }

    private final void silence(boolean silenceOut, boolean silenceErr) {
        PrintStream out = silenceOut ? null : System.out;
        PrintStream err = silenceErr ? null : System.err;
        this.setup(out, err);
    }

    public final void executeOut() {
        this.setup(System.out, System.err);
        this.execute();
    }

    @NotNull
    public final Command setup(@Nullable OutputStream out, @Nullable OutputStream err) {
        OutputStream outputStream;
        OutputStream outputStream2 = out;
        if (outputStream2 == null) {
            outputStream2 = this.outStream = (OutputStream)UselessOutputStream.INSTANCE;
        }
        if ((outputStream = err) == null) {
            outputStream = UselessOutputStream.INSTANCE;
        }
        this.errStream = outputStream;
        return this;
    }

    public static /* synthetic */ Command setup$default(Command command, OutputStream outputStream, OutputStream outputStream2, int n, Object object) {
        if ((n & 1) != 0) {
            outputStream = null;
        }
        if ((n & 2) != 0) {
            outputStream2 = null;
        }
        return command.setup(outputStream, outputStream2);
    }

    @NotNull
    public final String getText() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.setup(out, System.err);
        this.execute();
        byte[] byArray2 = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"out.toByteArray()");
        byte[] byArray3 = byArray2;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.defaultCharset()");
        Charset charset2 = charset;
        boolean bl = false;
        return new String(byArray3, charset2);
    }

    @Nullable
    public final String readText() {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.setup(out, System.err);
        if (this.run() == 0) {
            byte[] byArray2 = out.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"out.toByteArray()");
            byte[] byArray3 = byArray2;
            Charset charset = Charset.defaultCharset();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.defaultCharset()");
            Charset charset2 = charset;
            boolean bl = false;
            string = new String(byArray3, charset2);
        } else {
            string = null;
        }
        return string;
    }

    public Command(@NotNull ProcessBuilder processBuilder, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)processBuilder, (String)"processBuilder");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.processBuilder = processBuilder;
        this.command = command;
        this.outStream = UselessOutputStream.INSTANCE;
        this.errStream = UselessOutputStream.INSTANCE;
    }
}

