/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.util;

import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.org.objectweb.asm.ClassReader;
import paper.libs.org.objectweb.asm.tree.ClassNode;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002R.\u0010\u0006\u001a\"\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007j\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/papermc/paperweight/util/ClassNodeCache;", "", "jarFile", "Ljava/nio/file/FileSystem;", "fallbackJar", "(Ljava/nio/file/FileSystem;Ljava/nio/file/FileSystem;)V", "classNodeMap", "Ljava/util/HashMap;", "", "Lpaper/libs/org/objectweb/asm/tree/ClassNode;", "Lkotlin/collections/HashMap;", "findClass", "name", "findClassData", "", "className", "normalize", "paperweight-lib"})
public final class ClassNodeCache {
    private final HashMap<String, ClassNode> classNodeMap;
    private final FileSystem jarFile;
    private final FileSystem fallbackJar;

    @Nullable
    public final ClassNode findClass(@Nullable String name2) {
        if (name2 == null) {
            return null;
        }
        return this.classNodeMap.computeIfAbsent(this.normalize(name2), new Function(this){
            final /* synthetic */ ClassNodeCache this$0;

            @Nullable
            public final ClassNode apply(@NotNull String fileName) {
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                byte[] byArray2 = ClassNodeCache.access$findClassData(this.this$0, fileName);
                if (byArray2 == null) {
                    return null;
                }
                byte[] classData = byArray2;
                ClassReader classReader = new ClassReader(classData);
                ClassNode node = new ClassNode(589824);
                classReader.accept(node, 0);
                return node;
            }
            {
                this.this$0 = classNodeCache;
            }
        });
    }

    private final byte[] findClassData(String className) {
        Object object = this.jarFile.getPath(className, new String[0]);
        boolean bl = false;
        boolean bl2 = false;
        Path remappedClass = object;
        boolean bl3 = false;
        Path path = remappedClass;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"remappedClass");
        Object object2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl4 = false;
        if (Files.exists((Path)object2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            object2 = remappedClass;
            boolean bl5 = false;
            byte[] byArray2 = Files.readAllBytes((Path)object2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"Files.readAllBytes(this)");
            return byArray2;
        }
        Object object3 = this.fallbackJar;
        if (object3 != null && (object3 = ((FileSystem)object3).getPath(className, new String[0])) != null) {
            object = object3;
            bl = false;
            bl2 = false;
            Object libraryClass = object;
            boolean bl6 = false;
            object2 = libraryClass;
            linkOptionArray = new LinkOption[]{};
            bl4 = false;
            if (Files.exists((Path)object2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                object2 = libraryClass;
                boolean bl7 = false;
                byte[] byArray3 = Files.readAllBytes((Path)object2);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"Files.readAllBytes(this)");
                return byArray3;
            }
        }
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(className);
        return (byte[])(inputStream != null ? ByteStreamsKt.readBytes((InputStream)inputStream) : null);
    }

    private final String normalize(String name2) {
        String workingName = StringsKt.removeSuffix((String)name2, (CharSequence)".class");
        int startIndex = 0;
        int endIndex = workingName.length();
        if (StringsKt.startsWith$default((CharSequence)workingName, (char)'L', (boolean)false, (int)2, null)) {
            startIndex = 1;
        }
        if (StringsKt.endsWith$default((CharSequence)workingName, (char)';', (boolean)false, (int)2, null)) {
            --endIndex;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = workingName;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(startIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return stringBuilder.append(StringsKt.replace$default((String)string3, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".class").toString();
    }

    public ClassNodeCache(@NotNull FileSystem jarFile, @Nullable FileSystem fallbackJar) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        this.jarFile = jarFile;
        this.fallbackJar = fallbackJar;
        boolean bl = false;
        this.classNodeMap = new HashMap();
    }

    public /* synthetic */ ClassNodeCache(FileSystem fileSystem, FileSystem fileSystem2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            fileSystem2 = null;
        }
        this(fileSystem, fileSystem2);
    }

    public static final /* synthetic */ byte[] access$findClassData(ClassNodeCache $this, String className) {
        return $this.findClassData(className);
    }
}

