/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup.step;

import io.papermc.paperweight.DownloadService;
import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.userdev.internal.setup.step.VanillaSteps;
import io.papermc.paperweight.userdev.internal.setup.util.DownloadResult;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.constants.ConstantsKt;
import io.papermc.paperweight.util.data.ManifestVersion;
import io.papermc.paperweight.util.data.MinecraftManifest;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.gradle.kotlin.dsl.NamedDomainObjectCollectionExtensionsKt;
import org.jetbrains.annotations.NotNull;
import paper.libs.com.github.salomonbrys.kotson.ElementKt;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.JsonElement;
import paper.libs.com.google.gson.JsonObject;
import paper.libs.com.google.gson.reflect.TypeToken;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\tH\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017J\b\u0010\u001d\u001a\u00020\fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/step/VanillaSteps;", "", "minecraftVersion", "", "cache", "Ljava/nio/file/Path;", "downloadService", "Lio/papermc/paperweight/DownloadService;", "bundleChanged", "", "(Ljava/lang/String;Ljava/nio/file/Path;Lio/papermc/paperweight/DownloadService;Z)V", "minecraftVersionManifest", "Lpaper/libs/com/google/gson/JsonObject;", "getMinecraftVersionManifest", "()Lcom/google/gson/JsonObject;", "minecraftVersionManifest$delegate", "Lkotlin/Lazy;", "mojangJar", "getMojangJar", "()Ljava/nio/file/Path;", "serverMappings", "getServerMappings", "downloadMinecraftManifest", "Lio/papermc/paperweight/userdev/internal/setup/util/DownloadResult;", "Lio/papermc/paperweight/util/data/MinecraftManifest;", "force", "downloadServerMappings", "", "downloadVanillaServerJar", "setupMinecraftVersionManifest", "paperweight-userdev"})
public final class VanillaSteps {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Lazy minecraftVersionManifest$delegate;
    @NotNull
    private final Path mojangJar;
    @NotNull
    private final Path serverMappings;
    private final String minecraftVersion;
    private final Path cache;
    private final DownloadService downloadService;
    private final boolean bundleChanged;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(VanillaSteps.class, "minecraftVersionManifest", "getMinecraftVersionManifest()Lcom/google/gson/JsonObject;", 0))};
    }

    @NotNull
    public final JsonObject getMinecraftVersionManifest() {
        Lazy lazy = this.minecraftVersionManifest$delegate;
        VanillaSteps vanillaSteps2 = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (JsonObject)lazy.getValue();
    }

    @NotNull
    public final Path getMojangJar() {
        return this.mojangJar;
    }

    @NotNull
    public final Path getServerMappings() {
        return this.serverMappings;
    }

    @NotNull
    public final DownloadResult<Unit> downloadVanillaServerJar() {
        JsonElement jsonElement = this.getMinecraftVersionManifest().get("downloads");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"minecraftVersionManifest[\"downloads\"]");
        return io.papermc.paperweight.userdev.internal.setup.util.UtilsKt.download$default(this.downloadService, "vanilla minecraft server jar", ElementKt.getString(ElementKt.get(ElementKt.get(jsonElement, "server"), "url")), this.mojangJar, false, 8, null);
    }

    @NotNull
    public final DownloadResult<Unit> downloadServerMappings() {
        JsonElement jsonElement = this.getMinecraftVersionManifest().get("downloads");
        Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"minecraftVersionManifest[\"downloads\"]");
        return io.papermc.paperweight.userdev.internal.setup.util.UtilsKt.download$default(this.downloadService, "mojang server mappings", ElementKt.getString(ElementKt.get(ElementKt.get(jsonElement, "server_mappings"), "url")), this.serverMappings, false, 8, null);
    }

    private final DownloadResult<MinecraftManifest> downloadMinecraftManifest(boolean force) {
        Path path = this.cache.resolve("paperweight/data/McManifest.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cache.resolve(MC_MANIFEST)");
        return io.papermc.paperweight.userdev.internal.setup.util.UtilsKt.download(this.downloadService, "minecraft manifest", "https://launchermeta.mojang.com/mc/game/version_manifest.json", path, force).mapData(downloadMinecraftManifest.1.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final JsonObject setupMinecraftVersionManifest() {
        Object t;
        void $this$fromJson$iv;
        Object object;
        Object var22_21;
        Gson $this$firstOrNull$iv;
        DownloadService downloadService;
        String string;
        block19: {
            Object v1;
            Iterator element$iv2;
            DownloadResult<MinecraftManifest> minecraftManifest = this.downloadMinecraftManifest(this.bundleChanged);
            if (!minecraftManifest.getDidDownload()) {
                boolean bl;
                block18: {
                    Iterable $this$none$iv = minecraftManifest.getData().getVersions();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Iterator element$iv2 : $this$none$iv) {
                            ManifestVersion it = (ManifestVersion)((Object)element$iv2);
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.minecraftVersion)) continue;
                            bl = false;
                            break block18;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    minecraftManifest = this.downloadMinecraftManifest(true);
                }
            }
            Iterable $i$f$none = minecraftManifest.getData().getVersions();
            string = "minecraft version manifest";
            downloadService = this.downloadService;
            boolean $i$f$firstOrNull = false;
            element$iv2 = $this$firstOrNull$iv.iterator();
            while (element$iv2.hasNext()) {
                Object element$iv3 = element$iv2.next();
                ManifestVersion it = (ManifestVersion)element$iv3;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.minecraftVersion)) continue;
                v1 = element$iv3;
                break block19;
            }
            v1 = var22_21 = null;
        }
        if ((object = (ManifestVersion)var22_21) == null || (object = ((ManifestVersion)object).getUrl()) == null) {
            throw (Throwable)new PaperweightException("Could not find Minecraft version '" + this.minecraftVersion + "' in the downloaded manifest.");
        }
        Path path = this.cache.resolve("paperweight/data/McVersion.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cache.resolve(VERSION_JSON)");
        DownloadResult minecraftVersionManifestJson = io.papermc.paperweight.userdev.internal.setup.util.UtilsKt.download$default(downloadService, string, (String)object, path, false, 8, null);
        $this$firstOrNull$iv = UtilsKt.getGson();
        Path any$iv = minecraftVersionManifestJson.getPath();
        boolean $i$f$fromJson = false;
        Path path2 = any$iv;
        if (path2 instanceof String) {
            Type type;
            void $receiver$iv$iv = $this$fromJson$iv;
            String string2 = (String)((Object)any$iv);
            void var9_22 = $receiver$iv$iv;
            Type type2 = new TypeToken<JsonObject>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
            Type type$iv$iv$iv = type2;
            if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                Type type3 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                type = type3;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
            } else {
                type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv);
            }
            Type type4 = type;
            Object t2 = var9_22.fromJson(string2, type4);
            t = t2;
            Intrinsics.checkExpressionValueIsNotNull(t2, (String)"fromJson(json, typeToken<T>())");
        } else {
            Object object2 = UtilsKt.convertToPath(any$iv);
            Charset charset = Charsets.UTF_8;
            OpenOption[] type$iv$iv$iv = new OpenOption[]{};
            int n = 8192;
            boolean bl = false;
            object2 = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object2, Arrays.copyOf(type$iv$iv$iv, type$iv$iv$iv.length)), charset), n);
            boolean bl3 = false;
            n = 0;
            Throwable throwable = null;
            try {
                Type type;
                BufferedReader it$iv = (BufferedReader)object2;
                boolean bl4 = false;
                void $receiver$iv$iv = $this$fromJson$iv;
                Reader reader = it$iv;
                void var14_33 = $receiver$iv$iv;
                Type type5 = new TypeToken<JsonObject>(){}.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"object : TypeToken<T>() {} .type");
                Type type$iv$iv$iv2 = type5;
                if (type$iv$iv$iv2 instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv2)) {
                    Type type6 = ((ParameterizedType)type$iv$iv$iv2).getRawType();
                    type = type6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"type.rawType");
                } else {
                    type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv2);
                }
                Type type7 = type;
                Object t3 = var14_33.fromJson(reader, type7);
                Intrinsics.checkExpressionValueIsNotNull(t3, (String)"fromJson(json, typeToken<T>())");
                Object t4 = t3;
                t = t4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
            }
        }
        return (JsonObject)t;
    }

    public VanillaSteps(@NotNull String minecraftVersion2, @NotNull Path cache, @NotNull DownloadService downloadService, boolean bundleChanged) {
        Intrinsics.checkNotNullParameter((Object)minecraftVersion2, (String)"minecraftVersion");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)downloadService, (String)"downloadService");
        this.minecraftVersion = minecraftVersion2;
        this.cache = cache;
        this.downloadService = downloadService;
        this.bundleChanged = bundleChanged;
        this.minecraftVersionManifest$delegate = (Lazy)NamedDomainObjectCollectionExtensionsKt.provideDelegate((Object)LazyKt.lazy((Function0)((Function0)new Function0<JsonObject>(this){
            final /* synthetic */ VanillaSteps this$0;

            @NotNull
            public final JsonObject invoke() {
                return VanillaSteps.access$setupMinecraftVersionManifest(this.this$0);
            }
            {
                this.this$0 = vanillaSteps2;
                super(0);
            }
        })), (Object)this, (KProperty)$$delegatedProperties[0]);
        Path path = this.cache.resolve(ConstantsKt.paperSetupOutput("downloadServerJar", "jar"));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cache.resolve(paperSetup\u2026wnloadServerJar\", \"jar\"))");
        this.mojangJar = path;
        Path path2 = this.cache.resolve("paperweight/mappings/server_mappings.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"cache.resolve(SERVER_MAPPINGS)");
        this.serverMappings = path2;
    }

    public static final /* synthetic */ JsonObject access$setupMinecraftVersionManifest(VanillaSteps $this) {
        return $this.setupMinecraftVersionManifest();
    }
}

