/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.userdev.internal.setup.step;

import io.papermc.paperweight.extension.Relocation;
import io.papermc.paperweight.extension.RelocationWrapper;
import io.papermc.paperweight.userdev.internal.setup.SetupHandler;
import io.papermc.paperweight.userdev.internal.setup.step.Input;
import io.papermc.paperweight.userdev.internal.setup.step.Output;
import io.papermc.paperweight.userdev.internal.setup.step.SetupStep;
import io.papermc.paperweight.userdev.internal.setup.util.HashFunctionBuilder;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.Filter_jarKt;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0002J.\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00032\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0005\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u000e\u00a8\u0006#"}, d2={"Lio/papermc/paperweight/userdev/internal/setup/step/FilterPaperShadowJar;", "Lio/papermc/paperweight/userdev/internal/setup/step/SetupStep;", "sourcesJar", "Ljava/nio/file/Path;", "inputJar", "outputJar", "relocations", "", "Lio/papermc/paperweight/extension/Relocation;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/util/List;)V", "hashFile", "getHashFile", "()Ljava/nio/file/Path;", "getInputJar$annotations", "()V", "name", "", "getName", "()Ljava/lang/String;", "getOutputJar$annotations", "getSourcesJar$annotations", "collectIncludes", "", "filterPaperJar", "", "iterateJar", "jar", "visitor", "Lkotlin/Function1;", "run", "context", "Lio/papermc/paperweight/userdev/internal/setup/SetupHandler$Context;", "touchHashFunctionBuilder", "builder", "Lio/papermc/paperweight/userdev/internal/setup/util/HashFunctionBuilder;", "paperweight-userdev"})
public final class FilterPaperShadowJar
implements SetupStep {
    @NotNull
    private final String name;
    @NotNull
    private final Path hashFile;
    private final Path sourcesJar;
    private final Path inputJar;
    private final Path outputJar;
    private final List<Relocation> relocations;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Path getHashFile() {
        return this.hashFile;
    }

    @Override
    public void run(@NotNull SetupHandler.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.filterPaperJar(this.sourcesJar, this.inputJar, this.outputJar, this.relocations);
    }

    @Override
    public void touchHashFunctionBuilder(@NotNull HashFunctionBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        String string = UtilsKt.getGson().toJson(this.relocations);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(relocations)");
        builder.include((Object)string);
    }

    /*
     * WARNING - void declaration
     */
    private final void filterPaperJar(Path sourcesJar, Path inputJar, Path outputJar, List<Relocation> relocations) {
        void $this$mapTo$iv$iv;
        boolean bl = false;
        ArrayList includes = new ArrayList();
        Iterable $this$map$iv = relocations;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Relocation relocation = (Relocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            RelocationWrapper relocationWrapper = new RelocationWrapper((Relocation)it, null, null, null, null, 30, null);
            collection.add(relocationWrapper);
        }
        for (RelocationWrapper relocation : (List)destination$iv$iv) {
            $this$map$iv = includes;
            char c = '/';
            object = relocation.getToSlash();
            boolean bl3 = false;
            String string = String.valueOf(c) + (String)object + "/**";
            boolean bl4 = false;
            $this$map$iv.add(string);
            for (String exclude : relocation.getRelocation().getExcludes()) {
                Collection collection = includes;
                char c2 = '/';
                String string2 = StringsKt.replace$default((String)exclude, (char)'.', (char)'/', (boolean)false, (int)4, null);
                boolean bl5 = false;
                String string3 = String.valueOf(c2) + string2;
                boolean bl6 = false;
                collection.add(string3);
            }
        }
        Set<String> includedFiles = this.collectIncludes(sourcesJar, inputJar);
        Filter_jarKt.filterJar(inputJar, outputJar, includes, (Function1<? super Path, Boolean>)((Function1)new Function1<Path, Boolean>(includedFiles){
            final /* synthetic */ Set $includedFiles;

            public final boolean invoke(@NotNull Path path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Path path2 = path;
                boolean bl = false;
                String str = ((Object)path2).toString();
                return StringsKt.contains$default((CharSequence)str, (char)'$', (boolean)false, (int)2, null) ? this.$includedFiles.contains((String)StringsKt.split$default((CharSequence)str, (String[])new String[]{"$"}, (boolean)false, (int)0, (int)6, null).get(0) + ".class") : this.$includedFiles.contains(str);
            }
            {
                this.$includedFiles = set;
                super(1);
            }
        }));
    }

    private final Set<String> collectIncludes(Path sourcesJar, Path inputJar) {
        boolean bl = false;
        HashSet extraIncludes = new HashSet();
        this.iterateJar(sourcesJar, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(extraIncludes){
            final /* synthetic */ HashSet $extraIncludes;

            public final void invoke(@NotNull Path entry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                Path path = entry;
                Object object = new LinkOption[]{};
                boolean bl = false;
                if (Files.isRegularFile(path, Arrays.copyOf(object, ((LinkOption[])object).length))) {
                    object = entry;
                    bl = false;
                    String string = object.toString();
                    object = this.$extraIncludes;
                    String string2 = StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null) ? StringsKt.substringBeforeLast$default((String)string, (String)".java", null, (int)2, null) + ".class" : string;
                    boolean bl2 = false;
                    object.add(string2);
                }
            }
            {
                this.$extraIncludes = hashSet;
                super(1);
            }
        }));
        this.iterateJar(inputJar, (Function1<? super Path, Unit>)((Function1)new Function1<Path, Unit>(extraIncludes){
            final /* synthetic */ HashSet $extraIncludes;

            public final void invoke(@NotNull Path entry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                Iterable<Path> iterable = entry;
                Object object = new LinkOption[]{};
                boolean bl = false;
                if (Files.isRegularFile((Path)iterable, Arrays.copyOf(object, ((LinkOption[])object).length)) && !StringsKt.endsWith$default((String)PathsKt.getName((Path)entry), (String)".class", (boolean)false, (int)2, null)) {
                    iterable = this.$extraIncludes;
                    object = entry;
                    bl = false;
                    object = object.toString();
                    bl = false;
                    iterable.add(object);
                }
            }
            {
                this.$extraIncludes = hashSet;
                super(1);
            }
        }));
        return extraIncludes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void iterateJar(Path jar2, Function1<? super Path, Unit> visitor) {
        Closeable closeable = FileKt.openZip(jar2);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileSystem fs = (FileSystem)closeable;
            boolean bl3 = false;
            AutoCloseable autoCloseable = FileKt.walk(fs);
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                Stream stream = (Stream)autoCloseable;
                boolean bl6 = false;
                stream.forEach(new Consumer(visitor){
                    final /* synthetic */ Function1 $visitor$inlined;
                    {
                        this.$visitor$inlined = function1;
                    }

                    public final void accept(Path path) {
                        Path path2 = path;
                        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                        this.$visitor$inlined.invoke((Object)path2);
                    }
                });
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Input
    private static /* synthetic */ void getSourcesJar$annotations() {
    }

    @Input
    private static /* synthetic */ void getInputJar$annotations() {
    }

    @Output
    private static /* synthetic */ void getOutputJar$annotations() {
    }

    public FilterPaperShadowJar(@NotNull Path sourcesJar, @NotNull Path inputJar, @NotNull Path outputJar, @NotNull List<Relocation> relocations) {
        Intrinsics.checkNotNullParameter((Object)sourcesJar, (String)"sourcesJar");
        Intrinsics.checkNotNullParameter((Object)inputJar, (String)"inputJar");
        Intrinsics.checkNotNullParameter((Object)outputJar, (String)"outputJar");
        Intrinsics.checkNotNullParameter(relocations, (String)"relocations");
        this.sourcesJar = sourcesJar;
        this.inputJar = inputJar;
        this.outputJar = outputJar;
        this.relocations = relocations;
        this.name = "filter mojang mapped paper jar";
        this.hashFile = io.papermc.paperweight.userdev.internal.setup.util.UtilsKt.siblingHashesFile(this.outputJar);
    }
}

