/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.BaseTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.MappingFormats;
import io.papermc.paperweight.util.UtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import paper.libs.org.cadixdev.at.AccessChange;
import paper.libs.org.cadixdev.at.AccessTransform;
import paper.libs.org.cadixdev.at.AccessTransformSet;
import paper.libs.org.cadixdev.at.ModifierChange;
import paper.libs.org.cadixdev.at.io.AccessTransformFormats;
import paper.libs.org.cadixdev.bombe.type.MethodDescriptor;
import paper.libs.org.cadixdev.bombe.type.signature.MethodSignature;
import paper.libs.org.cadixdev.lorenz.MappingSet;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u000eH\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lio/papermc/paperweight/tasks/RemapSpigotAt;", "Lio/papermc/paperweight/tasks/BaseTask;", "()V", "inputJar", "Lorg/gradle/api/file/RegularFileProperty;", "getInputJar", "()Lorg/gradle/api/file/RegularFileProperty;", "mapping", "getMapping", "outputFile", "getOutputFile", "spigotAt", "getSpigotAt", "init", "", "parseAccess", "Lpaper/libs/org/cadixdev/at/AccessTransform;", "text", "", "parseAccessChange", "Lpaper/libs/org/cadixdev/at/AccessChange;", "parseModifierChange", "Lpaper/libs/org/cadixdev/at/ModifierChange;", "c", "", "run", "paperweight-lib"})
public abstract class RemapSpigotAt
extends BaseTask {
    @Classpath
    @NotNull
    public abstract RegularFileProperty getInputJar();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getSpigotAt();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getMapping();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Override
    public void init() {
        this.getOutputFile().convention((Provider)UtilsKt.defaultOutput(this, "at"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void run() {
        AccessTransformSet outputAt = AccessTransformSet.create();
        Path path = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getSpigotAt()));
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Closeable closeable = Files.newBufferedReader(path, charset);
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            BufferedReader bufferedReader = (BufferedReader)closeable;
            boolean bl4 = false;
            BufferedReader bufferedReader2 = bufferedReader;
            Intrinsics.checkNotNullExpressionValue((Object)bufferedReader2, (String)"it");
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)bufferedReader2);
            boolean bl5 = false;
            Closeable closeable2 = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getInputJar())));
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable2 = null;
            try {
                FileSystem jarFile = (FileSystem)closeable2;
                boolean bl8 = false;
                for (String line : lines) {
                    Path index2;
                    void access;
                    Object methodDesc;
                    List list;
                    if (StringsKt.isBlank((CharSequence)line) || StringsKt.startsWith$default((CharSequence)line, (char)'#', (boolean)false, (int)2, null)) continue;
                    List list2 = list = StringsKt.split$default((CharSequence)line, (char[])new char[]{' '}, (boolean)false, (int)0, (int)6, null);
                    boolean bl9 = false;
                    String string = (String)list2.get(0);
                    list2 = list;
                    bl9 = false;
                    String desc = (String)list2.get(1);
                    if (StringsKt.contains$default((CharSequence)desc, (char)'(', (boolean)false, (int)2, null)) {
                        String methodName;
                        String className;
                        String classAndMethodName2;
                        int index2 = StringsKt.indexOf$default((CharSequence)desc, (char)'(', (int)0, (boolean)false, (int)6, null);
                        String string2 = desc;
                        boolean bl10 = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string3.substring(index2), (String)"(this as java.lang.String).substring(startIndex)");
                        String string4 = desc;
                        int n = 0;
                        boolean bl11 = false;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string5.substring(n, index2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        int slashIndex = StringsKt.lastIndexOf$default((CharSequence)classAndMethodName2, (char)'/', (int)0, (boolean)false, (int)6, null);
                        String string6 = classAndMethodName2;
                        int n2 = 0;
                        int n3 = 0;
                        String string7 = string6;
                        if (string7 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string7.substring(n2, slashIndex), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string8 = classAndMethodName2;
                        n3 = slashIndex + 1;
                        boolean bl12 = false;
                        String string9 = string8;
                        if (string9 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string9.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
                        outputAt.getOrCreateClass(className).replaceMethod(new MethodSignature(methodName, MethodDescriptor.of((String)methodDesc)), this.parseAccess((String)access));
                        continue;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)jarFile.getPath(desc + ".class", new String[0]), (String)"jarFile.getPath(\"$desc.class\")");
                    methodDesc = new LinkOption[]{};
                    boolean classAndMethodName2 = false;
                    if (Files.notExists(index2, Arrays.copyOf(methodDesc, ((LinkOption[])methodDesc).length))) {
                        String fieldName;
                        String className;
                        int index3 = StringsKt.lastIndexOf$default((CharSequence)desc, (char)'/', (int)0, (boolean)false, (int)6, null);
                        String classAndMethodName2 = desc;
                        int n = 0;
                        int n4 = 0;
                        String string10 = classAndMethodName2;
                        if (string10 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string10.substring(n, index3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string11 = desc;
                        n4 = index3 + 1;
                        boolean bl13 = false;
                        String string12 = string11;
                        if (string12 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string12.substring(n4), (String)"(this as java.lang.String).substring(startIndex)");
                        outputAt.getOrCreateClass(className).replaceField(fieldName, this.parseAccess((String)access));
                        continue;
                    }
                    outputAt.getOrCreateClass(desc).replace(this.parseAccess((String)access));
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            bufferedReader = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        MappingSet mappings = MappingFormats.INSTANCE.getTINY().read(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getMapping())), "spigot", "mojang+yarn");
        AccessTransformSet remappedAt = outputAt.remap(mappings);
        AccessTransformFormats.FML.write(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputFile())), remappedAt);
    }

    private final AccessTransform parseAccess(String text) {
        AccessTransform accessTransform;
        int index = StringsKt.indexOfAny$default((CharSequence)text, (char[])new char[]{'+', '-'}, (int)0, (boolean)false, (int)6, null);
        if (index == -1) {
            AccessTransform accessTransform2 = AccessTransform.of(this.parseAccessChange(text));
            accessTransform = accessTransform2;
            Intrinsics.checkNotNullExpressionValue((Object)accessTransform2, (String)"AccessTransform.of(parseAccessChange(text))");
        } else {
            String string = text;
            int n = 0;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, index);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            AccessChange accessChange = this.parseAccessChange(string3);
            ModifierChange modifierChange = this.parseModifierChange(text.charAt(index));
            AccessTransform accessTransform3 = AccessTransform.of(accessChange, modifierChange);
            accessTransform = accessTransform3;
            Intrinsics.checkNotNullExpressionValue((Object)accessTransform3, (String)"AccessTransform.of(accessChange, modifierChange)");
        }
        return accessTransform;
    }

    private final AccessChange parseAccessChange(String text) {
        AccessChange accessChange;
        switch (text) {
            case "public": {
                accessChange = AccessChange.PUBLIC;
                break;
            }
            case "private": {
                accessChange = AccessChange.PRIVATE;
                break;
            }
            case "protected": {
                accessChange = AccessChange.PROTECTED;
                break;
            }
            case "default": {
                accessChange = AccessChange.PACKAGE_PRIVATE;
                break;
            }
            default: {
                accessChange = AccessChange.NONE;
            }
        }
        return accessChange;
    }

    private final ModifierChange parseModifierChange(char c) {
        ModifierChange modifierChange;
        switch (c) {
            case '+': {
                modifierChange = ModifierChange.ADD;
                break;
            }
            case '-': {
                modifierChange = ModifierChange.REMOVE;
                break;
            }
            default: {
                modifierChange = ModifierChange.NONE;
            }
        }
        return modifierChange;
    }
}

