/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.tasks.GenerateMappingsKt;
import io.papermc.paperweight.tasks.JavaLauncherTask;
import io.papermc.paperweight.tasks.ParamsMergeHandler;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.MappingFormats;
import io.papermc.paperweight.util.UtilsKt;
import java.io.Closeable;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import paper.libs.dev.denwav.hypo.asm.AsmClassDataProvider;
import paper.libs.dev.denwav.hypo.asm.hydrate.BridgeMethodHydrator;
import paper.libs.dev.denwav.hypo.asm.hydrate.SuperConstructorHydrator;
import paper.libs.dev.denwav.hypo.core.HypoContext;
import paper.libs.dev.denwav.hypo.hydrate.HydrationManager;
import paper.libs.dev.denwav.hypo.mappings.ChangeChain;
import paper.libs.dev.denwav.hypo.mappings.MappingsCompletionManager;
import paper.libs.dev.denwav.hypo.mappings.contributors.ChangeContributor;
import paper.libs.dev.denwav.hypo.mappings.contributors.CopyMappingsDown;
import paper.libs.dev.denwav.hypo.mappings.contributors.PropagateMappingsUp;
import paper.libs.dev.denwav.hypo.mappings.contributors.RemoveUnusedMappings;
import paper.libs.dev.denwav.hypo.model.ClassProviderRoot;
import paper.libs.org.cadixdev.lorenz.MappingSet;
import paper.libs.org.cadixdev.lorenz.io.MappingsReader;
import paper.libs.org.cadixdev.lorenz.merge.FieldMergeStrategy;
import paper.libs.org.cadixdev.lorenz.merge.MappingSetMerger;
import paper.libs.org.cadixdev.lorenz.merge.MergeConfig;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0014\u0010\u0016\u001a\u00020\u00178gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lio/papermc/paperweight/tasks/GenerateMappings;", "Lio/papermc/paperweight/tasks/JavaLauncherTask;", "()V", "jvmargs", "Lorg/gradle/api/provider/ListProperty;", "", "getJvmargs", "()Lorg/gradle/api/provider/ListProperty;", "libraries", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getLibraries", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputMappings", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputMappings", "()Lorg/gradle/api/file/RegularFileProperty;", "paramMappings", "getParamMappings", "vanillaJar", "getVanillaJar", "vanillaMappings", "getVanillaMappings", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "init", "", "run", "GenerateMappingsAction", "GenerateMappingsParams", "paperweight-lib"})
public abstract class GenerateMappings
extends JavaLauncherTask {
    @Classpath
    @NotNull
    public abstract RegularFileProperty getVanillaJar();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getLibraries();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getVanillaMappings();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public abstract RegularFileProperty getParamMappings();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputMappings();

    @Internal
    @NotNull
    public abstract ListProperty<String> getJvmargs();

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @Override
    public void init() {
        super.init();
        this.getJvmargs().convention((Iterable)CollectionsKt.listOf((Object)"-Xmx1G"));
    }

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void run() {
        Collection<Path> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Path path = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getVanillaJar()));
        Set set = this.getLibraries().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"libraries.files");
        Iterable iterable = set;
        Path path2 = path;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Path path3 = it.toPath();
            collection.add(path3);
        }
        collection = (List)destination$iv$iv;
        Path path4 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getVanillaMappings()));
        Path path5 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getParamMappings()));
        Path path6 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOutputMappings()));
        WorkerExecutor workerExecutor = this.getWorkerExecutor();
        Object object = this.getLauncher().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"launcher.get()");
        JavaLauncher javaLauncher = (JavaLauncher)object;
        Object object2 = this.getJvmargs().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"jvmargs.get()");
        GenerateMappingsKt.generateMappings(path2, (List<? extends Path>)collection, path4, path5, path6, workerExecutor, javaLauncher, (List)object2);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0012\u0010\u000e\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/tasks/GenerateMappings$GenerateMappingsParams;", "Lorg/gradle/workers/WorkParameters;", "libraries", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getLibraries", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputMappings", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputMappings", "()Lorg/gradle/api/file/RegularFileProperty;", "paramMappings", "getParamMappings", "vanillaJar", "getVanillaJar", "vanillaMappings", "getVanillaMappings", "paperweight-lib"})
    public static interface GenerateMappingsParams
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getVanillaJar();

        @NotNull
        public ConfigurableFileCollection getLibraries();

        @NotNull
        public RegularFileProperty getVanillaMappings();

        @NotNull
        public RegularFileProperty getParamMappings();

        @NotNull
        public RegularFileProperty getOutputMappings();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lio/papermc/paperweight/tasks/GenerateMappings$GenerateMappingsAction;", "Lorg/gradle/workers/WorkAction;", "Lio/papermc/paperweight/tasks/GenerateMappings$GenerateMappingsParams;", "()V", "execute", "", "paperweight-lib"})
    public static abstract class GenerateMappingsAction
    implements WorkAction<GenerateMappingsParams> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            MappingSet mappingSet;
            MappingSet mappingSet2;
            MappingSet mappingSet3;
            Closeable closeable = MappingFormats.INSTANCE.getPROGUARD().createReader(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((GenerateMappingsParams)this.getParameters()).getVanillaMappings())));
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                MappingsReader it = (MappingsReader)closeable;
                boolean bl3 = false;
                mappingSet3 = it.read();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            MappingSet vanillaMappings = mappingSet3.reverse();
            Closeable closeable2 = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((GenerateMappingsParams)this.getParameters()).getParamMappings())));
            boolean bl4 = false;
            boolean bl5 = false;
            Object object = null;
            try {
                FileSystem fs = (FileSystem)closeable2;
                boolean bl6 = false;
                Path path = fs.getPath("mappings", "mappings.tiny");
                mappingSet2 = MappingFormats.INSTANCE.getTINY().read(path, "official", "named");
            }
            catch (Throwable throwable3) {
                object = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
            }
            MappingSet paramMappings2 = mappingSet2;
            MappingSet merged = MappingSetMerger.create(vanillaMappings, paramMappings2, MergeConfig.builder().withFieldMergeStrategy(FieldMergeStrategy.STRICT).withMergeHandler(new ParamsMergeHandler()).build()).merge();
            object = HypoContext.builder().withProvider(AsmClassDataProvider.of(ClassProviderRoot.fromJar(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((GenerateMappingsParams)this.getParameters()).getVanillaJar()))))).withContextProvider(AsmClassDataProvider.of(UtilsKt.toJarClassProviderRoots((FileCollection)((GenerateMappingsParams)this.getParameters()).getLibraries()))).withContextProvider(AsmClassDataProvider.of(ClassProviderRoot.ofJdk())).build();
            boolean bl7 = false;
            boolean bl8 = false;
            Throwable throwable4 = null;
            try {
                HypoContext hypoContext = (HypoContext)object;
                boolean bl9 = false;
                HydrationManager.createDefault().register(BridgeMethodHydrator.create()).register(SuperConstructorHydrator.create()).hydrate(hypoContext);
                MappingSet mappingSet4 = ChangeChain.create().addLink((ChangeContributor)RemoveUnusedMappings.create()).addLink((ChangeContributor)PropagateMappingsUp.create()).addLink((ChangeContributor)CopyMappingsDown.create()).applyChain(merged, MappingsCompletionManager.create(hypoContext));
                mappingSet = mappingSet4;
            }
            catch (Throwable throwable5) {
                throwable4 = throwable5;
                throw throwable5;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable4);
            }
            Intrinsics.checkNotNullExpressionValue((Object)mappingSet, (String)"HypoContext.builder()\n  \u2026ntext))\n                }");
            MappingSet filledMerged = mappingSet;
            UtilsKt.ensureParentExists(((GenerateMappingsParams)this.getParameters()).getOutputMappings());
            MappingFormats.INSTANCE.getTINY().write(filledMerged, FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((GenerateMappingsParams)this.getParameters()).getOutputMappings())), "official", "mojang+yarn");
        }
    }
}

