/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.extension.Relocation;
import io.papermc.paperweight.extension.RelocationWrapper;
import io.papermc.paperweight.tasks.GenerateDevBundle;
import io.papermc.paperweight.tasks.RunForgeFlowerKt;
import io.papermc.paperweight.tasks.TinyRemapper;
import io.papermc.paperweight.util.DependenciesKt;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.MavenDep;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.constants.ConstantsKt;
import io.papermc.paperweight.util.data.ModuleId;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.reflect.TypeToken;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 k2\u00020\u0001:\u0004jklmB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010D\u001a\b\u0012\u0004\u0012\u00020A0EH\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u0005H\u0002J\u0018\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u0005H\u0002J\b\u0010M\u001a\u00020NH\u0002J\b\u0010O\u001a\u00020PH\u0002J\u001c\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00050E2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050RH\u0002J \u0010S\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\u00052\u0006\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020VH\u0002J\u0018\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u0005H\u0002J\u0010\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020VH\u0002J\u001e\u0010`\u001a\u00020^2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020[0R2\u0006\u0010a\u001a\u00020VH\u0002J\u001e\u0010b\u001a\u00020^2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020c0R2\u0006\u0010a\u001a\u00020VH\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020[0RH\u0002J\u001e\u0010d\u001a\u00020^2\u0006\u0010e\u001a\u00020V2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020c0RH\u0002J\b\u0010f\u001a\u00020^H\u0007J\u001e\u0010g\u001a\u00020\u00052\u0006\u0010h\u001a\u00020V2\f\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00050RH\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0007R\u0014\u0010\u0013\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u0014\u0010\u0015\u001a\u00020\u00168gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0007R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0007R\u0014\u0010!\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000bR\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0007R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0007R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0007R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0007R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0007R\u0014\u0010-\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u000bR\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0007R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0007R\u001a\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0007R\u001a\u00106\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u0010\u0007R\u0014\u00108\u001a\u0002098gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u001cR\u001a\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u001cR\u0018\u0010@\u001a\u00020\u0005*\u00020A8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006n"}, d2={"Lio/papermc/paperweight/tasks/GenerateDevBundle;", "Lorg/gradle/api/DefaultTask;", "()V", "apiCoordinates", "Lorg/gradle/api/provider/Property;", "", "getApiCoordinates", "()Lorg/gradle/api/provider/Property;", "atFile", "Lorg/gradle/api/file/RegularFileProperty;", "getAtFile", "()Lorg/gradle/api/file/RegularFileProperty;", "decompiledJar", "getDecompiledJar", "decompilerConfig", "Lorg/gradle/api/artifacts/Configuration;", "getDecompilerConfig", "decompilerUrl", "getDecompilerUrl", "devBundleFile", "getDevBundleFile", "layout", "Lorg/gradle/api/file/ProjectLayout;", "getLayout", "()Lorg/gradle/api/file/ProjectLayout;", "libraryRepositories", "Lorg/gradle/api/provider/ListProperty;", "getLibraryRepositories", "()Lorg/gradle/api/provider/ListProperty;", "minecraftVersion", "getMinecraftVersion", "mojangApiCoordinates", "getMojangApiCoordinates", "mojangMappedPaperclipFile", "getMojangMappedPaperclipFile", "paramMappingsCoordinates", "getParamMappingsCoordinates", "paramMappingsUrl", "getParamMappingsUrl", "relocations", "getRelocations", "remapperConfig", "getRemapperConfig", "remapperUrl", "getRemapperUrl", "reobfMappingsFile", "getReobfMappingsFile", "runtimeConfiguration", "getRuntimeConfiguration", "serverCoordinates", "getServerCoordinates", "serverProject", "Lorg/gradle/api/Project;", "getServerProject", "serverVersion", "getServerVersion", "sourceDir", "Lorg/gradle/api/file/DirectoryProperty;", "getSourceDir", "()Lorg/gradle/api/file/DirectoryProperty;", "vanillaJarIncludes", "getVanillaJarIncludes", "vanillaServerLibraries", "getVanillaServerLibraries", "coordinates", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "getCoordinates", "(Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;)Ljava/lang/String;", "collectRuntimeDependencies", "", "createBuildDataConfig", "Lio/papermc/paperweight/tasks/GenerateDevBundle$BuildData;", "targetDir", "createBundleConfig", "Lio/papermc/paperweight/tasks/GenerateDevBundle$DevBundleConfig;", "dataTargetDir", "patchTargetDir", "createDecompileRunner", "Lio/papermc/paperweight/tasks/GenerateDevBundle$Runner;", "createRemapDep", "Lio/papermc/paperweight/util/MavenDep;", "determineLibraries", "", "diffFiles", "fileName", "original", "Ljava/nio/file/Path;", "patched", "excluded", "", "relocation", "Lio/papermc/paperweight/extension/Relocation;", "potential", "generatePatches", "", "output", "relocate", "workingDir", "relocateFiles", "Lio/papermc/paperweight/extension/RelocationWrapper;", "replaceRelocationsInFile", "path", "run", "runDiff", "dir", "args", "BuildData", "Companion", "DevBundleConfig", "Runner", "paperweight-lib"})
public abstract class GenerateDevBundle
extends DefaultTask {
    @NotNull
    public static final String atFileName = "transform.at";
    @NotNull
    public static final String reobfMappingsFileName = "mojang+yarn-spigot-reobf.tiny";
    @NotNull
    public static final String mojangMappedPaperclipFileName = "paperclip-mojang+yarn.jar";
    public static final int currentDataVersion = 3;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @InputFile
    @NotNull
    public abstract RegularFileProperty getDecompiledJar();

    @InputDirectory
    @NotNull
    public abstract DirectoryProperty getSourceDir();

    @Input
    @NotNull
    public abstract Property<String> getMinecraftVersion();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getMojangMappedPaperclipFile();

    @Input
    @NotNull
    public abstract Property<String> getServerVersion();

    @Input
    @NotNull
    public abstract Property<String> getServerCoordinates();

    @Input
    @NotNull
    public abstract Property<String> getApiCoordinates();

    @Input
    @NotNull
    public abstract Property<String> getMojangApiCoordinates();

    @Input
    @NotNull
    public abstract ListProperty<String> getVanillaJarIncludes();

    @Input
    @NotNull
    public abstract ListProperty<String> getVanillaServerLibraries();

    @Input
    @NotNull
    public abstract ListProperty<String> getLibraryRepositories();

    @Internal
    @NotNull
    public abstract Property<Project> getServerProject();

    @Classpath
    @NotNull
    public abstract Property<Configuration> getRuntimeConfiguration();

    @Input
    @NotNull
    public abstract Property<String> getRelocations();

    @Input
    @NotNull
    public abstract Property<String> getParamMappingsUrl();

    @Input
    @NotNull
    public abstract Property<String> getParamMappingsCoordinates();

    @Input
    @NotNull
    public abstract Property<String> getDecompilerUrl();

    @Classpath
    @NotNull
    public abstract Property<Configuration> getDecompilerConfig();

    @Input
    @NotNull
    public abstract Property<String> getRemapperUrl();

    @Classpath
    @NotNull
    public abstract Property<Configuration> getRemapperConfig();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getReobfMappingsFile();

    @InputFile
    @NotNull
    public abstract RegularFileProperty getAtFile();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getDevBundleFile();

    @Inject
    @NotNull
    public abstract ProjectLayout getLayout();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void run() {
        Path devBundle = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getDevBundleFile()));
        FileKt.deleteForcefully(devBundle);
        Path path = devBundle.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"devBundle.parent");
        Path path2 = path;
        Object object = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path2, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"Files.createDirectories(this, *attributes)");
        object = "devBundlePatches";
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl2 = false;
        Path path3 = Files.createTempDirectory((String)object, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Files.createTempDirectory(prefix, *attributes)");
        Path tempPatchDir = path3;
        try {
            this.generatePatches(tempPatchDir);
            String dataDir = "data";
            String patchesDir = "patches";
            DevBundleConfig config = this.createBundleConfig(dataDir, patchesDir);
            Closeable closeable = FileKt.writeZip(devBundle);
            boolean bl3 = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                Path patchesZip;
                Path dataZip;
                FileSystem zip = (FileSystem)closeable;
                boolean bl5 = false;
                Path path4 = zip.getPath("config.json", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"zip.getPath(\"config.json\")");
                Object object2 = path4;
                Charset charset = Charsets.UTF_8;
                Unit unit = new Unit[]{};
                int n = 8192;
                boolean bl6 = false;
                Unit unit2 = unit;
                object2 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object2, Arrays.copyOf(unit2, ((OpenOption[])unit2).length)), charset), n);
                boolean bl7 = false;
                n = 0;
                Object object3 = null;
                try {
                    BufferedWriter writer = (BufferedWriter)object2;
                    boolean bl8 = false;
                    UtilsKt.getGson().toJson((Object)config, (Appendable)writer);
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    object3 = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                }
                Path path5 = zip.getPath("data-version.txt", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"zip.getPath(\"data-version.txt\")");
                PathsKt.writeText$default((Path)path5, (CharSequence)String.valueOf(3), null, (OpenOption[])new OpenOption[0], (int)2, null);
                Path path6 = dataZip = zip.getPath(dataDir, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"dataZip");
                Path path7 = path6;
                object3 = new FileAttribute[]{};
                boolean bl9 = false;
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path7, Arrays.copyOf(object3, ((FileAttribute[])object3).length)), (String)"Files.createDirectories(this, *attributes)");
                path7 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getReobfMappingsFile()));
                Path path8 = dataZip.resolve(reobfMappingsFileName);
                Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"dataZip.resolve(reobfMappingsFileName)");
                object3 = path8;
                bl9 = false;
                bl6 = false;
                CopyOption[] copyOptionArray = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path7, (Path)object3, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
                path7 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getMojangMappedPaperclipFile()));
                Path path9 = dataZip.resolve(mojangMappedPaperclipFileName);
                Intrinsics.checkNotNullExpressionValue((Object)path9, (String)"dataZip.resolve(mojangMappedPaperclipFileName)");
                object3 = path9;
                bl9 = false;
                bl6 = false;
                copyOptionArray = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path7, (Path)object3, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
                path7 = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getAtFile()));
                Path path10 = dataZip.resolve(atFileName);
                Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"dataZip.resolve(atFileName)");
                object3 = path10;
                bl9 = false;
                bl6 = false;
                copyOptionArray = new CopyOption[]{};
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path7, (Path)object3, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
                Path path11 = patchesZip = zip.getPath(patchesDir, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path11, (String)"patchesZip");
                FileKt.copyRecursivelyTo(tempPatchDir, path11);
                Unit unit3 = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        finally {
            FileKt.deleteRecursively$default(tempPatchDir, null, 1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generatePatches(Path output) {
        Path workingDir;
        Path path = workingDir = UtilsKt.getCache(this.getLayout()).resolve(ConstantsKt.paperTaskOutput((Task)this, "tmpdir"));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"workingDir");
        Object object = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
        FileKt.copyRecursivelyTo(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getSourceDir())), workingDir);
        this.relocate(this.relocations(), workingDir);
        object = Files.walk(workingDir, new FileVisitOption[0]);
        boolean bl2 = false;
        bl = false;
        Throwable throwable = null;
        try {
            Stream stream = (Stream)object;
            boolean bl3 = false;
            Closeable closeable = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getDecompiledJar())));
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                FileSystem decompJar = (FileSystem)closeable;
                boolean bl6 = false;
                Iterable<Path> iterable = decompJar.getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"decompJar.rootDirectories");
                Path decompRoot = (Path)CollectionsKt.single(iterable);
                Iterator iterator = stream.iterator();
                while (iterator.hasNext()) {
                    Path path2;
                    Path path3;
                    Path file = (Path)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    boolean bl7 = false;
                    if (Files.isDirectory(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                    Path relativeFile = PathsKt.relativeTo((Path)file, (Path)workingDir);
                    String relativeFilePath = PathsKt.getInvariantSeparatorsPathString((Path)relativeFile);
                    Path decompFile = decompRoot.resolve(relativeFilePath);
                    Intrinsics.checkNotNullExpressionValue((Object)decompFile, (String)"decompFile");
                    Object object2 = new LinkOption[]{};
                    boolean bl8 = false;
                    if (Files.notExists(path2, Arrays.copyOf(object2, ((LinkOption[])object2).length))) {
                        Path outputFile;
                        Path path4 = outputFile = output.resolve(relativeFilePath);
                        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"outputFile");
                        Path path5 = path4.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"outputFile.parent");
                        object2 = path5;
                        Object object3 = new FileAttribute[]{};
                        boolean bl9 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object2, Arrays.copyOf(object3, ((FileAttribute[])object3).length)), (String)"Files.createDirectories(this, *attributes)");
                        object2 = file;
                        object3 = outputFile;
                        bl9 = false;
                        boolean bl10 = false;
                        CopyOption[] copyOptionArray = new CopyOption[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object2, (Path)object3, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
                        continue;
                    }
                    String diffText = this.diffFiles(relativeFilePath, decompFile, file);
                    String patchName = PathsKt.getName((Path)relativeFile) + ".patch";
                    Path outputFile = output.resolve(relativeFilePath).resolveSibling(patchName);
                    Object object4 = diffText;
                    boolean bl11 = false;
                    if (!(!StringsKt.isBlank((CharSequence)object4))) continue;
                    Path path6 = outputFile;
                    Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"outputFile");
                    Path path7 = path6.getParent();
                    Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"outputFile.parent");
                    object4 = path7;
                    FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
                    boolean bl12 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object4, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length)), (String)"Files.createDirectories(this, *attributes)");
                    PathsKt.writeText$default((Path)outputFile, (CharSequence)diffText, null, (OpenOption[])new OpenOption[0], (int)2, null);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        FileKt.deleteRecursively$default(workingDir, null, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void relocate(List<Relocation> relocations, Path workingDir) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = relocations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Relocation relocation = (Relocation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            RelocationWrapper relocationWrapper = new RelocationWrapper((Relocation)it, null, null, null, null, 30, null);
            collection.add(relocationWrapper);
        }
        List wrappedRelocations = (List)destination$iv$iv;
        AutoCloseable autoCloseable = Files.walk(workingDir, new FileVisitOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl3 = false;
            stream.filter(relocate.1.1.INSTANCE).forEach(new Consumer(this, wrappedRelocations){
                final /* synthetic */ GenerateDevBundle this$0;
                final /* synthetic */ List $wrappedRelocations$inlined;
                {
                    this.this$0 = generateDevBundle;
                    this.$wrappedRelocations$inlined = list;
                }

                public final void accept(Path path) {
                    Path path2 = path;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                    GenerateDevBundle.access$replaceRelocationsInFile(this.this$0, path2, this.$wrappedRelocations$inlined);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        this.relocateFiles(wrappedRelocations, workingDir);
    }

    private final void replaceRelocationsInFile(Path path, List<RelocationWrapper> relocations) {
        boolean bl;
        String string;
        char c;
        String content = PathsKt.readText((Path)path, (Charset)Charsets.UTF_8);
        for (RelocationWrapper relocation : relocations) {
            c = '.';
            string = String.valueOf(relocation.hashCode());
            bl = false;
            String string2 = StringsKt.replace$default((String)content, (String)relocation.getFromDot(), (String)(String.valueOf(c) + string), (boolean)false, (int)4, null);
            c = '/';
            string = String.valueOf(relocation.hashCode());
            bl = false;
            content = StringsKt.replace$default((String)string2, (String)relocation.getFromSlash(), (String)(String.valueOf(c) + string), (boolean)false, (int)4, null);
        }
        for (RelocationWrapper relocation : relocations) {
            c = '.';
            string = String.valueOf(relocation.hashCode());
            bl = false;
            String string3 = StringsKt.replace$default((String)content, (String)(String.valueOf(c) + string), (String)relocation.getToDot(), (boolean)false, (int)4, null);
            c = '/';
            string = String.valueOf(relocation.hashCode());
            bl = false;
            content = StringsKt.replace$default((String)string3, (String)(String.valueOf(c) + string), (String)relocation.getToSlash(), (boolean)false, (int)4, null);
        }
        PathsKt.writeText((Path)path, (CharSequence)content, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void relocateFiles(List<RelocationWrapper> relocations, Path workingDir) {
        AutoCloseable autoCloseable = Files.walk(workingDir, new FileVisitOption[0]);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl3 = false;
            stream.filter(relocateFiles.1.1.INSTANCE).forEach(new Consumer(this, workingDir, relocations){
                final /* synthetic */ GenerateDevBundle this$0;
                final /* synthetic */ Path $workingDir$inlined;
                final /* synthetic */ List $relocations$inlined;
                {
                    this.this$0 = generateDevBundle;
                    this.$workingDir$inlined = path;
                    this.$relocations$inlined = list;
                }

                public final void accept(Path path) {
                    Path path2 = path;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                    Path path3 = PathsKt.relativeTo((Path)path2, (Path)this.$workingDir$inlined);
                    boolean bl = false;
                    String potential = ((Object)path3).toString();
                    for (RelocationWrapper relocation : this.$relocations$inlined) {
                        Path dest;
                        if (!StringsKt.startsWith$default((String)potential, (String)relocation.getFromSlash(), (boolean)false, (int)2, null)) continue;
                        if (GenerateDevBundle.access$excluded(this.this$0, relocation.getRelocation(), potential)) break;
                        Path path4 = dest = this.$workingDir$inlined.resolve(StringsKt.replace$default((String)potential, (String)relocation.getFromSlash(), (String)relocation.getToSlash(), (boolean)false, (int)4, null));
                        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"dest");
                        Path path5 = path4.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"dest.parent");
                        Path path6 = path5;
                        Object object = new FileAttribute[]{};
                        boolean bl2 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path6, Arrays.copyOf(object, ((FileAttribute[])object).length)), (String)"Files.createDirectories(this, *attributes)");
                        path6 = path;
                        object = dest;
                        bl2 = false;
                        boolean bl3 = false;
                        CopyOption[] copyOptionArray = new CopyOption[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.move(path6, (Path)object, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.move(this, target, *options)");
                        break;
                    }
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean excluded(Relocation relocation, String potential) {
        boolean bl;
        block4: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = relocation.getExcludes();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = StringsKt.replace$default((String)it, (char)'.', (char)'/', (boolean)false, (int)4, null);
                collection.add(string2);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String exclude = (String)element$iv;
                    boolean bl3 = false;
                    if (!SelectorUtils.matchPath((String)exclude, (String)potential, (boolean)true)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String diffFiles(String fileName, Path original, Path patched) {
        String string = "diff";
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl = false;
        Path path = Files.createTempDirectory(string, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Files.createTempDirectory(prefix, *attributes)");
        Path dir = path;
        try {
            Path oldFile = dir.resolve("old.java");
            Path newFile = dir.resolve("new.java");
            Path path2 = original;
            Path path3 = oldFile;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"oldFile");
            Object object = path3;
            boolean bl2 = false;
            boolean bl3 = false;
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, (Path)object, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
            path2 = patched;
            Path path4 = newFile;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"newFile");
            object = path4;
            bl2 = false;
            bl3 = false;
            copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, (Path)object, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
            Object[] objectArray = new String[9];
            objectArray[0] = "diff";
            objectArray[1] = "--color=never";
            objectArray[2] = "-ud";
            objectArray[3] = "--label";
            objectArray[4] = "a/" + fileName;
            object = oldFile;
            bl2 = false;
            objectArray[5] = ((Object)object.toAbsolutePath()).toString();
            objectArray[6] = "--label";
            objectArray[7] = "b/" + fileName;
            object = newFile;
            bl2 = false;
            objectArray[8] = ((Object)object.toAbsolutePath()).toString();
            List args = CollectionsKt.listOf((Object[])objectArray);
            object = this.runDiff(dir, args);
            return object;
        }
        finally {
            FileKt.deleteRecursively$default(dir, null, 1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String runDiff(Path dir, List<String> args) {
        Process process = FileKt.directory(new ProcessBuilder(args), dir).redirectErrorStream(true).start();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Process process2 = process;
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"process");
        Object object = process2.getInputStream();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)object;
            boolean bl3 = false;
            InputStream inputStream = input;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"input");
            long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)out, (int)0, (int)2, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        byte[] byArray2 = out.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"out.toByteArray()");
        object = byArray2;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.defaultCharset()");
        Charset charset2 = charset;
        boolean bl4 = false;
        String string = new String((byte[])object, charset2);
        String string2 = System.getProperty("line.separator");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"System.getProperty(\"line.separator\")");
        return StringsKt.replace$default((String)string, (String)string2, (String)"\n", (boolean)false, (int)4, null);
    }

    private final DevBundleConfig createBundleConfig(String dataTargetDir, String patchTargetDir) {
        Object object = this.getMinecraftVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"minecraftVersion.get()");
        String string = (String)object;
        Object object2 = this.getServerCoordinates().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"serverCoordinates.get()");
        return new DevBundleConfig(string, (String)object2, (String)this.getApiCoordinates().get() + ':' + (String)this.getServerVersion().get(), (String)this.getMojangApiCoordinates().get() + ':' + (String)this.getServerVersion().get(), this.createBuildDataConfig(dataTargetDir), this.createDecompileRunner(), this.createRemapDep(), patchTargetDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<Relocation> relocations() {
        Object t;
        void $this$fromJson$iv;
        Gson gson = UtilsKt.getGson();
        Object object = this.getRelocations().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"relocations.get()");
        Object any$iv = object;
        boolean $i$f$fromJson = false;
        Object object2 = any$iv;
        if (object2 instanceof String) {
            Type type;
            void $receiver$iv$iv = $this$fromJson$iv;
            String string = (String)any$iv;
            void var7_10 = $receiver$iv$iv;
            Type type2 = new TypeToken<List<? extends Relocation>>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
            Type type$iv$iv$iv = type2;
            if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                Type type3 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                type = type3;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
            } else {
                type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv);
            }
            Type type4 = type;
            Object t2 = var7_10.fromJson(string, type4);
            t = t2;
            Intrinsics.checkExpressionValueIsNotNull(t2, (String)"fromJson(json, typeToken<T>())");
        } else {
            Object object3 = UtilsKt.convertToPath(any$iv);
            Charset charset = Charsets.UTF_8;
            OpenOption[] type$iv$iv$iv = new OpenOption[]{};
            int n = 8192;
            boolean bl = false;
            object3 = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object3, Arrays.copyOf(type$iv$iv$iv, type$iv$iv$iv.length)), charset), n);
            boolean bl2 = false;
            n = 0;
            Throwable throwable = null;
            try {
                Type type;
                BufferedReader it$iv = (BufferedReader)object3;
                boolean bl3 = false;
                void $receiver$iv$iv = $this$fromJson$iv;
                Reader reader = it$iv;
                void var12_21 = $receiver$iv$iv;
                Type type5 = new TypeToken<List<? extends Relocation>>(){}.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"object : TypeToken<T>() {} .type");
                Type type$iv$iv$iv2 = type5;
                if (type$iv$iv$iv2 instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv2)) {
                    Type type6 = ((ParameterizedType)type$iv$iv$iv2).getRawType();
                    type = type6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type6, (String)"type.rawType");
                } else {
                    type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv2);
                }
                Type type7 = type;
                Object t3 = var12_21.fromJson(reader, type7);
                Intrinsics.checkExpressionValueIsNotNull(t3, (String)"fromJson(json, typeToken<T>())");
                Object t4 = t3;
                t = t4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
            }
        }
        return (List)t;
    }

    /*
     * WARNING - void declaration
     */
    private final BuildData createBuildDataConfig(String targetDir) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = this.getParamMappingsUrl().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"paramMappingsUrl.get()");
        MavenDep mavenDep = new MavenDep((String)object, CollectionsKt.listOf((Object)this.getParamMappingsCoordinates().get()));
        String string = targetDir + "/mojang+yarn-spigot-reobf.tiny";
        String string2 = targetDir + "/transform.at";
        String string3 = targetDir + "/paperclip-mojang+yarn.jar";
        Object object2 = this.getVanillaJarIncludes().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"vanillaJarIncludes.get()");
        List list = (List)object2;
        Object object3 = this.getVanillaServerLibraries().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"vanillaServerLibraries.get()");
        Iterable iterable = this.collectRuntimeDependencies();
        List list2 = CollectionsKt.sorted((Iterable)this.determineLibraries((List)object3));
        List list3 = list;
        String string4 = string3;
        String string5 = string2;
        String string6 = string;
        MavenDep mavenDep2 = mavenDep;
        boolean $i$f$map = false;
        void var4_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResolvedArtifactResult resolvedArtifactResult = (ResolvedArtifactResult)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string7 = this.getCoordinates((ResolvedArtifactResult)it);
            collection.add(string7);
        }
        collection = (List)destination$iv$iv;
        List list4 = CollectionsKt.sorted((Iterable)collection);
        Object object4 = this.getLibraryRepositories().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"libraryRepositories.get()");
        List<String> list5 = TinyRemapper.INSTANCE.getPluginRemapArgs();
        List<String> list6 = TinyRemapper.INSTANCE.getMinecraftRemapArgs();
        List<Relocation> list7 = this.relocations();
        List list8 = (List)object4;
        List list9 = list4;
        List list10 = list2;
        List list11 = list3;
        String string8 = string4;
        String string9 = string5;
        String string10 = string6;
        MavenDep mavenDep3 = mavenDep2;
        return new BuildData(mavenDep3, string10, string9, string8, list11, list10, list9, list8, list7, list6, list5);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> determineLibraries(List<String> vanillaServerLibraries) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$none$iv;
        Object it;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        Object object = this.getServerProject().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"serverProject.get()");
        Configuration configuration = ((Project)object).getConfigurations().getByName("implementation");
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"serverProject.get().conf\u2026ATION_CONFIGURATION_NAME)");
        for (Dependency dependency : configuration.getDependencies()) {
            Iterator element$iv2;
            Collection $this$first$iv;
            block8: {
                if (!(dependency instanceof ExternalModuleDependency)) continue;
                Object[] objectArray = new String[4];
                VersionConstraint versionConstraint = ((ExternalModuleDependency)dependency).getVersionConstraint();
                Intrinsics.checkNotNullExpressionValue((Object)versionConstraint, (String)"dependency.versionConstraint");
                objectArray[0] = versionConstraint.getStrictVersion();
                VersionConstraint versionConstraint2 = ((ExternalModuleDependency)dependency).getVersionConstraint();
                Intrinsics.checkNotNullExpressionValue((Object)versionConstraint2, (String)"dependency.versionConstraint");
                objectArray[1] = versionConstraint2.getRequiredVersion();
                VersionConstraint versionConstraint3 = ((ExternalModuleDependency)dependency).getVersionConstraint();
                Intrinsics.checkNotNullExpressionValue((Object)versionConstraint3, (String)"dependency.versionConstraint");
                objectArray[2] = versionConstraint3.getPreferredVersion();
                objectArray[3] = ((ExternalModuleDependency)dependency).getVersion();
                Iterable iterable = CollectionsKt.listOfNotNull((Object[])objectArray);
                boolean $i$f$first = false;
                for (Iterator element$iv2 : $this$first$iv) {
                    it = (String)((Object)element$iv2);
                    boolean bl2 = false;
                    Object object2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it");
                    CharSequence charSequence = (CharSequence)object2;
                    boolean bl3 = false;
                    if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                    break block8;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            Iterator iterator = element$iv2;
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"listOfNotNull(\n         \u2026first { it.isNotBlank() }");
            String version = (String)((Object)iterator);
            $this$first$iv = arrayList;
            String string = ((ExternalModuleDependency)dependency).getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependency.group");
            String string2 = ((ExternalModuleDependency)dependency).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dependency.name");
            ModuleId $i$f$first = new ModuleId(string, string2, version);
            boolean bl4 = false;
            $this$first$iv.add($i$f$first);
        }
        for (String vanillaLib : vanillaServerLibraries) {
            boolean bl5;
            boolean $i$f$none;
            ModuleId vanilla;
            block9: {
                vanilla = ModuleId.Companion.parse(vanillaLib);
                $this$none$iv = arrayList;
                $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl5 = true;
                } else {
                    for (Iterator element$iv2 : $this$none$iv) {
                        it = (ModuleId)((Object)element$iv2);
                        boolean bl6 = false;
                        if (!(Intrinsics.areEqual((Object)((ModuleId)it).getGroup(), (Object)vanilla.getGroup()) && Intrinsics.areEqual((Object)((ModuleId)it).getName(), (Object)vanilla.getName()))) continue;
                        bl5 = false;
                        break block9;
                    }
                    bl5 = true;
                }
            }
            if (!bl5) continue;
            $this$none$iv = arrayList;
            $i$f$none = false;
            $this$none$iv.add(vanilla);
        }
        Iterable $this$map$iv = arrayList;
        boolean $i$f$map = false;
        $this$none$iv = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ModuleId bl6 = (ModuleId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl7 = false;
            String string = it2.toString();
            collection.add(string);
        }
        Set result = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv = this.relocations();
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl8 = false;
            Relocation it3 = (Relocation)element$iv$iv;
            boolean bl9 = false;
            if (it3.getOwningLibraryCoordinates() == null) continue;
            boolean bl10 = false;
            boolean bl11 = false;
            String it$iv$iv = string;
            boolean bl12 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List libs = (List)destination$iv$iv2;
        result.removeIf(new Predicate(libs){
            final /* synthetic */ List $libs;

            public final boolean test(@NotNull String coords) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                    Iterable $this$any$iv = this.$libs;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.startsWith$default((String)coords, (String)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            {
                this.$libs = list;
            }
        });
        return result;
    }

    private final String getCoordinates(ResolvedArtifactResult $this$coordinates) {
        ComponentArtifactIdentifier componentArtifactIdentifier = $this$coordinates.getId();
        Intrinsics.checkNotNullExpressionValue((Object)componentArtifactIdentifier, (String)"id");
        ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
        if (componentIdentifier == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.artifacts.component.ModuleComponentIdentifier");
        }
        return ModuleId.Companion.fromIdentifier((ModuleComponentIdentifier)componentIdentifier).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ResolvedArtifactResult> collectRuntimeDependencies() {
        void var2_2;
        void $this$filterTo$iv;
        Object object = this.getRuntimeConfiguration().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runtimeConfiguration.get()");
        ResolvableDependencies resolvableDependencies = ((Configuration)object).getIncoming();
        Intrinsics.checkNotNullExpressionValue((Object)resolvableDependencies, (String)"runtimeConfiguration.get().incoming");
        ArtifactCollection artifactCollection = resolvableDependencies.getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)artifactCollection, (String)"runtimeConfiguration.get().incoming.artifacts");
        Set set = artifactCollection.getArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"runtimeConfiguration.get\u2026oming.artifacts.artifacts");
        Iterable iterable = set;
        Collection destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            ResolvedArtifactResult it = (ResolvedArtifactResult)element$iv;
            boolean bl = false;
            ResolvedArtifactResult resolvedArtifactResult = it;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifactResult, (String)"it");
            ComponentArtifactIdentifier componentArtifactIdentifier = resolvedArtifactResult.getId();
            Intrinsics.checkNotNullExpressionValue((Object)componentArtifactIdentifier, (String)"it.id");
            if (!(componentArtifactIdentifier.getComponentIdentifier() instanceof ModuleComponentIdentifier)) continue;
            destination$iv.add(element$iv);
        }
        return (Set)var2_2;
    }

    private final Runner createDecompileRunner() {
        return new Runner(DependenciesKt.determineMavenDep((Provider<String>)((Provider)this.getDecompilerUrl()), (Provider<Configuration>)((Provider)this.getDecompilerConfig())), RunForgeFlowerKt.getForgeFlowerArgList());
    }

    private final MavenDep createRemapDep() {
        return DependenciesKt.determineMavenDep((Provider<String>)((Provider)this.getRemapperUrl()), (Provider<Configuration>)((Provider)this.getRemapperConfig()));
    }

    public static final /* synthetic */ void access$replaceRelocationsInFile(GenerateDevBundle $this, Path path, List relocations) {
        $this.replaceRelocationsInFile(path, relocations);
    }

    public static final /* synthetic */ boolean access$excluded(GenerateDevBundle $this, Relocation relocation, String potential) {
        return $this.excluded(relocation, potential);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\nH\u00c6\u0003J\t\u0010!\u001a\u00020\fH\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003JY\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006*"}, d2={"Lio/papermc/paperweight/tasks/GenerateDevBundle$DevBundleConfig;", "", "minecraftVersion", "", "mappedServerCoordinates", "apiCoordinates", "mojangApiCoordinates", "buildData", "Lio/papermc/paperweight/tasks/GenerateDevBundle$BuildData;", "decompile", "Lio/papermc/paperweight/tasks/GenerateDevBundle$Runner;", "remapper", "Lio/papermc/paperweight/util/MavenDep;", "patchDir", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/papermc/paperweight/tasks/GenerateDevBundle$BuildData;Lio/papermc/paperweight/tasks/GenerateDevBundle$Runner;Lio/papermc/paperweight/util/MavenDep;Ljava/lang/String;)V", "getApiCoordinates", "()Ljava/lang/String;", "getBuildData", "()Lio/papermc/paperweight/tasks/GenerateDevBundle$BuildData;", "getDecompile", "()Lio/papermc/paperweight/tasks/GenerateDevBundle$Runner;", "getMappedServerCoordinates", "getMinecraftVersion", "getMojangApiCoordinates", "getPatchDir", "getRemapper", "()Lio/papermc/paperweight/util/MavenDep;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "paperweight-lib"})
    public static final class DevBundleConfig {
        @NotNull
        private final String minecraftVersion;
        @NotNull
        private final String mappedServerCoordinates;
        @NotNull
        private final String apiCoordinates;
        @NotNull
        private final String mojangApiCoordinates;
        @NotNull
        private final BuildData buildData;
        @NotNull
        private final Runner decompile;
        @NotNull
        private final MavenDep remapper;
        @NotNull
        private final String patchDir;

        @NotNull
        public final String getMinecraftVersion() {
            return this.minecraftVersion;
        }

        @NotNull
        public final String getMappedServerCoordinates() {
            return this.mappedServerCoordinates;
        }

        @NotNull
        public final String getApiCoordinates() {
            return this.apiCoordinates;
        }

        @NotNull
        public final String getMojangApiCoordinates() {
            return this.mojangApiCoordinates;
        }

        @NotNull
        public final BuildData getBuildData() {
            return this.buildData;
        }

        @NotNull
        public final Runner getDecompile() {
            return this.decompile;
        }

        @NotNull
        public final MavenDep getRemapper() {
            return this.remapper;
        }

        @NotNull
        public final String getPatchDir() {
            return this.patchDir;
        }

        public DevBundleConfig(@NotNull String minecraftVersion2, @NotNull String mappedServerCoordinates, @NotNull String apiCoordinates, @NotNull String mojangApiCoordinates, @NotNull BuildData buildData, @NotNull Runner decompile, @NotNull MavenDep remapper, @NotNull String patchDir) {
            Intrinsics.checkNotNullParameter((Object)minecraftVersion2, (String)"minecraftVersion");
            Intrinsics.checkNotNullParameter((Object)mappedServerCoordinates, (String)"mappedServerCoordinates");
            Intrinsics.checkNotNullParameter((Object)apiCoordinates, (String)"apiCoordinates");
            Intrinsics.checkNotNullParameter((Object)mojangApiCoordinates, (String)"mojangApiCoordinates");
            Intrinsics.checkNotNullParameter((Object)buildData, (String)"buildData");
            Intrinsics.checkNotNullParameter((Object)decompile, (String)"decompile");
            Intrinsics.checkNotNullParameter((Object)remapper, (String)"remapper");
            Intrinsics.checkNotNullParameter((Object)patchDir, (String)"patchDir");
            this.minecraftVersion = minecraftVersion2;
            this.mappedServerCoordinates = mappedServerCoordinates;
            this.apiCoordinates = apiCoordinates;
            this.mojangApiCoordinates = mojangApiCoordinates;
            this.buildData = buildData;
            this.decompile = decompile;
            this.remapper = remapper;
            this.patchDir = patchDir;
        }

        @NotNull
        public final String component1() {
            return this.minecraftVersion;
        }

        @NotNull
        public final String component2() {
            return this.mappedServerCoordinates;
        }

        @NotNull
        public final String component3() {
            return this.apiCoordinates;
        }

        @NotNull
        public final String component4() {
            return this.mojangApiCoordinates;
        }

        @NotNull
        public final BuildData component5() {
            return this.buildData;
        }

        @NotNull
        public final Runner component6() {
            return this.decompile;
        }

        @NotNull
        public final MavenDep component7() {
            return this.remapper;
        }

        @NotNull
        public final String component8() {
            return this.patchDir;
        }

        @NotNull
        public final DevBundleConfig copy(@NotNull String minecraftVersion2, @NotNull String mappedServerCoordinates, @NotNull String apiCoordinates, @NotNull String mojangApiCoordinates, @NotNull BuildData buildData, @NotNull Runner decompile, @NotNull MavenDep remapper, @NotNull String patchDir) {
            Intrinsics.checkNotNullParameter((Object)minecraftVersion2, (String)"minecraftVersion");
            Intrinsics.checkNotNullParameter((Object)mappedServerCoordinates, (String)"mappedServerCoordinates");
            Intrinsics.checkNotNullParameter((Object)apiCoordinates, (String)"apiCoordinates");
            Intrinsics.checkNotNullParameter((Object)mojangApiCoordinates, (String)"mojangApiCoordinates");
            Intrinsics.checkNotNullParameter((Object)buildData, (String)"buildData");
            Intrinsics.checkNotNullParameter((Object)decompile, (String)"decompile");
            Intrinsics.checkNotNullParameter((Object)remapper, (String)"remapper");
            Intrinsics.checkNotNullParameter((Object)patchDir, (String)"patchDir");
            return new DevBundleConfig(minecraftVersion2, mappedServerCoordinates, apiCoordinates, mojangApiCoordinates, buildData, decompile, remapper, patchDir);
        }

        public static /* synthetic */ DevBundleConfig copy$default(DevBundleConfig devBundleConfig, String string, String string2, String string3, String string4, BuildData buildData, Runner runner, MavenDep mavenDep, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = devBundleConfig.minecraftVersion;
            }
            if ((n & 2) != 0) {
                string2 = devBundleConfig.mappedServerCoordinates;
            }
            if ((n & 4) != 0) {
                string3 = devBundleConfig.apiCoordinates;
            }
            if ((n & 8) != 0) {
                string4 = devBundleConfig.mojangApiCoordinates;
            }
            if ((n & 0x10) != 0) {
                buildData = devBundleConfig.buildData;
            }
            if ((n & 0x20) != 0) {
                runner = devBundleConfig.decompile;
            }
            if ((n & 0x40) != 0) {
                mavenDep = devBundleConfig.remapper;
            }
            if ((n & 0x80) != 0) {
                string5 = devBundleConfig.patchDir;
            }
            return devBundleConfig.copy(string, string2, string3, string4, buildData, runner, mavenDep, string5);
        }

        @NotNull
        public String toString() {
            return "DevBundleConfig(minecraftVersion=" + this.minecraftVersion + ", mappedServerCoordinates=" + this.mappedServerCoordinates + ", apiCoordinates=" + this.apiCoordinates + ", mojangApiCoordinates=" + this.mojangApiCoordinates + ", buildData=" + this.buildData + ", decompile=" + this.decompile + ", remapper=" + this.remapper + ", patchDir=" + this.patchDir + ")";
        }

        public int hashCode() {
            String string = this.minecraftVersion;
            String string2 = this.mappedServerCoordinates;
            String string3 = this.apiCoordinates;
            String string4 = this.mojangApiCoordinates;
            BuildData buildData = this.buildData;
            Runner runner = this.decompile;
            MavenDep mavenDep = this.remapper;
            String string5 = this.patchDir;
            return (((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (buildData != null ? ((Object)buildData).hashCode() : 0)) * 31 + (runner != null ? ((Object)runner).hashCode() : 0)) * 31 + (mavenDep != null ? ((Object)mavenDep).hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DevBundleConfig)) break block3;
                    DevBundleConfig devBundleConfig = (DevBundleConfig)object;
                    if (!Intrinsics.areEqual((Object)this.minecraftVersion, (Object)devBundleConfig.minecraftVersion) || !Intrinsics.areEqual((Object)this.mappedServerCoordinates, (Object)devBundleConfig.mappedServerCoordinates) || !Intrinsics.areEqual((Object)this.apiCoordinates, (Object)devBundleConfig.apiCoordinates) || !Intrinsics.areEqual((Object)this.mojangApiCoordinates, (Object)devBundleConfig.mojangApiCoordinates) || !Intrinsics.areEqual((Object)this.buildData, (Object)devBundleConfig.buildData) || !Intrinsics.areEqual((Object)this.decompile, (Object)devBundleConfig.decompile) || !Intrinsics.areEqual((Object)this.remapper, (Object)devBundleConfig.remapper) || !Intrinsics.areEqual((Object)this.patchDir, (Object)devBundleConfig.patchDir)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0087\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\u0011J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\tH\u00c6\u0003J\u00a1\u0001\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0015\u00a8\u00062"}, d2={"Lio/papermc/paperweight/tasks/GenerateDevBundle$BuildData;", "", "paramMappings", "Lio/papermc/paperweight/util/MavenDep;", "reobfMappingsFile", "", "accessTransformFile", "mojangMappedPaperclipFile", "vanillaJarIncludes", "", "compileDependencies", "runtimeDependencies", "libraryRepositories", "relocations", "Lio/papermc/paperweight/extension/Relocation;", "minecraftRemapArgs", "pluginRemapArgs", "(Lio/papermc/paperweight/util/MavenDep;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAccessTransformFile", "()Ljava/lang/String;", "getCompileDependencies", "()Ljava/util/List;", "getLibraryRepositories", "getMinecraftRemapArgs", "getMojangMappedPaperclipFile", "getParamMappings", "()Lio/papermc/paperweight/util/MavenDep;", "getPluginRemapArgs", "getRelocations", "getReobfMappingsFile", "getRuntimeDependencies", "getVanillaJarIncludes", "component1", "component10", "component11", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "paperweight-lib"})
    public static final class BuildData {
        @NotNull
        private final MavenDep paramMappings;
        @NotNull
        private final String reobfMappingsFile;
        @NotNull
        private final String accessTransformFile;
        @NotNull
        private final String mojangMappedPaperclipFile;
        @NotNull
        private final List<String> vanillaJarIncludes;
        @NotNull
        private final List<String> compileDependencies;
        @NotNull
        private final List<String> runtimeDependencies;
        @NotNull
        private final List<String> libraryRepositories;
        @NotNull
        private final List<Relocation> relocations;
        @NotNull
        private final List<String> minecraftRemapArgs;
        @NotNull
        private final List<String> pluginRemapArgs;

        @NotNull
        public final MavenDep getParamMappings() {
            return this.paramMappings;
        }

        @NotNull
        public final String getReobfMappingsFile() {
            return this.reobfMappingsFile;
        }

        @NotNull
        public final String getAccessTransformFile() {
            return this.accessTransformFile;
        }

        @NotNull
        public final String getMojangMappedPaperclipFile() {
            return this.mojangMappedPaperclipFile;
        }

        @NotNull
        public final List<String> getVanillaJarIncludes() {
            return this.vanillaJarIncludes;
        }

        @NotNull
        public final List<String> getCompileDependencies() {
            return this.compileDependencies;
        }

        @NotNull
        public final List<String> getRuntimeDependencies() {
            return this.runtimeDependencies;
        }

        @NotNull
        public final List<String> getLibraryRepositories() {
            return this.libraryRepositories;
        }

        @NotNull
        public final List<Relocation> getRelocations() {
            return this.relocations;
        }

        @NotNull
        public final List<String> getMinecraftRemapArgs() {
            return this.minecraftRemapArgs;
        }

        @NotNull
        public final List<String> getPluginRemapArgs() {
            return this.pluginRemapArgs;
        }

        public BuildData(@NotNull MavenDep paramMappings2, @NotNull String reobfMappingsFile, @NotNull String accessTransformFile, @NotNull String mojangMappedPaperclipFile, @NotNull List<String> vanillaJarIncludes, @NotNull List<String> compileDependencies, @NotNull List<String> runtimeDependencies, @NotNull List<String> libraryRepositories, @NotNull List<Relocation> relocations, @NotNull List<String> minecraftRemapArgs, @NotNull List<String> pluginRemapArgs) {
            Intrinsics.checkNotNullParameter((Object)paramMappings2, (String)"paramMappings");
            Intrinsics.checkNotNullParameter((Object)reobfMappingsFile, (String)"reobfMappingsFile");
            Intrinsics.checkNotNullParameter((Object)accessTransformFile, (String)"accessTransformFile");
            Intrinsics.checkNotNullParameter((Object)mojangMappedPaperclipFile, (String)"mojangMappedPaperclipFile");
            Intrinsics.checkNotNullParameter(vanillaJarIncludes, (String)"vanillaJarIncludes");
            Intrinsics.checkNotNullParameter(compileDependencies, (String)"compileDependencies");
            Intrinsics.checkNotNullParameter(runtimeDependencies, (String)"runtimeDependencies");
            Intrinsics.checkNotNullParameter(libraryRepositories, (String)"libraryRepositories");
            Intrinsics.checkNotNullParameter(relocations, (String)"relocations");
            Intrinsics.checkNotNullParameter(minecraftRemapArgs, (String)"minecraftRemapArgs");
            Intrinsics.checkNotNullParameter(pluginRemapArgs, (String)"pluginRemapArgs");
            this.paramMappings = paramMappings2;
            this.reobfMappingsFile = reobfMappingsFile;
            this.accessTransformFile = accessTransformFile;
            this.mojangMappedPaperclipFile = mojangMappedPaperclipFile;
            this.vanillaJarIncludes = vanillaJarIncludes;
            this.compileDependencies = compileDependencies;
            this.runtimeDependencies = runtimeDependencies;
            this.libraryRepositories = libraryRepositories;
            this.relocations = relocations;
            this.minecraftRemapArgs = minecraftRemapArgs;
            this.pluginRemapArgs = pluginRemapArgs;
        }

        @NotNull
        public final MavenDep component1() {
            return this.paramMappings;
        }

        @NotNull
        public final String component2() {
            return this.reobfMappingsFile;
        }

        @NotNull
        public final String component3() {
            return this.accessTransformFile;
        }

        @NotNull
        public final String component4() {
            return this.mojangMappedPaperclipFile;
        }

        @NotNull
        public final List<String> component5() {
            return this.vanillaJarIncludes;
        }

        @NotNull
        public final List<String> component6() {
            return this.compileDependencies;
        }

        @NotNull
        public final List<String> component7() {
            return this.runtimeDependencies;
        }

        @NotNull
        public final List<String> component8() {
            return this.libraryRepositories;
        }

        @NotNull
        public final List<Relocation> component9() {
            return this.relocations;
        }

        @NotNull
        public final List<String> component10() {
            return this.minecraftRemapArgs;
        }

        @NotNull
        public final List<String> component11() {
            return this.pluginRemapArgs;
        }

        @NotNull
        public final BuildData copy(@NotNull MavenDep paramMappings2, @NotNull String reobfMappingsFile, @NotNull String accessTransformFile, @NotNull String mojangMappedPaperclipFile, @NotNull List<String> vanillaJarIncludes, @NotNull List<String> compileDependencies, @NotNull List<String> runtimeDependencies, @NotNull List<String> libraryRepositories, @NotNull List<Relocation> relocations, @NotNull List<String> minecraftRemapArgs, @NotNull List<String> pluginRemapArgs) {
            Intrinsics.checkNotNullParameter((Object)paramMappings2, (String)"paramMappings");
            Intrinsics.checkNotNullParameter((Object)reobfMappingsFile, (String)"reobfMappingsFile");
            Intrinsics.checkNotNullParameter((Object)accessTransformFile, (String)"accessTransformFile");
            Intrinsics.checkNotNullParameter((Object)mojangMappedPaperclipFile, (String)"mojangMappedPaperclipFile");
            Intrinsics.checkNotNullParameter(vanillaJarIncludes, (String)"vanillaJarIncludes");
            Intrinsics.checkNotNullParameter(compileDependencies, (String)"compileDependencies");
            Intrinsics.checkNotNullParameter(runtimeDependencies, (String)"runtimeDependencies");
            Intrinsics.checkNotNullParameter(libraryRepositories, (String)"libraryRepositories");
            Intrinsics.checkNotNullParameter(relocations, (String)"relocations");
            Intrinsics.checkNotNullParameter(minecraftRemapArgs, (String)"minecraftRemapArgs");
            Intrinsics.checkNotNullParameter(pluginRemapArgs, (String)"pluginRemapArgs");
            return new BuildData(paramMappings2, reobfMappingsFile, accessTransformFile, mojangMappedPaperclipFile, vanillaJarIncludes, compileDependencies, runtimeDependencies, libraryRepositories, relocations, minecraftRemapArgs, pluginRemapArgs);
        }

        public static /* synthetic */ BuildData copy$default(BuildData buildData, MavenDep mavenDep, String string, String string2, String string3, List list, List list2, List list3, List list4, List list5, List list6, List list7, int n, Object object) {
            if ((n & 1) != 0) {
                mavenDep = buildData.paramMappings;
            }
            if ((n & 2) != 0) {
                string = buildData.reobfMappingsFile;
            }
            if ((n & 4) != 0) {
                string2 = buildData.accessTransformFile;
            }
            if ((n & 8) != 0) {
                string3 = buildData.mojangMappedPaperclipFile;
            }
            if ((n & 0x10) != 0) {
                list = buildData.vanillaJarIncludes;
            }
            if ((n & 0x20) != 0) {
                list2 = buildData.compileDependencies;
            }
            if ((n & 0x40) != 0) {
                list3 = buildData.runtimeDependencies;
            }
            if ((n & 0x80) != 0) {
                list4 = buildData.libraryRepositories;
            }
            if ((n & 0x100) != 0) {
                list5 = buildData.relocations;
            }
            if ((n & 0x200) != 0) {
                list6 = buildData.minecraftRemapArgs;
            }
            if ((n & 0x400) != 0) {
                list7 = buildData.pluginRemapArgs;
            }
            return buildData.copy(mavenDep, string, string2, string3, list, list2, list3, list4, list5, list6, list7);
        }

        @NotNull
        public String toString() {
            return "BuildData(paramMappings=" + this.paramMappings + ", reobfMappingsFile=" + this.reobfMappingsFile + ", accessTransformFile=" + this.accessTransformFile + ", mojangMappedPaperclipFile=" + this.mojangMappedPaperclipFile + ", vanillaJarIncludes=" + this.vanillaJarIncludes + ", compileDependencies=" + this.compileDependencies + ", runtimeDependencies=" + this.runtimeDependencies + ", libraryRepositories=" + this.libraryRepositories + ", relocations=" + this.relocations + ", minecraftRemapArgs=" + this.minecraftRemapArgs + ", pluginRemapArgs=" + this.pluginRemapArgs + ")";
        }

        public int hashCode() {
            MavenDep mavenDep = this.paramMappings;
            String string = this.reobfMappingsFile;
            String string2 = this.accessTransformFile;
            String string3 = this.mojangMappedPaperclipFile;
            List<String> list = this.vanillaJarIncludes;
            List<String> list2 = this.compileDependencies;
            List<String> list3 = this.runtimeDependencies;
            List<String> list4 = this.libraryRepositories;
            List<Relocation> list5 = this.relocations;
            List<String> list6 = this.minecraftRemapArgs;
            List<String> list7 = this.pluginRemapArgs;
            return ((((((((((mavenDep != null ? ((Object)mavenDep).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0)) * 31 + (list4 != null ? ((Object)list4).hashCode() : 0)) * 31 + (list5 != null ? ((Object)list5).hashCode() : 0)) * 31 + (list6 != null ? ((Object)list6).hashCode() : 0)) * 31 + (list7 != null ? ((Object)list7).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BuildData)) break block3;
                    BuildData buildData = (BuildData)object;
                    if (!Intrinsics.areEqual((Object)this.paramMappings, (Object)buildData.paramMappings) || !Intrinsics.areEqual((Object)this.reobfMappingsFile, (Object)buildData.reobfMappingsFile) || !Intrinsics.areEqual((Object)this.accessTransformFile, (Object)buildData.accessTransformFile) || !Intrinsics.areEqual((Object)this.mojangMappedPaperclipFile, (Object)buildData.mojangMappedPaperclipFile) || !Intrinsics.areEqual(this.vanillaJarIncludes, buildData.vanillaJarIncludes) || !Intrinsics.areEqual(this.compileDependencies, buildData.compileDependencies) || !Intrinsics.areEqual(this.runtimeDependencies, buildData.runtimeDependencies) || !Intrinsics.areEqual(this.libraryRepositories, buildData.libraryRepositories) || !Intrinsics.areEqual(this.relocations, buildData.relocations) || !Intrinsics.areEqual(this.minecraftRemapArgs, buildData.minecraftRemapArgs) || !Intrinsics.areEqual(this.pluginRemapArgs, buildData.pluginRemapArgs)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lio/papermc/paperweight/tasks/GenerateDevBundle$Runner;", "", "dep", "Lio/papermc/paperweight/util/MavenDep;", "args", "", "", "(Lio/papermc/paperweight/util/MavenDep;Ljava/util/List;)V", "getArgs", "()Ljava/util/List;", "getDep", "()Lio/papermc/paperweight/util/MavenDep;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "paperweight-lib"})
    public static final class Runner {
        @NotNull
        private final MavenDep dep;
        @NotNull
        private final List<String> args;

        @NotNull
        public final MavenDep getDep() {
            return this.dep;
        }

        @NotNull
        public final List<String> getArgs() {
            return this.args;
        }

        public Runner(@NotNull MavenDep dep, @NotNull List<String> args) {
            Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            this.dep = dep;
            this.args = args;
        }

        @NotNull
        public final MavenDep component1() {
            return this.dep;
        }

        @NotNull
        public final List<String> component2() {
            return this.args;
        }

        @NotNull
        public final Runner copy(@NotNull MavenDep dep, @NotNull List<String> args) {
            Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            return new Runner(dep, args);
        }

        public static /* synthetic */ Runner copy$default(Runner runner, MavenDep mavenDep, List list, int n, Object object) {
            if ((n & 1) != 0) {
                mavenDep = runner.dep;
            }
            if ((n & 2) != 0) {
                list = runner.args;
            }
            return runner.copy(mavenDep, list);
        }

        @NotNull
        public String toString() {
            return "Runner(dep=" + this.dep + ", args=" + this.args + ")";
        }

        public int hashCode() {
            MavenDep mavenDep = this.dep;
            List<String> list = this.args;
            return (mavenDep != null ? ((Object)mavenDep).hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Runner)) break block3;
                    Runner runner = (Runner)object;
                    if (!Intrinsics.areEqual((Object)this.dep, (Object)runner.dep) || !Intrinsics.areEqual(this.args, runner.args)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/papermc/paperweight/tasks/GenerateDevBundle$Companion;", "", "()V", "atFileName", "", "currentDataVersion", "", "mojangMappedPaperclipFileName", "reobfMappingsFileName", "createCoordinatesFor", "project", "Lorg/gradle/api/Project;", "paperweight-lib"})
    public static final class Companion {
        @NotNull
        public final String createCoordinatesFor(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object[] objectArray = new Object[3];
            objectArray[0] = project.getGroup();
            String string = project.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.name");
            String string2 = string;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
            Locale locale2 = locale;
            boolean bl = false;
            String string3 = string2;
            boolean bl2 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            objectArray[1] = string5;
            objectArray[2] = "userdev-" + project.getVersion();
            return SequencesKt.joinToString$default((Sequence)SequencesKt.sequenceOf((Object[])objectArray), (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

