/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.JavaLauncherZippedTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.data.FileEntry;
import io.papermc.paperweight.util.data.LibraryChange;
import io.papermc.paperweight.util.data.ModuleId;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Action;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.FileSystemLocationProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.process.JavaForkOptions;
import org.gradle.workers.ProcessWorkerSpec;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import paper.libs.com.github.salomonbrys.kotson.GsonBuilderKt;
import paper.libs.com.google.gson.Gson;
import paper.libs.com.google.gson.reflect.TypeToken;
import paper.libs.io.sigpipe.jbsdiff.Diff;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b'\u0018\u00002\u00020\u0001:\u0006,-./01B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016JD\u0010\"\u001a\u00020#*\u00020$2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u001c2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030(2\u0006\u0010*\u001a\u00020+H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006R\u0014\u0010\u0014\u001a\u00020\u00158gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00062"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar;", "Lio/papermc/paperweight/tasks/JavaLauncherZippedTask;", "()V", "bundlerJar", "Lorg/gradle/api/file/RegularFileProperty;", "getBundlerJar", "()Lorg/gradle/api/file/RegularFileProperty;", "jvmargs", "Lorg/gradle/api/provider/ListProperty;", "", "getJvmargs", "()Lorg/gradle/api/provider/ListProperty;", "libraryChangesJson", "getLibraryChangesJson", "mcVersion", "Lorg/gradle/api/provider/Property;", "getMcVersion", "()Lorg/gradle/api/provider/Property;", "originalBundlerJar", "getOriginalBundlerJar", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "getWorkerExecutor", "()Lorg/gradle/workers/WorkerExecutor;", "createPatches", "", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$PatchEntry;", "rootDir", "Ljava/nio/file/Path;", "newBundlerRoot", "originalBundlerRoot", "init", "", "run", "submitPatchJob", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$PatchJob;", "Lorg/gradle/workers/WorkQueue;", "originalRoot", "newRoot", "originalEntry", "Lio/papermc/paperweight/util/data/FileEntry;", "newEntry", "location", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "DownloadContext", "EntryLocation", "PaperclipAction", "PaperclipParameters", "PatchEntry", "PatchJob", "paperweight-lib"})
public abstract class CreatePaperclipJar
extends JavaLauncherZippedTask {
    @Classpath
    @NotNull
    public abstract RegularFileProperty getOriginalBundlerJar();

    @Classpath
    @NotNull
    public abstract RegularFileProperty getBundlerJar();

    @Input
    @NotNull
    public abstract Property<String> getMcVersion();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getLibraryChangesJson();

    @Internal
    @NotNull
    public abstract ListProperty<String> getJvmargs();

    @Inject
    @NotNull
    public abstract WorkerExecutor getWorkerExecutor();

    @Override
    public void init() {
        super.init();
        this.getJvmargs().convention((Iterable)CollectionsKt.listOf((Object)"-Xmx1G"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(@NotNull Path rootDir) {
        MessageDigest messageDigest;
        boolean bl;
        OpenOption[] newBundlerFs2;
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        List<PatchEntry> patchEntries = null;
        Object object = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getBundlerJar())));
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            newBundlerFs2 = (OpenOption[])object;
            bl = false;
            Closeable closeable = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOriginalBundlerJar())));
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                Path newBundlerRoot;
                FileSystem originalBundlerFs = (FileSystem)closeable;
                boolean bl6 = false;
                Path originalBundlerRoot = originalBundlerFs.getPath("/", new String[0]);
                Path path = newBundlerRoot = newBundlerFs2.getPath("/", new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"newBundlerRoot");
                Path path2 = originalBundlerRoot;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"originalBundlerRoot");
                patchEntries = this.createPatches(rootDir, path, path2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            newBundlerFs2 = Unit.INSTANCE;
        }
        catch (Throwable newBundlerFs2) {
            throwable = newBundlerFs2;
            throw newBundlerFs2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Path path = rootDir.resolve("META-INF/patches.list");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"rootDir.resolve(PatchEntry.PATCHES_LIST)");
        object = path;
        newBundlerFs2 = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        bl = false;
        object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(newBundlerFs2, newBundlerFs2.length)), charset), n);
        boolean bl7 = false;
        n = 0;
        Throwable throwable4 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl8 = false;
            for (PatchEntry entry : patchEntries) {
                writer.append(entry.toString()).append('\n');
            }
            writer = Unit.INSTANCE;
        }
        catch (Throwable writer) {
            throwable4 = writer;
            throw writer;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable4);
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new PaperweightException("Could not create SHA1 digest", e);
        }
        MessageDigest digestSha1 = messageDigest;
        Path originalJar = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getOriginalBundlerJar()));
        String vanillaSha256Hash = FileKt.sha256asHex(originalJar);
        MessageDigest messageDigest2 = digestSha1;
        Intrinsics.checkNotNullExpressionValue((Object)messageDigest2, (String)"digestSha1");
        String vanillaSha1Hash = UtilsKt.toHex(FileKt.hashFile(originalJar, messageDigest2));
        String vanillaUrl = "https://launcher.mojang.com/v1/objects/" + vanillaSha1Hash + "/server.jar";
        String vanillaFileName = "mojang_" + (String)this.getMcVersion().get() + ".jar";
        DownloadContext context = new DownloadContext(vanillaSha256Hash, vanillaUrl, vanillaFileName);
        Path path3 = rootDir.resolve("META-INF/download-context");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"rootDir.resolve(DownloadContext.FILE)");
        PathsKt.writeText$default((Path)path3, (CharSequence)context.toString(), null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<PatchEntry> createPatches(Path rootDir, Path newBundlerRoot, Path originalBundlerRoot) {
        void $this$mapTo$iv$iv;
        PatchJob element$iv;
        Iterable originalLibrary;
        FileEntry it;
        Iterable $this$firstOrNull$iv;
        Object object;
        Object type$iv$iv$iv;
        Throwable throwable;
        Object $receiver$iv$iv;
        void $this$fromJson$iv;
        WorkQueue queue2 = this.getWorkerExecutor().processIsolation(new Action(this){
            final /* synthetic */ CreatePaperclipJar this$0;

            public final void execute(@NotNull ProcessWorkerSpec $this$processIsolation) {
                Intrinsics.checkNotNullParameter((Object)$this$processIsolation, (String)"$receiver");
                $this$processIsolation.getForkOptions().jvmArgs((Iterable)this.this$0.getJvmargs().get());
                JavaForkOptions javaForkOptions = $this$processIsolation.getForkOptions();
                Object object = this.this$0.getLauncher().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"launcher.get()");
                RegularFile regularFile = ((JavaLauncher)object).getExecutablePath();
                Intrinsics.checkNotNullExpressionValue((Object)regularFile, (String)"launcher.get().executablePath");
                Path path = FileKt.getPath((FileSystemLocation)regularFile);
                boolean bl = false;
                javaForkOptions.executable((Object)((Object)path.toAbsolutePath()).toString());
            }
            {
                this.this$0 = createPaperclipJar;
            }
        });
        boolean bl = false;
        List patchJobs = new ArrayList();
        Path path = originalBundlerRoot.resolve("META-INF/versions.list");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"originalBundlerRoot.reso\u2026(FileEntry.VERSIONS_LIST)");
        List<FileEntry<String>> originalVersions = FileEntry.Companion.parse(path);
        Path path2 = originalBundlerRoot.resolve("META-INF/libraries.list");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"originalBundlerRoot.reso\u2026FileEntry.LIBRARIES_LIST)");
        List originalLibraries2 = FileEntry.Companion.parse(path2, (Function1)new Function1<String, ModuleId>(ModuleId.Companion){

            @NotNull
            public final ModuleId invoke(@NotNull String p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ModuleId.Companion)this.receiver).parse(p1);
            }
        });
        FileKt.copyRecursivelyTo(newBundlerRoot, rootDir);
        Gson gson = UtilsKt.getGson();
        RegularFileProperty any$iv = this.getLibraryChangesJson();
        boolean bl2 = false;
        RegularFileProperty regularFileProperty = any$iv;
        if (regularFileProperty instanceof String) {
            Type type;
            $receiver$iv$iv = $this$fromJson$iv;
            String string = (String)any$iv;
            throwable = $receiver$iv$iv;
            Type type2 = new TypeToken<List<? extends LibraryChange>>(){}.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)type2, (String)"object : TypeToken<T>() {} .type");
            type$iv$iv$iv = type2;
            if (type$iv$iv$iv instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv)) {
                Type type3 = ((ParameterizedType)type$iv$iv$iv).getRawType();
                type = type3;
                Intrinsics.checkExpressionValueIsNotNull((Object)type3, (String)"type.rawType");
            } else {
                type = GsonBuilderKt.removeTypeWildcards((Type)type$iv$iv$iv);
            }
            Type type4 = type;
            Object t = ((Gson)((Object)throwable)).fromJson(string, type4);
            object = t;
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
        } else {
            $receiver$iv$iv = UtilsKt.convertToPath(any$iv);
            Charset charset = Charsets.UTF_8;
            type$iv$iv$iv = new OpenOption[]{};
            int n = 8192;
            boolean bl22 = false;
            $receiver$iv$iv = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)$receiver$iv$iv, Arrays.copyOf(type$iv$iv$iv, ((OpenOption[])type$iv$iv$iv).length)), charset), n);
            boolean bl3 = false;
            n = 0;
            throwable = null;
            try {
                Type type;
                Iterator it$iv = (BufferedReader)$receiver$iv$iv;
                boolean bl4 = false;
                void $receiver$iv$iv2 = $this$fromJson$iv;
                Reader $i$f$typeToken = (Reader)((Object)it$iv);
                void $i$f$fromJson2 = $receiver$iv$iv2;
                Type type4 = new TypeToken<List<? extends LibraryChange>>(){}.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)type4, (String)"object : TypeToken<T>() {} .type");
                Type type$iv$iv$iv2 = type4;
                if (type$iv$iv$iv2 instanceof ParameterizedType && GsonBuilderKt.isWildcard((ParameterizedType)type$iv$iv$iv2)) {
                    Type type5 = ((ParameterizedType)type$iv$iv$iv2).getRawType();
                    type = type5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)type5, (String)"type.rawType");
                } else {
                    type = GsonBuilderKt.removeTypeWildcards(type$iv$iv$iv2);
                }
                Type type7 = type;
                Object t = $i$f$fromJson2.fromJson($i$f$typeToken, type7);
                Intrinsics.checkExpressionValueIsNotNull(t, (String)"fromJson(json, typeToken<T>())");
                it$iv = t;
                object = it$iv;
            }
            catch (Throwable it$iv) {
                throwable = it$iv;
                throw it$iv;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$receiver$iv$iv, (Throwable)throwable);
            }
        }
        List libraryChanges = (List)object;
        Path path3 = newBundlerRoot.resolve("META-INF/versions.list");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"newBundlerRoot.resolve(FileEntry.VERSIONS_LIST)");
        List<FileEntry<String>> newVersions = FileEntry.Companion.parse(path3);
        Path path4 = newBundlerRoot.resolve("META-INF/libraries.list");
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"newBundlerRoot.resolve(FileEntry.LIBRARIES_LIST)");
        List newLibraries2 = FileEntry.Companion.parse(path4, (Function1)new Function1<String, ModuleId>(ModuleId.Companion){

            @NotNull
            public final ModuleId invoke(@NotNull String p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ModuleId.Companion)this.receiver).parse(p1);
            }
        });
        for (FileEntry fileEntry : newVersions) {
            FileEntry originalVersion;
            Object v13;
            block27: {
                $this$firstOrNull$iv = originalVersions;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv22 : $this$firstOrNull$iv) {
                    it = (FileEntry)element$iv22;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)((String)it.getId()), (Object)((String)fileEntry.getId()))) continue;
                    v13 = element$iv22;
                    break block27;
                }
                v13 = null;
            }
            if ((FileEntry)v13 == null) {
                continue;
            }
            if (Intrinsics.areEqual((Object)fileEntry.getHash(), (Object)originalVersion.getHash())) {
                EntryLocation.VERSION.removeEntry(rootDir, fileEntry.getPath());
                continue;
            }
            $this$firstOrNull$iv = patchJobs;
            WorkQueue workQueue = queue2;
            Intrinsics.checkNotNullExpressionValue((Object)workQueue, (String)"queue");
            PatchJob $i$f$firstOrNull = this.submitPatchJob(workQueue, rootDir, originalBundlerRoot, newBundlerRoot, originalVersion, fileEntry, EntryLocation.VERSION);
            boolean it$iv = false;
            $this$firstOrNull$iv.add($i$f$firstOrNull);
        }
        for (FileEntry fileEntry : newLibraries2) {
            Object v15;
            block28: {
                $this$firstOrNull$iv = originalLibraries2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    it = (FileEntry)element$iv2;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)((ModuleId)it.getId()), (Object)((ModuleId)fileEntry.getId()))) continue;
                    v15 = element$iv2;
                    break block28;
                }
                v15 = null;
            }
            if ((FileEntry)v15 == null) {
                continue;
            }
            if (Intrinsics.areEqual((Object)fileEntry.getPath(), (Object)((FileEntry)((Object)originalLibrary)).getPath()) ^ true && Intrinsics.areEqual((Object)fileEntry.getHash(), (Object)((FileEntry)((Object)originalLibrary)).getHash())) {
                throw (Throwable)new PaperweightException("Paperclip cannot currently handle non-patch libraries with new paths");
            }
            if (Intrinsics.areEqual((Object)fileEntry.getHash(), (Object)((FileEntry)((Object)originalLibrary)).getHash()) ^ true) {
                $this$firstOrNull$iv = patchJobs;
                WorkQueue workQueue = queue2;
                Intrinsics.checkNotNullExpressionValue((Object)workQueue, (String)"queue");
                PatchJob $i$f$firstOrNull = this.submitPatchJob(workQueue, rootDir, originalBundlerRoot, newBundlerRoot, (FileEntry<?>)((Object)originalLibrary), fileEntry, EntryLocation.LIBRARY);
                boolean it$iv = false;
                $this$firstOrNull$iv.add($i$f$firstOrNull);
                continue;
            }
            EntryLocation.LIBRARY.removeEntry(rootDir, fileEntry.getPath());
        }
        for (LibraryChange libraryChange : libraryChanges) {
            FileEntry newLibrary;
            PatchJob patchJob;
            Iterable $this$firstOrNull$iv2;
            block30: {
                Object v17;
                Object element$iv32;
                block29: {
                    $this$firstOrNull$iv = originalLibraries2;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv32 : $this$firstOrNull$iv) {
                        it = (FileEntry)element$iv32;
                        boolean bl7 = false;
                        if (!Intrinsics.areEqual((Object)((ModuleId)it.getId()), (Object)libraryChange.getInputId())) continue;
                        v17 = element$iv32;
                        break block29;
                    }
                    v17 = null;
                }
                if ((FileEntry)v17 == null) {
                    throw (Throwable)new PaperweightException("Unmatched library change, original id: " + libraryChange.getInputId());
                }
                $this$firstOrNull$iv2 = newLibraries2;
                boolean $i$f$firstOrNull = false;
                element$iv32 = $this$firstOrNull$iv2.iterator();
                while (element$iv32.hasNext()) {
                    element$iv = element$iv32.next();
                    FileEntry it2 = (FileEntry)((Object)element$iv);
                    boolean bl8 = false;
                    if (!Intrinsics.areEqual((Object)((ModuleId)it2.getId()), (Object)libraryChange.getOutputId())) continue;
                    patchJob = element$iv;
                    break block30;
                }
                patchJob = null;
            }
            if ((FileEntry)((Object)patchJob) == null) {
                throw (Throwable)new PaperweightException("Unmatched library change, new id: " + libraryChange.getOutputId());
            }
            $this$firstOrNull$iv2 = patchJobs;
            WorkQueue workQueue = queue2;
            Intrinsics.checkNotNullExpressionValue((Object)workQueue, (String)"queue");
            PatchJob patchJob2 = this.submitPatchJob(workQueue, rootDir, originalBundlerRoot, newBundlerRoot, (FileEntry<?>)((Object)originalLibrary), newLibrary, EntryLocation.LIBRARY);
            boolean element$iv32 = false;
            $this$firstOrNull$iv2.add(patchJob2);
        }
        queue2.await();
        Iterable iterable = patchJobs;
        boolean $i$f$map = false;
        originalLibrary = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void job;
            element$iv = (PatchJob)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl9 = false;
            Path patchLocation = EntryLocation.resolve$default(job.getEntryLocation(), rootDir, null, 2, null);
            String patchHash = FileKt.sha256asHex(job.getPatchFile());
            PatchEntry patchEntry = new PatchEntry(job.getEntryLocation(), job.getOriginalEntry().getHash(), patchHash, job.getNewEntry().getHash(), job.getOriginalEntry().getPath(), PathsKt.getInvariantSeparatorsPathString((Path)PathsKt.relativeTo((Path)job.getPatchFile(), (Path)patchLocation)), job.getNewEntry().getPath());
            collection.add(patchEntry);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final PatchJob submitPatchJob(WorkQueue $this$submitPatchJob, Path rootDir, Path originalRoot, Path newRoot, FileEntry<?> originalEntry, FileEntry<?> newEntry, EntryLocation location) {
        void workActionClass$iv;
        void $this$submit$iv;
        Path outputFile = location.resolve(rootDir, newEntry.getPath());
        FileKt.deleteForcefully(outputFile);
        StringBuilder stringBuilder = new StringBuilder();
        Path path = Paths.get(originalEntry.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(originalEntry.path)");
        Path patchFile = outputFile.resolveSibling(stringBuilder.append(PathsKt.getName((Path)path)).append(".patch").toString());
        Path originalFile = location.resolve(originalRoot, originalEntry.getPath());
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Object object = null;
        String string = null;
        boolean bl = false;
        Path path2 = Files.createTempFile((String)object, string, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Files.createTempFile(prefix, suffix, *attributes)");
        Path tempOriginal = path2;
        object = originalFile;
        boolean bl2 = true;
        boolean bl3 = false;
        Object object2 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, tempOriginal, Arrays.copyOf(object2, ((CopyOption[])object2).length)), (String)"Files.copy(this, target, *options)");
        Path newFile = location.resolve(newRoot, newEntry.getPath());
        FileAttribute[] fileAttributeArray2 = new FileAttribute[]{};
        Object object3 = null;
        object2 = null;
        boolean bl4 = false;
        Path path3 = Files.createTempFile((String)object3, (String)object2, Arrays.copyOf(fileAttributeArray2, fileAttributeArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Files.createTempFile(prefix, suffix, *attributes)");
        Path tempNew = path3;
        object3 = newFile;
        boolean bl5 = true;
        boolean bl6 = false;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object3, tempNew, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
        object3 = $this$submitPatchJob;
        Class<PaperclipAction> clazz = PaperclipAction.class;
        Action parameterAction$iv = new Action(tempOriginal, tempNew, patchFile){
            final /* synthetic */ Path $tempOriginal;
            final /* synthetic */ Path $tempNew;
            final /* synthetic */ Path $patchFile;

            public final void execute(@NotNull PaperclipParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$receiver");
                FileKt.set((FileSystemLocationProperty)$this$submit.getOriginalFile(), this.$tempOriginal);
                FileKt.set((FileSystemLocationProperty)$this$submit.getPatchedFile(), this.$tempNew);
                FileKt.set((FileSystemLocationProperty)$this$submit.getOutputFile(), this.$patchFile);
            }
            {
                this.$tempOriginal = path;
                this.$tempNew = path2;
                this.$patchFile = path3;
            }
        };
        boolean $i$f$submit = false;
        $this$submit$iv.submit((Class)workActionClass$iv, parameterAction$iv);
        Path path4 = patchFile;
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"patchFile");
        return new PatchJob(originalEntry, newEntry, path4, location);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$PaperclipAction;", "Lorg/gradle/workers/WorkAction;", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$PaperclipParameters;", "()V", "execute", "", "paperweight-lib"})
    public static abstract class PaperclipAction
    implements WorkAction<PaperclipParameters> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute() {
            boolean bl;
            Object object2;
            boolean bl5;
            Path outputFile = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((PaperclipParameters)this.getParameters()).getOutputFile()));
            Path originalFile = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((PaperclipParameters)this.getParameters()).getOriginalFile()));
            Path patchedFile = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((PaperclipParameters)this.getParameters()).getPatchedFile()));
            Path path = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((PaperclipParameters)this.getParameters()).getOriginalFile()));
            boolean bl2 = false;
            byte[] byArray2 = Files.readAllBytes(path);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"Files.readAllBytes(this)");
            byte[] originalBytes = byArray2;
            Object object = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)((PaperclipParameters)this.getParameters()).getPatchedFile()));
            boolean bl3 = false;
            byte[] byArray3 = Files.readAllBytes((Path)object);
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"Files.readAllBytes(this)");
            byte[] patchedBytes = byArray3;
            try {
                Path path2 = outputFile.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"outputFile.parent");
                object = path2;
                Object[] objectArray = new FileAttribute[]{};
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object, Arrays.copyOf(objectArray, objectArray.length)), (String)"Files.createDirectories(this, *attributes)");
                object = outputFile;
                objectArray = new OpenOption[]{};
                bl4 = false;
                OutputStream outputStream = Files.newOutputStream((Path)object, (OpenOption[])Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"Files.newOutputStream(this, *options)");
                object = outputStream;
                bl5 = false;
                bl4 = false;
                object2 = null;
                try {
                    OutputStream patchOutput = (OutputStream)object;
                    boolean bl6 = false;
                    Diff.diff(originalBytes, patchedBytes, patchOutput);
                    patchOutput = Unit.INSTANCE;
                }
                catch (Throwable patchOutput) {
                    object2 = patchOutput;
                    throw patchOutput;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                object = this;
                bl5 = false;
            }
            catch (Exception e) {
                try {
                    throw (Throwable)new PaperweightException("Error creating patch between " + originalFile + " and " + patchedFile, e);
                }
                catch (Throwable throwable) {
                    boolean bl9;
                    Object object3;
                    PaperclipAction paperclipAction = this;
                    boolean bl10 = false;
                    try {
                        object3 = Result.Companion;
                        PaperclipAction $this$runCatching32 = paperclipAction;
                        boolean bl11 = false;
                        FileKt.deleteForcefully(originalFile);
                        $this$runCatching32 = Unit.INSTANCE;
                        bl11 = false;
                        object3 = Result.constructor-impl((Object)$this$runCatching32);
                    }
                    catch (Throwable $this$runCatching32) {
                        Result.Companion bl11 = Result.Companion;
                        bl9 = false;
                        object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching32));
                    }
                    paperclipAction = this;
                    bl10 = false;
                    try {
                        object3 = Result.Companion;
                        PaperclipAction $this$runCatching = paperclipAction;
                        boolean bl12 = false;
                        FileKt.deleteForcefully(patchedFile);
                        Unit unit = Unit.INSTANCE;
                        boolean bl13 = false;
                        object3 = Result.constructor-impl((Object)unit);
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        Result.Companion companion = Result.Companion;
                        bl9 = false;
                        object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    throw throwable;
                }
            }
            try {
                object2 = Result.Companion;
                PaperclipAction $this$runCatching2 = (PaperclipAction)object;
                boolean bl7 = false;
                FileKt.deleteForcefully(originalFile);
                $this$runCatching2 = Unit.INSTANCE;
                bl7 = false;
                object2 = Result.constructor-impl((Object)$this$runCatching2);
            }
            catch (Throwable $this$runCatching2) {
                Result.Companion bl7 = Result.Companion;
                bl = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching2));
            }
            object = this;
            bl5 = false;
            try {
                object2 = Result.Companion;
                PaperclipAction $this$runCatching = (PaperclipAction)object;
                boolean bl8 = false;
                FileKt.deleteForcefully(patchedFile);
                Unit unit = Unit.INSTANCE;
                bl8 = false;
                object2 = Result.constructor-impl((Object)unit);
                return;
            }
            catch (Throwable throwable) {
                Result.Companion bl8 = Result.Companion;
                bl = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                return;
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$PaperclipParameters;", "Lorg/gradle/workers/WorkParameters;", "originalFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOriginalFile", "()Lorg/gradle/api/file/RegularFileProperty;", "outputFile", "getOutputFile", "patchedFile", "getPatchedFile", "paperweight-lib"})
    public static interface PaperclipParameters
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getOriginalFile();

        @NotNull
        public RegularFileProperty getPatchedFile();

        @NotNull
        public RegularFileProperty getOutputFile();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\r\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\r\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J9\u0010\u0015\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$PatchJob;", "", "originalEntry", "Lio/papermc/paperweight/util/data/FileEntry;", "newEntry", "patchFile", "Ljava/nio/file/Path;", "entryLocation", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "(Lio/papermc/paperweight/util/data/FileEntry;Lio/papermc/paperweight/util/data/FileEntry;Ljava/nio/file/Path;Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;)V", "getEntryLocation", "()Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "getNewEntry", "()Lio/papermc/paperweight/util/data/FileEntry;", "getOriginalEntry", "getPatchFile", "()Ljava/nio/file/Path;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "paperweight-lib"})
    public static final class PatchJob {
        @NotNull
        private final FileEntry<?> originalEntry;
        @NotNull
        private final FileEntry<?> newEntry;
        @NotNull
        private final Path patchFile;
        @NotNull
        private final EntryLocation entryLocation;

        @NotNull
        public final FileEntry<?> getOriginalEntry() {
            return this.originalEntry;
        }

        @NotNull
        public final FileEntry<?> getNewEntry() {
            return this.newEntry;
        }

        @NotNull
        public final Path getPatchFile() {
            return this.patchFile;
        }

        @NotNull
        public final EntryLocation getEntryLocation() {
            return this.entryLocation;
        }

        public PatchJob(@NotNull FileEntry<?> originalEntry, @NotNull FileEntry<?> newEntry, @NotNull Path patchFile, @NotNull EntryLocation entryLocation) {
            Intrinsics.checkNotNullParameter(originalEntry, (String)"originalEntry");
            Intrinsics.checkNotNullParameter(newEntry, (String)"newEntry");
            Intrinsics.checkNotNullParameter((Object)patchFile, (String)"patchFile");
            Intrinsics.checkNotNullParameter((Object)((Object)entryLocation), (String)"entryLocation");
            this.originalEntry = originalEntry;
            this.newEntry = newEntry;
            this.patchFile = patchFile;
            this.entryLocation = entryLocation;
        }

        @NotNull
        public final FileEntry<?> component1() {
            return this.originalEntry;
        }

        @NotNull
        public final FileEntry<?> component2() {
            return this.newEntry;
        }

        @NotNull
        public final Path component3() {
            return this.patchFile;
        }

        @NotNull
        public final EntryLocation component4() {
            return this.entryLocation;
        }

        @NotNull
        public final PatchJob copy(@NotNull FileEntry<?> originalEntry, @NotNull FileEntry<?> newEntry, @NotNull Path patchFile, @NotNull EntryLocation entryLocation) {
            Intrinsics.checkNotNullParameter(originalEntry, (String)"originalEntry");
            Intrinsics.checkNotNullParameter(newEntry, (String)"newEntry");
            Intrinsics.checkNotNullParameter((Object)patchFile, (String)"patchFile");
            Intrinsics.checkNotNullParameter((Object)((Object)entryLocation), (String)"entryLocation");
            return new PatchJob(originalEntry, newEntry, patchFile, entryLocation);
        }

        public static /* synthetic */ PatchJob copy$default(PatchJob patchJob, FileEntry fileEntry, FileEntry fileEntry2, Path path, EntryLocation entryLocation, int n, Object object) {
            if ((n & 1) != 0) {
                fileEntry = patchJob.originalEntry;
            }
            if ((n & 2) != 0) {
                fileEntry2 = patchJob.newEntry;
            }
            if ((n & 4) != 0) {
                path = patchJob.patchFile;
            }
            if ((n & 8) != 0) {
                entryLocation = patchJob.entryLocation;
            }
            return patchJob.copy(fileEntry, fileEntry2, path, entryLocation);
        }

        @NotNull
        public String toString() {
            return "PatchJob(originalEntry=" + this.originalEntry + ", newEntry=" + this.newEntry + ", patchFile=" + this.patchFile + ", entryLocation=" + (Object)((Object)this.entryLocation) + ")";
        }

        public int hashCode() {
            FileEntry<?> fileEntry = this.originalEntry;
            FileEntry<?> fileEntry2 = this.newEntry;
            Path path = this.patchFile;
            EntryLocation entryLocation = this.entryLocation;
            return (((fileEntry != null ? ((Object)fileEntry).hashCode() : 0) * 31 + (fileEntry2 != null ? ((Object)fileEntry2).hashCode() : 0)) * 31 + (path != null ? ((Object)path).hashCode() : 0)) * 31 + (entryLocation != null ? ((Object)((Object)entryLocation)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PatchJob)) break block3;
                    PatchJob patchJob = (PatchJob)object;
                    if (!Intrinsics.areEqual(this.originalEntry, patchJob.originalEntry) || !Intrinsics.areEqual(this.newEntry, patchJob.newEntry) || !Intrinsics.areEqual((Object)this.patchFile, (Object)patchJob.patchFile) || !Intrinsics.areEqual((Object)((Object)this.entryLocation), (Object)((Object)patchJob.entryLocation))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\b\u0010\"\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006$"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$PatchEntry;", "", "location", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "originalHash", "", "patchHash", "outputHash", "originalPath", "patchPath", "outputPath", "(Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getLocation", "()Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "getOriginalHash", "()Ljava/lang/String;", "getOriginalPath", "getOutputHash", "getOutputPath", "getPatchHash", "getPatchPath", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "paperweight-lib"})
    public static final class PatchEntry {
        @NotNull
        private final EntryLocation location;
        @NotNull
        private final String originalHash;
        @NotNull
        private final String patchHash;
        @NotNull
        private final String outputHash;
        @NotNull
        private final String originalPath;
        @NotNull
        private final String patchPath;
        @NotNull
        private final String outputPath;
        @NotNull
        public static final String PATCHES_LIST = "META-INF/patches.list";
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public String toString() {
            StringJoiner joiner = new StringJoiner("\t");
            joiner.add(this.location.getValue());
            joiner.add(this.originalHash);
            joiner.add(this.patchHash);
            joiner.add(this.outputHash);
            joiner.add(this.originalPath);
            joiner.add(this.patchPath);
            joiner.add(this.outputPath);
            String string = joiner.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"joiner.toString()");
            return string;
        }

        @NotNull
        public final EntryLocation getLocation() {
            return this.location;
        }

        @NotNull
        public final String getOriginalHash() {
            return this.originalHash;
        }

        @NotNull
        public final String getPatchHash() {
            return this.patchHash;
        }

        @NotNull
        public final String getOutputHash() {
            return this.outputHash;
        }

        @NotNull
        public final String getOriginalPath() {
            return this.originalPath;
        }

        @NotNull
        public final String getPatchPath() {
            return this.patchPath;
        }

        @NotNull
        public final String getOutputPath() {
            return this.outputPath;
        }

        public PatchEntry(@NotNull EntryLocation location, @NotNull String originalHash, @NotNull String patchHash, @NotNull String outputHash, @NotNull String originalPath, @NotNull String patchPath, @NotNull String outputPath) {
            Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
            Intrinsics.checkNotNullParameter((Object)originalHash, (String)"originalHash");
            Intrinsics.checkNotNullParameter((Object)patchHash, (String)"patchHash");
            Intrinsics.checkNotNullParameter((Object)outputHash, (String)"outputHash");
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            Intrinsics.checkNotNullParameter((Object)patchPath, (String)"patchPath");
            Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
            this.location = location;
            this.originalHash = originalHash;
            this.patchHash = patchHash;
            this.outputHash = outputHash;
            this.originalPath = originalPath;
            this.patchPath = patchPath;
            this.outputPath = outputPath;
        }

        @NotNull
        public final EntryLocation component1() {
            return this.location;
        }

        @NotNull
        public final String component2() {
            return this.originalHash;
        }

        @NotNull
        public final String component3() {
            return this.patchHash;
        }

        @NotNull
        public final String component4() {
            return this.outputHash;
        }

        @NotNull
        public final String component5() {
            return this.originalPath;
        }

        @NotNull
        public final String component6() {
            return this.patchPath;
        }

        @NotNull
        public final String component7() {
            return this.outputPath;
        }

        @NotNull
        public final PatchEntry copy(@NotNull EntryLocation location, @NotNull String originalHash, @NotNull String patchHash, @NotNull String outputHash, @NotNull String originalPath, @NotNull String patchPath, @NotNull String outputPath) {
            Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
            Intrinsics.checkNotNullParameter((Object)originalHash, (String)"originalHash");
            Intrinsics.checkNotNullParameter((Object)patchHash, (String)"patchHash");
            Intrinsics.checkNotNullParameter((Object)outputHash, (String)"outputHash");
            Intrinsics.checkNotNullParameter((Object)originalPath, (String)"originalPath");
            Intrinsics.checkNotNullParameter((Object)patchPath, (String)"patchPath");
            Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
            return new PatchEntry(location, originalHash, patchHash, outputHash, originalPath, patchPath, outputPath);
        }

        public static /* synthetic */ PatchEntry copy$default(PatchEntry patchEntry, EntryLocation entryLocation, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                entryLocation = patchEntry.location;
            }
            if ((n & 2) != 0) {
                string = patchEntry.originalHash;
            }
            if ((n & 4) != 0) {
                string2 = patchEntry.patchHash;
            }
            if ((n & 8) != 0) {
                string3 = patchEntry.outputHash;
            }
            if ((n & 0x10) != 0) {
                string4 = patchEntry.originalPath;
            }
            if ((n & 0x20) != 0) {
                string5 = patchEntry.patchPath;
            }
            if ((n & 0x40) != 0) {
                string6 = patchEntry.outputPath;
            }
            return patchEntry.copy(entryLocation, string, string2, string3, string4, string5, string6);
        }

        public int hashCode() {
            EntryLocation entryLocation = this.location;
            String string = this.originalHash;
            String string2 = this.patchHash;
            String string3 = this.outputHash;
            String string4 = this.originalPath;
            String string5 = this.patchPath;
            String string6 = this.outputPath;
            return ((((((entryLocation != null ? ((Object)((Object)entryLocation)).hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0)) * 31 + (string6 != null ? string6.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PatchEntry)) break block3;
                    PatchEntry patchEntry = (PatchEntry)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.location), (Object)((Object)patchEntry.location)) || !Intrinsics.areEqual((Object)this.originalHash, (Object)patchEntry.originalHash) || !Intrinsics.areEqual((Object)this.patchHash, (Object)patchEntry.patchHash) || !Intrinsics.areEqual((Object)this.outputHash, (Object)patchEntry.outputHash) || !Intrinsics.areEqual((Object)this.originalPath, (Object)patchEntry.originalPath) || !Intrinsics.areEqual((Object)this.patchPath, (Object)patchEntry.patchPath) || !Intrinsics.areEqual((Object)this.outputPath, (Object)patchEntry.outputPath)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$PatchEntry$Companion;", "", "()V", "PATCHES_LIST", "", "paperweight-lib"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u001c\u0010\f\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "removeEntry", "", "dir", "Ljava/nio/file/Path;", "path", "resolve", "VERSION", "LIBRARY", "paperweight-lib"})
    public static final abstract class EntryLocation
    extends Enum<EntryLocation> {
        public static final /* enum */ EntryLocation VERSION;
        public static final /* enum */ EntryLocation LIBRARY;
        private static final /* synthetic */ EntryLocation[] $VALUES;
        @NotNull
        private final String value;

        static {
            EntryLocation[] entryLocationArray = new EntryLocation[2];
            EntryLocation[] entryLocationArray2 = entryLocationArray;
            entryLocationArray[0] = VERSION = new VERSION("VERSION", 0);
            entryLocationArray[1] = LIBRARY = new LIBRARY("LIBRARY", 1);
            $VALUES = entryLocationArray;
        }

        @NotNull
        public abstract Path resolve(@NotNull Path var1, @Nullable String var2);

        public static /* synthetic */ Path resolve$default(EntryLocation entryLocation, Path path, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return entryLocation.resolve(path, string);
        }

        public final void removeEntry(@NotNull Path dir, @NotNull String path) {
            Iterable<Path> iterable;
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Path entryDir = EntryLocation.resolve$default(this, dir, null, 2, null);
            Path file = entryDir.resolve(path);
            do {
                Path path2 = file;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
                iterable = path2;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                boolean bl = false;
                if (!Files.exists((Path)iterable, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || !(Intrinsics.areEqual((Object)file, (Object)entryDir) ^ true)) break;
                FileKt.deleteForcefully(file);
                Path path3 = file = file.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"file");
                iterable = PathsKt.listDirectoryEntries$default((Path)path3, null, (int)1, null);
                boolean bl2 = false;
            } while (!(!iterable.isEmpty()));
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        private EntryLocation(String value) {
            this.value = value;
        }

        public /* synthetic */ EntryLocation(String $enum$name, int $enum$ordinal, String value, DefaultConstructorMarker $constructor_marker) {
            this(value);
        }

        public static EntryLocation[] values() {
            return (EntryLocation[])$VALUES.clone();
        }

        public static EntryLocation valueOf(String string) {
            return Enum.valueOf(EntryLocation.class, string);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation$VERSION;", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "resolve", "Ljava/nio/file/Path;", "dir", "path", "", "paperweight-lib"})
        static final class VERSION
        extends EntryLocation {
            @Override
            @NotNull
            public Path resolve(@NotNull Path dir, @Nullable String path) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Path base = dir.resolve("META-INF/versions");
                if (path == null) {
                    Path path2 = base;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"base");
                    return path2;
                }
                Path path3 = base.resolve(path);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"base.resolve(path)");
                return path3;
            }

            /*
             * WARNING - void declaration
             */
            VERSION() {
                void var1_1;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation$LIBRARY;", "Lio/papermc/paperweight/tasks/CreatePaperclipJar$EntryLocation;", "resolve", "Ljava/nio/file/Path;", "dir", "path", "", "paperweight-lib"})
        static final class LIBRARY
        extends EntryLocation {
            @Override
            @NotNull
            public Path resolve(@NotNull Path dir, @Nullable String path) {
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                Path base = dir.resolve("META-INF/libraries");
                if (path == null) {
                    Path path2 = base;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"base");
                    return path2;
                }
                Path path3 = base.resolve(path);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"base.resolve(path)");
                return path3;
            }

            /*
             * WARNING - void declaration
             */
            LIBRARY() {
                void var1_1;
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$DownloadContext;", "", "hash", "", "url", "fileName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFileName", "()Ljava/lang/String;", "getHash", "getUrl", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "paperweight-lib"})
    public static final class DownloadContext {
        @NotNull
        private final String hash;
        @NotNull
        private final String url;
        @NotNull
        private final String fileName;
        @NotNull
        public static final String FILE = "META-INF/download-context";
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public String toString() {
            return this.hash + '\t' + this.url + '\t' + this.fileName;
        }

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        public DownloadContext(@NotNull String hash2, @NotNull String url, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            this.hash = hash2;
            this.url = url;
            this.fileName = fileName;
        }

        @NotNull
        public final String component1() {
            return this.hash;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final String component3() {
            return this.fileName;
        }

        @NotNull
        public final DownloadContext copy(@NotNull String hash2, @NotNull String url, @NotNull String fileName) {
            Intrinsics.checkNotNullParameter((Object)hash2, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            return new DownloadContext(hash2, url, fileName);
        }

        public static /* synthetic */ DownloadContext copy$default(DownloadContext downloadContext, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = downloadContext.hash;
            }
            if ((n & 2) != 0) {
                string2 = downloadContext.url;
            }
            if ((n & 4) != 0) {
                string3 = downloadContext.fileName;
            }
            return downloadContext.copy(string, string2, string3);
        }

        public int hashCode() {
            String string = this.hash;
            String string2 = this.url;
            String string3 = this.fileName;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof DownloadContext)) break block3;
                    DownloadContext downloadContext = (DownloadContext)object;
                    if (!Intrinsics.areEqual((Object)this.hash, (Object)downloadContext.hash) || !Intrinsics.areEqual((Object)this.url, (Object)downloadContext.url) || !Intrinsics.areEqual((Object)this.fileName, (Object)downloadContext.fileName)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/papermc/paperweight/tasks/CreatePaperclipJar$DownloadContext$Companion;", "", "()V", "FILE", "", "paperweight-lib"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

