/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paperweight.tasks;

import io.papermc.paperweight.PaperweightException;
import io.papermc.paperweight.tasks.CreateBundlerJar;
import io.papermc.paperweight.tasks.ZippedTask;
import io.papermc.paperweight.util.FileKt;
import io.papermc.paperweight.util.UtilsKt;
import io.papermc.paperweight.util.data.FileEntry;
import io.papermc.paperweight.util.data.LibraryChange;
import io.papermc.paperweight.util.data.ModuleId;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.ResolvedVariantResult;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u001c\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0&0%2\u0006\u0010'\u001a\u00020(H\u0002J\u001c\u0010)\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0&0%2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020+2\u0006\u0010'\u001a\u00020(H\u0016J\u0014\u0010-\u001a\u00020(*\u00020\u001e2\u0006\u0010.\u001a\u00020(H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00108gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000bR\u0014\u0010\u0015\u001a\u00020\t8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000bR\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0018\u0010\u001c\u001a\u00020\u001d*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u00060"}, d2={"Lio/papermc/paperweight/tasks/CreateBundlerJar;", "Lio/papermc/paperweight/tasks/ZippedTask;", "()V", "libraryArtifacts", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/api/artifacts/Configuration;", "getLibraryArtifacts", "()Lorg/gradle/api/provider/Property;", "libraryChangesJson", "Lorg/gradle/api/file/RegularFileProperty;", "getLibraryChangesJson", "()Lorg/gradle/api/file/RegularFileProperty;", "mainClass", "", "getMainClass", "paperclip", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getPaperclip", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "serverLibrariesList", "getServerLibrariesList", "vanillaBundlerJar", "getVanillaBundlerJar", "versionArtifacts", "Lorg/gradle/api/NamedDomainObjectContainer;", "Lio/papermc/paperweight/tasks/CreateBundlerJar$VersionArtifact;", "getVersionArtifacts", "()Lorg/gradle/api/NamedDomainObjectContainer;", "module", "Lio/papermc/paperweight/util/data/ModuleId;", "Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;", "getModule", "(Lorg/gradle/api/artifacts/result/ResolvedArtifactResult;)Lio/papermc/paperweight/util/data/ModuleId;", "collectDependencies", "", "createVersionArtifactContainer", "handleServerDependencies", "", "Lio/papermc/paperweight/util/data/FileEntry;", "rootDir", "Ljava/nio/file/Path;", "handleVersions", "init", "", "run", "copyTo", "path", "VersionArtifact", "paperweight-lib"})
public abstract class CreateBundlerJar
extends ZippedTask {
    @NotNull
    private final NamedDomainObjectContainer<VersionArtifact> versionArtifacts = this.createVersionArtifactContainer();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getPaperclip();

    @Input
    @NotNull
    public abstract Property<String> getMainClass();

    @Nested
    @NotNull
    public final NamedDomainObjectContainer<VersionArtifact> getVersionArtifacts() {
        return this.versionArtifacts;
    }

    @Classpath
    @Optional
    @NotNull
    public abstract Property<Configuration> getLibraryArtifacts();

    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @NotNull
    public abstract RegularFileProperty getServerLibrariesList();

    @Classpath
    @NotNull
    public abstract RegularFileProperty getVanillaBundlerJar();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getLibraryChangesJson();

    /*
     * WARNING - void declaration
     */
    private final NamedDomainObjectContainer<VersionArtifact> createVersionArtifactContainer() {
        void elementType$iv;
        void $this$domainObjectContainer$iv;
        ObjectFactory objectFactory = this.getObjects();
        Class<VersionArtifact> clazz = VersionArtifact.class;
        NamedDomainObjectFactory factory$iv = new NamedDomainObjectFactory(this){
            final /* synthetic */ CreateBundlerJar this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final VersionArtifact create(@NotNull String it) {
                void $this$newInstance$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ObjectFactory objectFactory = this.this$0.getObjects();
                Object[] parameters$iv = new Object[]{it};
                boolean $i$f$newInstance = false;
                return (VersionArtifact)$this$newInstance$iv.newInstance(VersionArtifact.class, Arrays.copyOf(parameters$iv, parameters$iv.length));
            }
            {
                this.this$0 = createBundlerJar;
            }
        };
        boolean $i$f$domainObjectContainer = false;
        NamedDomainObjectContainer namedDomainObjectContainer = $this$domainObjectContainer$iv.domainObjectContainer((Class)elementType$iv, factory$iv);
        Intrinsics.checkNotNullExpressionValue((Object)namedDomainObjectContainer, (String)"`domainObjectContainer`(\u2026entType`.java, `factory`)");
        return namedDomainObjectContainer;
    }

    @Override
    public void init() {
        super.init();
        this.getLibraryChangesJson().convention((Provider)UtilsKt.defaultOutput(this, this.getName() + "-library-changes", "json"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(@NotNull Path rootDir) {
        boolean $i$f$sortedBy;
        Iterable $this$sortedBy$iv;
        boolean bl;
        OpenOption[] writer2;
        Object zip2;
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        Path path = this.getPaperclip().getSingleFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"paperclip.singleFile.toPath()");
        Closeable closeable = FileKt.openZip(path);
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            zip2 = (FileSystem)closeable;
            boolean bl4 = false;
            Path path2 = ((FileSystem)zip2).getPath("/", new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"zip.getPath(\"/\")");
            FileKt.copyRecursivelyTo(path2, rootDir);
            zip2 = Unit.INSTANCE;
        }
        catch (Throwable zip2) {
            throwable = zip2;
            throw zip2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        List<FileEntry<String>> versions = this.handleVersions(rootDir);
        List<FileEntry<ModuleId>> libraries = this.handleServerDependencies(rootDir);
        zip2 = rootDir.resolve("META-INF/versions.list");
        boolean bl5 = false;
        boolean bl6 = false;
        Object it = zip2;
        boolean bl7 = false;
        Object object = it;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
        Path path3 = object.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"it.parent");
        Path path4 = path3;
        Object object2 = new FileAttribute[]{};
        boolean bl8 = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path4, Arrays.copyOf(object2, ((FileAttribute[])object2).length)), (String)"Files.createDirectories(this, *attributes)");
        Object versionsFile = zip2;
        Object object3 = rootDir.resolve("META-INF/libraries.list");
        bl6 = false;
        int n = 0;
        OpenOption[] it2 = object3;
        boolean bl9 = false;
        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
        Path path5 = it2.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"it.parent");
        object2 = path5;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        boolean bl10 = false;
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
        OpenOption[] librariesFile = object3;
        Object object4 = versionsFile;
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"versionsFile");
        object3 = object4;
        it2 = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        n = 8192;
        bl9 = false;
        object3 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object3, Arrays.copyOf(it2, it2.length)), charset), n);
        boolean bl11 = false;
        n = 0;
        Throwable throwable2 = null;
        try {
            writer2 = object3;
            bl = false;
            $this$sortedBy$iv = versions;
            $i$f$sortedBy = false;
            bl10 = false;
            for (FileEntry v : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    FileEntry it = (FileEntry)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)((String)it.getId()));
                    it = (FileEntry)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = (String)it.getId();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            })) {
                writer2.append(v.toString()).append('\n');
            }
            writer2 = Unit.INSTANCE;
        }
        catch (Throwable writer2) {
            throwable2 = writer2;
            throw writer2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)librariesFile, (String)"librariesFile");
        object3 = librariesFile;
        writer2 = new OpenOption[]{};
        Charset charset2 = Charsets.UTF_8;
        int n2 = 8192;
        bl = false;
        object3 = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object3, Arrays.copyOf(writer2, writer2.length)), charset2), n2);
        boolean bl12 = false;
        n2 = 0;
        Throwable throwable3 = null;
        try {
            writer2 = (BufferedWriter)object3;
            boolean bl13 = false;
            $this$sortedBy$iv = libraries;
            $i$f$sortedBy = false;
            bl10 = false;
            for (FileEntry l : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    FileEntry it = (FileEntry)a;
                    boolean bl2 = false;
                    Comparable comparable = (ModuleId)it.getId();
                    it = (FileEntry)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    ModuleId moduleId = (ModuleId)it.getId();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)moduleId);
                }
            })) {
                writer2.append(l.toString()).append('\n');
            }
            writer2 = Unit.INSTANCE;
        }
        catch (Throwable writer2) {
            throwable3 = writer2;
            throw writer2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable3);
        }
        Path path6 = rootDir.resolve("META-INF/main-class");
        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"rootDir.resolve(\"META-INF/main-class\")");
        Object object5 = this.getMainClass().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"mainClass.get()");
        PathsKt.writeText$default((Path)path6, (CharSequence)((CharSequence)object5), null, (OpenOption[])new OpenOption[0], (int)2, null);
        object3 = FileKt.openZip(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getVanillaBundlerJar())));
        bl12 = false;
        boolean bl14 = false;
        Throwable throwable4 = null;
        try {
            FileSystem fs = (FileSystem)object3;
            boolean bl15 = false;
            Path path7 = fs.getPath("/", new String[0]).resolve("version.json");
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"fs.getPath(\"/\").resolve(FileEntry.VERSION_JSON)");
            object2 = path7;
            Path path8 = rootDir.resolve("version.json");
            Intrinsics.checkNotNullExpressionValue((Object)path8, (String)"rootDir.resolve(\"version.json\")");
            Path path9 = path8;
            bl10 = false;
            boolean bl16 = false;
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Path path10 = Files.copy((Path)object2, path9, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path10, (String)"Files.copy(this, target, *options)");
            Path path11 = path10;
        }
        catch (Throwable throwable5) {
            throwable4 = throwable5;
            throw throwable5;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<FileEntry<ModuleId>> handleServerDependencies(Path rootDir) {
        Object id;
        boolean bl = false;
        List libraries = new ArrayList();
        boolean bl2 = false;
        List changedLibraries = new ArrayList();
        List serverLibraryEntries2 = FileEntry.Companion.parse(FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getServerLibrariesList())), (Function1)new Function1<String, ModuleId>(ModuleId.Companion){

            @NotNull
            public final ModuleId invoke(@NotNull String p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ModuleId.Companion)this.receiver).parse(p1);
            }
        });
        Path outputDir = rootDir.resolve("META-INF/libraries");
        Set<ResolvedArtifactResult> dependencies = this.collectDependencies();
        for (ResolvedArtifactResult dep : dependencies) {
            boolean bl3;
            FileEntry<Object> fileEntry;
            Path jarFile;
            Object object;
            Object v0;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            block9: {
                $this$firstOrNull$iv = serverLibraryEntries2;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    FileEntry it = (FileEntry)element$iv;
                    boolean bl4 = false;
                    if (!(Intrinsics.areEqual((Object)((ModuleId)it.getId()).getGroup(), (Object)this.getModule(dep).getGroup()) && Intrinsics.areEqual((Object)((ModuleId)it.getId()).getName(), (Object)this.getModule(dep).getName()))) continue;
                    v0 = element$iv;
                    break block9;
                }
                v0 = null;
            }
            FileEntry serverLibrary = v0;
            if (serverLibrary != null) {
                if (Intrinsics.areEqual((Object)((ModuleId)serverLibrary.getId()).getVersion(), (Object)this.getModule(dep).getVersion())) {
                    $this$firstOrNull$iv = libraries;
                    $i$f$firstOrNull = false;
                    $this$firstOrNull$iv.add(serverLibrary);
                    Path path = outputDir.resolve(this.getModule(dep).toPath());
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputDir.resolve(dep.module.toPath())");
                    this.copyTo(dep, path);
                    continue;
                }
                ModuleId newId = this.getModule(dep);
                String newPath = newId.toPath();
                Collection collection = changedLibraries;
                object = new LibraryChange((ModuleId)serverLibrary.getId(), serverLibrary.getPath(), newId, newPath);
                boolean bl5 = false;
                collection.add(object);
                Path path = outputDir.resolve(newPath);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputDir.resolve(newPath)");
                jarFile = this.copyTo(dep, path);
                object = libraries;
                fileEntry = new FileEntry<ModuleId>(FileKt.sha256asHex(jarFile), newId, newPath);
                bl3 = false;
                object.add(fileEntry);
                continue;
            }
            id = this.getModule(dep);
            String path = ((ModuleId)id).toPath();
            Path path2 = outputDir.resolve(path);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"outputDir.resolve(path)");
            jarFile = this.copyTo(dep, path2);
            object = libraries;
            fileEntry = new FileEntry<Object>(FileKt.sha256asHex(jarFile), id, path);
            bl3 = false;
            object.add(fileEntry);
        }
        UtilsKt.ensureParentExists(this.getLibraryChangesJson());
        Object object = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)this.getLibraryChangesJson()));
        id = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean path = false;
        Object object2 = id;
        object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, (OpenOption[])Arrays.copyOf(object2, ((Object)object2).length)), charset), n);
        boolean bl6 = false;
        n = 0;
        Throwable throwable = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl7 = false;
            UtilsKt.getGson().toJson((Object)changedLibraries, (Appendable)writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return libraries;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FileEntry<String>> handleVersions(Path rootDir) {
        void $this$mapTo$iv$iv;
        Path outputDir = rootDir.resolve("META-INF/versions");
        Iterable $this$map$iv = (Iterable)this.versionArtifacts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void versionArtifact;
            VersionArtifact versionArtifact2 = (VersionArtifact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = versionArtifact.getId().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"versionArtifact.id.get()");
            String id = (String)object;
            String versionPath = id + '/' + versionArtifact.getName() + '-' + id + ".jar";
            Path inputFile = FileKt.getPath((Provider<? extends FileSystemLocation>)((Provider)versionArtifact.getFile()));
            Path outputFile = outputDir.resolve(versionPath);
            Object[] objectArray = new Object[1];
            Path path = outputFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputFile");
            objectArray[0] = path;
            UtilsKt.ensureParentExists(objectArray);
            Path path2 = inputFile;
            Path path3 = outputFile;
            boolean bl2 = false;
            boolean bl3 = false;
            CopyOption[] copyOptionArray = new CopyOption[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path2, path3, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
            FileEntry<String> fileEntry = new FileEntry<String>(FileKt.sha256asHex(inputFile), id, versionPath);
            collection.add(fileEntry);
        }
        return (List)destination$iv$iv;
    }

    private final Set<ResolvedArtifactResult> collectDependencies() {
        boolean bl = false;
        Object object = this.getLibraryArtifacts().map((Transformer)collectDependencies.1.INSTANCE).getOrElse(new HashSet());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"libraryArtifacts.map { c\u2026esolvedArtifactResult>())");
        return (Set)object;
    }

    private final Path copyTo(ResolvedArtifactResult $this$copyTo, Path path) {
        UtilsKt.ensureParentExists(path);
        Path path2 = $this$copyTo.getFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file.toPath()");
        Path path3 = path2;
        boolean bl = true;
        boolean bl2 = false;
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Path path4 = Files.copy(path3, path, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"Files.copy(this, target, *options)");
        return path4;
    }

    private final ModuleId getModule(ResolvedArtifactResult $this$module) {
        ModuleId moduleId;
        ComponentArtifactIdentifier componentArtifactIdentifier = $this$module.getId();
        Intrinsics.checkNotNullExpressionValue((Object)componentArtifactIdentifier, (String)"id");
        ComponentIdentifier componentIdentifier = componentArtifactIdentifier.getComponentIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)componentIdentifier, (String)"id.componentIdentifier");
        ComponentIdentifier ident = componentIdentifier;
        if (ident instanceof ModuleComponentIdentifier) {
            moduleId = ModuleId.Companion.fromIdentifier((ModuleComponentIdentifier)ident);
        } else if (ident instanceof ProjectComponentIdentifier) {
            Capability capability;
            ResolvedVariantResult resolvedVariantResult = $this$module.getVariant();
            Intrinsics.checkNotNullExpressionValue((Object)resolvedVariantResult, (String)"variant");
            List list = resolvedVariantResult.getCapabilities();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.capabilities");
            Capability capability2 = capability = (Capability)CollectionsKt.single((List)list);
            Intrinsics.checkNotNullExpressionValue((Object)capability2, (String)"capability");
            String string = capability2.getVersion();
            if (string == null) {
                throw (Throwable)new PaperweightException("Unknown version for " + capability.getGroup() + ':' + capability.getName());
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"capability.version ?: th\u2026oup}:${capability.name}\")");
            String version = string;
            String string2 = capability.getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"capability.group");
            String string3 = capability.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"capability.name");
            moduleId = new ModuleId(string2, string3, version);
        } else {
            throw (Throwable)new PaperweightException("Unknown artifact result type: " + ident.getClass().getName());
        }
        return moduleId;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000e\u00c0\u0006\u0001"}, d2={"Lio/papermc/paperweight/tasks/CreateBundlerJar$VersionArtifact;", "", "file", "Lorg/gradle/api/file/RegularFileProperty;", "getFile", "()Lorg/gradle/api/file/RegularFileProperty;", "id", "Lorg/gradle/api/provider/Property;", "", "getId", "()Lorg/gradle/api/provider/Property;", "name", "getName", "()Ljava/lang/String;", "paperweight-lib"})
    public static interface VersionArtifact {
        @Input
        @NotNull
        public String getName();

        @Input
        @NotNull
        public Property<String> getId();

        @Classpath
        @NotNull
        public RegularFileProperty getFile();
    }
}

